/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import me.konloch.kontainer.io.HTTPRequest;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.APKTool;
import the.bytecode.club.bytecodeviewer.Boot;
import the.bytecode.club.bytecodeviewer.CommandLineInput;
import the.bytecode.club.bytecodeviewer.Dex2Jar;
import the.bytecode.club.bytecodeviewer.Enjarify;
import the.bytecode.club.bytecodeviewer.FileContainer;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.MiscUtils;
import the.bytecode.club.bytecodeviewer.SecurityMan;
import the.bytecode.club.bytecodeviewer.Settings;
import the.bytecode.club.bytecodeviewer.api.ClassNodeLoader;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.compilers.Compiler;
import the.bytecode.club.bytecodeviewer.gui.ClassViewer;
import the.bytecode.club.bytecodeviewer.gui.FileNavigationPane;
import the.bytecode.club.bytecodeviewer.gui.MainViewerGUI;
import the.bytecode.club.bytecodeviewer.gui.RunOptions;
import the.bytecode.club.bytecodeviewer.gui.SearchingPane;
import the.bytecode.club.bytecodeviewer.gui.SystemErrConsole;
import the.bytecode.club.bytecodeviewer.gui.WorkPane;
import the.bytecode.club.bytecodeviewer.obfuscators.mapping.Refactorer;
import the.bytecode.club.bytecodeviewer.plugin.PluginManager;

public class BytecodeViewer {
    public static final String version = "3.0.0";
    public static final String krakatauVersion = "8";
    public static final String enjarifyVersion = "2";
    public static final boolean previewCopy = false;
    public static final String fs = System.getProperty("file.separator");
    public static final String nl = System.getProperty("line.separator");
    public static final File dataDir = new File(System.getProperty("user.home") + fs + ".Bytecode-Viewer");
    public static final File filesFile = new File(dataDir, "recentfiles.bcv");
    public static final File pluginsFile = new File(dataDir, "recentplugins.bcv");
    public static final File settingsFile = new File(dataDir, "settings.bcv");
    public static final File krakatauDirectory = new File(dataDir + fs + "krakatau_" + "8" + fs + "Krakatau-master");
    public static final File enjarifyDirectory = new File(dataDir + fs + "enjarify_" + "2" + fs + "enjarify-master");
    @Deprecated
    public static final File tempDir = new File(dataDir, "bcv_temp");
    private static final long start = System.currentTimeMillis();
    public static MainViewerGUI viewer = null;
    public static ClassNodeLoader loader = new ClassNodeLoader();
    public static SecurityMan sm = new SecurityMan();
    public static ArrayList<FileContainer> files = new ArrayList();
    private static int maxRecentFiles = 25;
    private static List<String> recentFiles = new ArrayList<String>();
    private static List<String> recentPlugins = new ArrayList<String>();
    public static boolean runningObfuscation = false;
    public static String lastDirectory = "";
    public static ArrayList<Process> createdProcesses = new ArrayList();
    public static Refactorer refactorer = new Refactorer();
    public static boolean pingback = false;
    private static final Thread versionChecker = new Thread(){

        @Override
        public void run() {
            block19: {
                try {
                    HTTPRequest r = new HTTPRequest(new URL("https://raw.githubusercontent.com/Konloch/bytecode-viewer/master/VERSION"));
                    final String version = r.readSingle();
                    try {
                        int simplemaths = Integer.parseInt(version.replace(".", ""));
                        int simplemaths2 = Integer.parseInt(BytecodeViewer.version.replace(".", ""));
                        if (simplemaths2 > simplemaths) {
                            return;
                        }
                    }
                    catch (Exception simplemaths) {
                        // empty catch block
                    }
                    if (BytecodeViewer.version.equals(version)) break block19;
                    r = new HTTPRequest(new URL("https://raw.githubusercontent.com/Konloch/bytecode-viewer/master/README.txt"));
                    String[] readme = r.read();
                    String changelog = "Unable to load change log, please try again later." + nl;
                    boolean trigger = false;
                    boolean finalTrigger = false;
                    for (String st : readme) {
                        if (st.equals("--- 3.0.0 ---:")) {
                            changelog = "";
                            trigger = true;
                            continue;
                        }
                        if (!trigger) continue;
                        if (st.startsWith("--- ")) {
                            finalTrigger = true;
                        }
                        if (!finalTrigger) continue;
                        changelog = changelog + st + nl;
                    }
                    JOptionPane pane = new JOptionPane("Your version: 3.0.0, latest version: " + version + nl + nl + "Changes since your version:" + nl + changelog + nl + "What would you like to do?");
                    Object[] options = new String[]{"Open The Download Page", "Download The Updated Jar", "Do Nothing"};
                    pane.setOptions(options);
                    JDialog dialog = pane.createDialog(viewer, "Bytecode Viewer - Outdated Version");
                    dialog.setVisible(true);
                    Object obj = pane.getValue();
                    int result = -1;
                    for (int k = 0; k < options.length; ++k) {
                        if (!options[k].equals(obj)) continue;
                        result = k;
                    }
                    if (result == 0) {
                        if (Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(new URI("https://github.com/Konloch/bytecode-viewer/releases"));
                        } else {
                            BytecodeViewer.showMessage("Cannot open the page, please manually type it." + nl + "https://github.com/Konloch/bytecode-viewer/releases");
                        }
                    }
                    if (result != 1) break block19;
                    JFileChooser fc = new JFileChooser();
                    try {
                        fc.setCurrentDirectory(new File(".").getAbsoluteFile());
                    }
                    catch (Exception e) {
                        new ExceptionUI(e);
                    }
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || MiscUtils.extension(f.getAbsolutePath()).equals("zip");
                        }

                        @Override
                        public String getDescription() {
                            return "Zip Archives";
                        }
                    });
                    fc.setFileHidingEnabled(false);
                    fc.setAcceptAllFileFilterUsed(false);
                    int returnVal = fc.showSaveDialog(viewer);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        if (!file.getAbsolutePath().endsWith(".zip")) {
                            file = new File(file.getAbsolutePath() + ".zip");
                        }
                        if (file.exists()) {
                            pane = new JOptionPane("The file " + file + " exists, would you like to overwrite it?");
                            options = new String[]{"Yes", "No"};
                            pane.setOptions(options);
                            dialog = pane.createDialog(viewer, "Bytecode Viewer - Overwrite File");
                            dialog.setVisible(true);
                            obj = pane.getValue();
                            result = -1;
                            for (int k = 0; k < options.length; ++k) {
                                if (!options[k].equals(obj)) continue;
                                result = k;
                            }
                            if (result != 0) {
                                return;
                            }
                            file.delete();
                        }
                        final File finalFile = file;
                        Thread downloadThread = new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    InputStream is = new URL("https://github.com/Konloch/bytecode-viewer/releases/download/v" + version + "/BytecodeViewer." + version + ".zip").openConnection().getInputStream();
                                    FileOutputStream fos = new FileOutputStream(finalFile);
                                    try {
                                        int len;
                                        System.out.println("Downloading from https://github.com/Konloch/bytecode-viewer/releases/download/v" + version + "/BytecodeViewer." + version + ".zip");
                                        byte[] buffer = new byte[8192];
                                        int downloaded = 0;
                                        boolean flag = false;
                                        BytecodeViewer.showMessage("Downloading the jar in the background, when it's finished you will be alerted with another message box." + nl + nl + "Expect this to take several minutes.");
                                        while ((len = is.read(buffer)) > 0) {
                                            fos.write(buffer, 0, len);
                                            fos.flush();
                                            int mbs = (downloaded += 8192) / 0x100000;
                                            if (mbs % 5 == 0 && mbs != 0) {
                                                if (!flag) {
                                                    System.out.println("Downloaded " + mbs + "MBs so far");
                                                }
                                                flag = true;
                                                continue;
                                            }
                                            flag = false;
                                        }
                                    }
                                    finally {
                                        try {
                                            if (is != null) {
                                                is.close();
                                            }
                                        }
                                        finally {
                                            if (fos != null) {
                                                fos.flush();
                                                fos.close();
                                            }
                                        }
                                    }
                                    System.out.println("Download finished!");
                                    BytecodeViewer.showMessage("Download successful! You can find the updated program at " + finalFile.getAbsolutePath());
                                }
                                catch (FileNotFoundException e) {
                                    BytecodeViewer.showMessage("Unable to download, the zip file has not been uploaded yet, please try again in about 10 minutes.");
                                }
                                catch (Exception e) {
                                    new ExceptionUI(e);
                                }
                            }
                        };
                        downloadThread.start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    };
    private static final Thread PingBack = new Thread(){

        @Override
        public void run() {
            try {
                new HTTPRequest(new URL("https://bytecodeviewer.com/add.php")).read();
            }
            catch (Exception e) {
                pingback = false;
            }
        }
    };
    private static boolean update = true;
    private static ArrayList<String> killList = new ArrayList();
    private static ArrayList<String> killList2 = new ArrayList();
    public static ArrayList<String> createdRandomizedNames = new ArrayList();
    private static long last = System.currentTimeMillis();

    private BytecodeViewer() {
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
        try {
            System.setSecurityManager(sm);
            System.out.println("https://the.bytecode.club - Created by @Konloch and @samczsun - Bytecode Viewer 3.0.0");
            CommandLineInput input = new CommandLineInput(args);
            if (!dataDir.exists() && !dataDir.mkdirs()) {
                throw new RuntimeException("Could not create working directory");
            }
            if (!settingsFile.exists() && !settingsFile.createNewFile()) {
                throw new RuntimeException("Could not create settings file");
            }
            if (!filesFile.exists() && !filesFile.createNewFile()) {
                throw new RuntimeException("Could not create recent files file");
            }
            if (!pluginsFile.exists() && !pluginsFile.createNewFile()) {
                throw new RuntimeException("Could not create recent plugins file");
            }
            recentFiles.addAll(FileUtils.readLines((File)filesFile, (String)"UTF-8"));
            recentPlugins.addAll(FileUtils.readLines((File)pluginsFile, (String)"UTF-8"));
            int CLI = input.parseCommandLine();
            if (CLI == CommandLineInput.STOP) {
                return;
            }
            if (CLI == CommandLineInput.OPEN_FILE) {
                Settings.loadSettings();
                viewer = new MainViewerGUI();
                Boot.boot();
                BytecodeViewer.BOOT(args, false);
            } else {
                BytecodeViewer.BOOT(args, true);
                input.executeCommandLine();
            }
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
    }

    public static void pingback() {
        JOptionPane pane = new JOptionPane("Would you like to 'pingback' to https://bytecodeviewer.com to be counted in the global users for BCV?");
        Object[] options = new String[]{"Yes", "No"};
        pane.setOptions(options);
        JDialog dialog = pane.createDialog(viewer, "Bytecode Viewer - Optional Pingback");
        dialog.setVisible(true);
        Object obj = pane.getValue();
        int result = -1;
        for (int k = 0; k < options.length; ++k) {
            if (!options[k].equals(obj)) continue;
            result = k;
        }
        if (result == 0) {
            try {
                if (!PingBack.isAlive()) {
                    PingBack.start();
                }
            }
            catch (Exception e) {
                new ExceptionUI(e);
            }
        }
    }

    public static void BOOT(String[] args, boolean cli) {
        BytecodeViewer.cleanup();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (Process proc : createdProcesses) {
                    proc.destroy();
                }
                try {
                    FileUtils.writeLines((File)filesFile, (Collection)recentFiles);
                    FileUtils.writeLines((File)pluginsFile, (Collection)recentPlugins);
                }
                catch (IOException e) {
                    new ExceptionUI(e);
                }
                Settings.saveSettings();
                BytecodeViewer.cleanup();
            }
        });
        viewer.calledAfterLoad();
        BytecodeViewer.resetRecentFilesMenu();
        if (!pingback) {
            PingBack.start();
            pingback = true;
        }
        if (BytecodeViewer.viewer.updateCheck.isSelected()) {
            versionChecker.start();
        }
        if (!cli) {
            viewer.setVisible(true);
        }
        System.out.println("Start up took " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        if (!cli && args.length >= 1) {
            for (String s : args) {
                BytecodeViewer.openFiles(new File[]{new File(s)}, true);
            }
        }
    }

    public static void exit(int i) {
    }

    public static ClassNode getCurrentlyOpenedClassNode() {
        return BytecodeViewer.viewer.workPane.getCurrentViewer().cn;
    }

    public static ClassNode getClassNode(String containerName, String name) {
        for (FileContainer container : files) {
            if (!container.name.equals(containerName) || !container.getData().containsKey(name + ".class")) continue;
            return container.getClassNode(name);
        }
        return null;
    }

    public static byte[] getClassBytes(String containerName, String name) {
        for (FileContainer container : files) {
            if (!container.name.equals(containerName) || !container.getData().containsKey(name)) continue;
            return container.getData().get(name);
        }
        return null;
    }

    public static byte[] getFileContents(String name) {
        for (FileContainer container : files) {
            HashMap<String, byte[]> files = container.files;
            if (!files.containsKey(name)) continue;
            return files.get(name);
        }
        return null;
    }

    public static void updateNode(ClassNode oldNode, ClassNode newNode) {
        for (FileContainer container : files) {
            if (!container.remove(oldNode)) continue;
            container.add(newNode);
        }
    }

    public static ArrayList<ClassNode> getLoadedClasses() {
        ArrayList<ClassNode> a = new ArrayList<ClassNode>();
        for (FileContainer container : files) {
            for (ClassNode c : container.values()) {
                if (a.contains(c)) continue;
                a.add(c);
            }
        }
        return a;
    }

    public static ArrayList<ClassNode> loadAllClasses() {
        ArrayList<ClassNode> a = new ArrayList<ClassNode>();
        for (FileContainer container : files) {
            for (String s : container.files.keySet()) {
                ClassNode loaded = container.getClassNode(s.substring(0, s.length() - 6));
                if (loaded == null) continue;
                a.add(loaded);
            }
        }
        return a;
    }

    public static Map<String, byte[]> getLoadedBytes() {
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        for (FileContainer container : files) {
            data.putAll(container.getData());
        }
        return data;
    }

    public static boolean compile(boolean message) {
        viewer.setIcon(true);
        boolean actuallyTried = false;
        for (Component c : BytecodeViewer.viewer.workPane.getLoadedViewers()) {
            ClassNode newNode;
            ClassNode origNode;
            int i;
            if (!(c instanceof ClassViewer)) continue;
            ClassViewer cv = (ClassViewer)c;
            boolean valid = false;
            for (i = 0; i < cv.panels.size(); ++i) {
                if (cv.smalis.get(i) == null || !cv.smalis.get(i).isEditable()) continue;
                valid = true;
            }
            if (valid) {
                actuallyTried = true;
                Object[] smali = cv.getSmali();
                if (smali != null) {
                    origNode = (ClassNode)smali[0];
                    String smaliText = (String)smali[1];
                    byte[] smaliCompiled = Compiler.smali.compile(smaliText, origNode.name);
                    if (smaliCompiled != null) {
                        newNode = JarUtils.getNode(smaliCompiled);
                        BytecodeViewer.updateNode(origNode, newNode);
                    } else {
                        BytecodeViewer.showMessage("There has been an error with assembling your Smali code, please check this. Class: " + origNode.name);
                        viewer.setIcon(false);
                        return false;
                    }
                }
            }
            valid = false;
            for (i = 0; i < cv.panels.size(); ++i) {
                if (cv.krakataus.get(i) == null || !cv.krakataus.get(i).isEditable()) continue;
                valid = true;
            }
            if (valid) {
                actuallyTried = true;
                Object[] krakatau = cv.getKrakatau();
                if (krakatau != null) {
                    origNode = (ClassNode)krakatau[0];
                    String krakatauText = (String)krakatau[1];
                    byte[] krakatauCompiled = Compiler.krakatau.compile(krakatauText, origNode.name);
                    if (krakatauCompiled != null) {
                        newNode = JarUtils.getNode(krakatauCompiled);
                        BytecodeViewer.updateNode(origNode, newNode);
                    } else {
                        BytecodeViewer.showMessage("There has been an error with assembling your Krakatau Bytecode, please check this. Class: " + origNode.name);
                        viewer.setIcon(false);
                        return false;
                    }
                }
            }
            valid = false;
            for (int i2 = 0; i2 < cv.panels.size(); ++i2) {
                if (cv.javas.get(i2) == null || !cv.javas.get(i2).isEditable()) continue;
                valid = true;
            }
            if (!valid) continue;
            actuallyTried = true;
            Object[] java = cv.getJava();
            if (java == null) continue;
            origNode = (ClassNode)java[0];
            String javaText = (String)java[1];
            SystemErrConsole errConsole = new SystemErrConsole("Java Compile Issues");
            errConsole.setText("Error compiling class: " + origNode.name + nl + "Keep in mind most decompilers cannot produce compilable classes" + nl + nl);
            byte[] javaCompiled = Compiler.java.compile(javaText, origNode.name);
            if (javaCompiled != null) {
                ClassNode newNode2 = JarUtils.getNode(javaCompiled);
                BytecodeViewer.updateNode(origNode, newNode2);
                errConsole.finished();
                continue;
            }
            errConsole.pretty();
            errConsole.setVisible(true);
            errConsole.finished();
            viewer.setIcon(false);
            return false;
        }
        if (message) {
            if (actuallyTried) {
                BytecodeViewer.showMessage("Compiled Successfully.");
            } else {
                BytecodeViewer.showMessage("You have no editable panes opened, make one editable and try again.");
            }
        }
        viewer.setIcon(false);
        return true;
    }

    public static void openFiles(final File[] files, boolean recentFiles) {
        if (recentFiles) {
            for (File f : files) {
                if (!f.exists()) continue;
                BytecodeViewer.addRecentFile(f);
            }
        }
        viewer.setIcon(true);
        update = true;
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block55: {
                    try {
                        var1_1 = files;
                        var2_5 = var1_1.length;
                        var3_6 = 0;
                        block25: while (var3_6 < var2_5) {
                            block56: {
                                f = var1_1[var3_6];
                                fn = f.getName();
                                if (!f.exists()) {
                                    BytecodeViewer.access$202(false);
                                    BytecodeViewer.showMessage("The file " + f.getAbsolutePath() + " could not be found.");
                                } else {
                                    if (f.isDirectory()) {
                                        container = new FileContainer(f);
                                        files = new HashMap<String, byte[]>();
                                        finished = false;
                                        totalFiles = new ArrayList<File>();
                                        totalFiles.add(f);
                                        dir = f.getAbsolutePath();
                                        break block55;
                                    }
                                    if (fn.endsWith(".jar") || fn.endsWith(".zip")) {
                                        try {
                                            JarUtils.put(f);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                            BytecodeViewer.access$202(false);
                                        }
                                    } else if (fn.endsWith(".class")) {
                                        try {
                                            bytes = JarUtils.getBytes(new FileInputStream(f));
                                            cafebabe = String.format("%02X%02X%02X%02X", new Object[]{bytes[0], bytes[1], bytes[2], bytes[3]});
                                            if (cafebabe.toLowerCase().equals("cafebabe")) {
                                                cn = JarUtils.getNode(bytes);
                                                container = new FileContainer(f);
                                                container.files.put(cn.name + ".class", bytes);
                                                container.add(cn);
                                                BytecodeViewer.files.add(container);
                                                break block56;
                                            }
                                            BytecodeViewer.showMessage(fn + ": Header does not start with CAFEBABE, ignoring.");
                                            BytecodeViewer.access$202(false);
                                        }
                                        catch (Exception e) {
                                            new ExceptionUI(e);
                                            BytecodeViewer.access$202(false);
                                        }
                                    } else {
                                        if (fn.endsWith(".apk")) {
                                            try {
                                                BytecodeViewer.viewer.setIcon(true);
                                                container = new FileContainer(f);
                                                if (BytecodeViewer.viewer.decodeAPKResources.isSelected()) {
                                                    decodedResources = new File(BytecodeViewer.tempDir, MiscUtils.randomString(32) + ".apk");
                                                    APKTool.decodeResources(f, decodedResources);
                                                    container.files = JarUtils.loadResources(decodedResources);
                                                }
                                                container.files.putAll(JarUtils.loadResources(f));
                                                name = BytecodeViewer.getRandomizedName() + ".jar";
                                                output = new File(BytecodeViewer.tempDir, name);
                                                if (BytecodeViewer.viewer.apkConversionGroup.isSelected(BytecodeViewer.viewer.apkConversionDex.getModel())) {
                                                    Dex2Jar.dex2Jar(f, output);
                                                } else if (BytecodeViewer.viewer.apkConversionGroup.isSelected(BytecodeViewer.viewer.apkConversionEnjarify.getModel())) {
                                                    Enjarify.apk2Jar(f, output);
                                                }
                                                var9_22 = JarUtils.loadClasses(output).iterator();
                                                while (true) {
                                                    if (!var9_22.hasNext()) {
                                                        BytecodeViewer.viewer.setIcon(false);
                                                        BytecodeViewer.files.add(container);
                                                        return;
                                                    }
                                                    classNode = var9_22.next();
                                                    container.add(classNode);
                                                }
                                            }
                                            catch (Exception e) {
                                                new ExceptionUI(e);
                                                return;
                                            }
                                        }
                                        if (fn.endsWith(".dex")) {
                                            try {
                                                BytecodeViewer.viewer.setIcon(true);
                                                container = new FileContainer(f);
                                                name = BytecodeViewer.getRandomizedName() + ".jar";
                                                output = new File(BytecodeViewer.tempDir, name);
                                                if (BytecodeViewer.viewer.apkConversionGroup.isSelected(BytecodeViewer.viewer.apkConversionDex.getModel())) {
                                                    Dex2Jar.dex2Jar(f, output);
                                                } else if (BytecodeViewer.viewer.apkConversionGroup.isSelected(BytecodeViewer.viewer.apkConversionEnjarify.getModel())) {
                                                    Enjarify.apk2Jar(f, output);
                                                }
                                                var9_22 = JarUtils.loadClasses(output).iterator();
                                                while (true) {
                                                    if (!var9_22.hasNext()) {
                                                        BytecodeViewer.viewer.setIcon(false);
                                                        BytecodeViewer.files.add(container);
                                                        return;
                                                    }
                                                    classNode = var9_22.next();
                                                    container.add(classNode);
                                                }
                                            }
                                            catch (Exception e) {
                                                new ExceptionUI(e);
                                                return;
                                            }
                                        }
                                        files = new HashMap<String, byte[]>();
                                        bytes = JarUtils.getBytes(new FileInputStream(f));
                                        files.put(f.getName(), bytes);
                                        container = new FileContainer(f);
                                        container.files = files;
                                        BytecodeViewer.files.add(container);
                                    }
                                }
                            }
lbl119:
                            // 2 sources

                            while (true) {
                                ++var3_6;
                                continue block25;
                                break;
                            }
                        }
                        return;
                    }
                    catch (Exception e) {
                        new ExceptionUI(e);
                        return;
                    }
                    finally {
                        BytecodeViewer.viewer.setIcon(false);
                        if (BytecodeViewer.access$200()) {
                            try {
                                MainViewerGUI.getComponent(FileNavigationPane.class).updateTree();
                            }
                            catch (NullPointerException var1_4) {}
                        }
                    }
                }
                while (true) {
                    if (!finished) {
                        added = false;
                    } else {
                        container.files = files;
                        BytecodeViewer.files.add(container);
                        ** continue;
                    }
                    for (i = 0; i < totalFiles.size(); ++i) {
                        child = (File)totalFiles.get(i);
                        if (child.listFiles() == null) continue;
                        for (File rocket : child.listFiles()) {
                            if (totalFiles.contains(rocket)) continue;
                            totalFiles.add(rocket);
                            added = true;
                        }
                    }
                    if (added) continue;
                    for (File child : totalFiles) {
                        if (!child.isFile()) continue;
                        fileName = child.getAbsolutePath().substring(dir.length() + 1, child.getAbsolutePath().length()).replaceAll("\\\\", "\\/");
                        files.put(fileName, Files.readAllBytes(Paths.get(child.getAbsolutePath(), new String[0])));
                    }
                    finished = true;
                }
            }
        };
        t.start();
    }

    public static void startPlugin(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            PluginManager.runPlugin(file);
        }
        catch (Throwable e) {
            new ExceptionUI(e);
        }
        BytecodeViewer.addRecentPlugin(file);
    }

    public static void showMessage(String message) {
        JOptionPane.showMessageDialog(viewer, message);
    }

    public static void resetWorkSpace(boolean ask) {
        if (!ask) {
            files.clear();
            MainViewerGUI.getComponent(FileNavigationPane.class).resetWorkspace();
            MainViewerGUI.getComponent(WorkPane.class).resetWorkspace();
            MainViewerGUI.getComponent(SearchingPane.class).resetWorkspace();
            the.bytecode.club.bytecodeviewer.api.BytecodeViewer.getClassNodeLoader().clear();
        } else {
            JOptionPane pane = new JOptionPane("Are you sure you want to reset the workspace?\n\rIt will also reset your file navigator and search.");
            Object[] options = new String[]{"Yes", "No"};
            pane.setOptions(options);
            JDialog dialog = pane.createDialog(viewer, "Bytecode Viewer - Reset Workspace");
            dialog.setVisible(true);
            Object obj = pane.getValue();
            int result = -1;
            for (int k = 0; k < options.length; ++k) {
                if (!options[k].equals(obj)) continue;
                result = k;
            }
            if (result == 0) {
                files.clear();
                MainViewerGUI.getComponent(FileNavigationPane.class).resetWorkspace();
                MainViewerGUI.getComponent(WorkPane.class).resetWorkspace();
                MainViewerGUI.getComponent(SearchingPane.class).resetWorkspace();
                the.bytecode.club.bytecodeviewer.api.BytecodeViewer.getClassNodeLoader().clear();
            }
        }
    }

    public static void addRecentFile(File f) {
        for (int i = 0; i < recentFiles.size(); ++i) {
            String s = recentFiles.get(i);
            if (!s.isEmpty() && i <= maxRecentFiles) continue;
            killList.add(s);
        }
        if (!killList.isEmpty()) {
            for (String s : killList) {
                recentFiles.remove(s);
            }
            killList.clear();
        }
        if (recentFiles.contains(f.getAbsolutePath())) {
            recentFiles.remove(f.getAbsolutePath());
        }
        if (recentFiles.size() >= maxRecentFiles) {
            recentFiles.remove(maxRecentFiles - 1);
        }
        recentFiles.add(0, f.getAbsolutePath());
        BytecodeViewer.resetRecentFilesMenu();
    }

    public static void addRecentPlugin(File f) {
        for (int i = 0; i < recentPlugins.size(); ++i) {
            String s = recentPlugins.get(i);
            if (!s.isEmpty() && i <= maxRecentFiles) continue;
            killList2.add(s);
        }
        if (!killList2.isEmpty()) {
            for (String s : killList2) {
                recentPlugins.remove(s);
            }
            killList2.clear();
        }
        if (recentPlugins.contains(f.getAbsolutePath())) {
            recentPlugins.remove(f.getAbsolutePath());
        }
        if (recentPlugins.size() >= maxRecentFiles) {
            recentPlugins.remove(maxRecentFiles - 1);
        }
        recentPlugins.add(0, f.getAbsolutePath());
        BytecodeViewer.resetRecentFilesMenu();
    }

    public static void resetRecentFilesMenu() {
        JMenuItem m;
        BytecodeViewer.viewer.mnRecentFiles.removeAll();
        for (String s : recentFiles) {
            if (s.isEmpty()) continue;
            m = new JMenuItem(s);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem m = (JMenuItem)e.getSource();
                    BytecodeViewer.openFiles(new File[]{new File(m.getText())}, true);
                }
            });
            BytecodeViewer.viewer.mnRecentFiles.add(m);
        }
        BytecodeViewer.viewer.mnRecentPlugins.removeAll();
        for (String s : recentPlugins) {
            if (s.isEmpty()) continue;
            m = new JMenuItem(s);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem m = (JMenuItem)e.getSource();
                    BytecodeViewer.startPlugin(new File(m.getText()));
                }
            });
            BytecodeViewer.viewer.mnRecentPlugins.add(m);
        }
    }

    public static void cleanup() {
        try {
            FileUtils.cleanDirectory((File)tempDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getRandomizedName() {
        boolean generated = false;
        String name = "";
        while (!generated) {
            String randomizedName = MiscUtils.randomString(25);
            if (createdRandomizedNames.contains(randomizedName)) continue;
            createdRandomizedNames.add(randomizedName);
            name = randomizedName;
            generated = true;
        }
        return name;
    }

    public static String getBCVDirectory() {
        while (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        if (!dataDir.isHidden() && BytecodeViewer.isWindows()) {
            BytecodeViewer.hideFile(dataDir);
        }
        return dataDir.getAbsolutePath();
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static void hideFile(File f) {
        sm.stopBlocking();
        try {
            Runtime.getRuntime().exec("attrib +H " + f.getAbsolutePath());
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
        sm.setBlocking();
    }

    public static void checkHotKey(KeyEvent e) {
        if (System.currentTimeMillis() - last <= 4000L) {
            return;
        }
        if (e.getKeyCode() == 79 && (e.getModifiers() & 2) != 0) {
            last = System.currentTimeMillis();
            JFileChooser fc = new JFileChooser();
            try {
                fc.setSelectedFile(new File(lastDirectory));
            }
            catch (Exception exception) {
                // empty catch block
            }
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String extension = MiscUtils.extension(f.getAbsolutePath());
                    return extension != null && (extension.equals("jar") || extension.equals("zip") || extension.equals("class") || extension.equals("apk") || extension.equals("dex"));
                }

                @Override
                public String getDescription() {
                    return "APKs, DEX, Class Files or Zip/Jar Archives";
                }
            });
            fc.setFileHidingEnabled(false);
            fc.setAcceptAllFileFilterUsed(false);
            int returnVal = fc.showOpenDialog(viewer);
            if (returnVal == 0) {
                lastDirectory = fc.getSelectedFile().getAbsolutePath();
                try {
                    viewer.setIcon(true);
                    BytecodeViewer.openFiles(new File[]{fc.getSelectedFile()}, true);
                    viewer.setIcon(false);
                }
                catch (Exception e1) {
                    new ExceptionUI(e1);
                }
            }
        } else if (e.getKeyCode() == 78 && (e.getModifiers() & 2) != 0) {
            last = System.currentTimeMillis();
            BytecodeViewer.resetWorkSpace(true);
        } else if (e.getKeyCode() == 84 && (e.getModifiers() & 2) != 0) {
            last = System.currentTimeMillis();
            Thread t = new Thread(){

                @Override
                public void run() {
                    BytecodeViewer.compile(true);
                }
            };
            t.start();
        } else if (e.getKeyCode() == 82 && (e.getModifiers() & 2) != 0) {
            last = System.currentTimeMillis();
            if (BytecodeViewer.getLoadedClasses().isEmpty()) {
                BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                return;
            }
            new RunOptions().setVisible(true);
        } else if (e.getKeyCode() == 83 && (e.getModifiers() & 2) != 0) {
            last = System.currentTimeMillis();
            if (BytecodeViewer.getLoadedClasses().isEmpty()) {
                BytecodeViewer.showMessage("First open a class, jar, zip, apk or dex file.");
                return;
            }
            Thread t = new Thread(){

                @Override
                public void run() {
                    if (BytecodeViewer.viewer.compileOnSave.isSelected() && !BytecodeViewer.compile(false)) {
                        return;
                    }
                    JFileChooser fc = new JFileChooser();
                    fc.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return f.isDirectory() || MiscUtils.extension(f.getAbsolutePath()).equals("zip");
                        }

                        @Override
                        public String getDescription() {
                            return "Zip Archives";
                        }
                    });
                    fc.setFileHidingEnabled(false);
                    fc.setAcceptAllFileFilterUsed(false);
                    int returnVal = fc.showSaveDialog(viewer);
                    if (returnVal == 0) {
                        File file = fc.getSelectedFile();
                        if (!file.getAbsolutePath().endsWith(".zip")) {
                            file = new File(file.getAbsolutePath() + ".zip");
                        }
                        if (file.exists()) {
                            JOptionPane pane = new JOptionPane("Are you sure you wish to overwrite this existing file?");
                            Object[] options = new String[]{"Yes", "No"};
                            pane.setOptions(options);
                            JDialog dialog = pane.createDialog(viewer, "Bytecode Viewer - Overwrite File");
                            dialog.setVisible(true);
                            Object obj = pane.getValue();
                            int result = -1;
                            for (int k = 0; k < options.length; ++k) {
                                if (!options[k].equals(obj)) continue;
                                result = k;
                            }
                            if (result == 0) {
                                file.delete();
                            } else {
                                return;
                            }
                        }
                        final File file2 = file;
                        viewer.setIcon(true);
                        Thread t = new Thread(){

                            @Override
                            public void run() {
                                JarUtils.saveAsJar(BytecodeViewer.getLoadedBytes(), file2.getAbsolutePath());
                                viewer.setIcon(false);
                            }
                        };
                        t.start();
                    }
                }
            };
            t.start();
        } else if (e.getKeyCode() == 87 && (e.getModifiers() & 2) != 0) {
            last = System.currentTimeMillis();
            if (BytecodeViewer.viewer.workPane.getCurrentViewer() != null) {
                BytecodeViewer.viewer.workPane.tabs.remove(BytecodeViewer.viewer.workPane.getCurrentViewer());
            }
        }
    }

    static /* synthetic */ boolean access$202(boolean x0) {
        update = x0;
        return update;
    }

    static /* synthetic */ boolean access$200() {
        return update;
    }
}

