/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;
import the.bytecode.club.bytecodeviewer.Resources;

public class InitialBootScreen
extends JFrame {
    private static final long serialVersionUID = -1098467609722393444L;
    private JProgressBar progressBar = new JProgressBar();

    public InitialBootScreen() throws IOException {
        this.setDefaultCloseOperation(3);
        this.setIconImages(Resources.iconList);
        int i = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        if (i >= 840) {
            this.setSize(new Dimension(600, 800));
        } else if (i >= 640) {
            this.setSize(new Dimension(500, 600));
        } else if (i >= 440) {
            this.setSize(new Dimension(400, 400));
        } else {
            this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
        this.setTitle("Bytecode Viewer Boot Screen - Starting Up");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.getContentPane().setLayout(gridBagLayout);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.gridheight = 24;
        gbc_scrollPane.insets = new Insets(0, 0, 5, 0);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        this.getContentPane().add((Component)scrollPane, gbc_scrollPane);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditorKit(new HTMLEditorKit());
        editorPane.setText(InitialBootScreen.convertStreamToString(InitialBootScreen.class.getResourceAsStream("/intro.html")));
        scrollPane.setViewportView(editorPane);
        GridBagConstraints gbc_progressBar = new GridBagConstraints();
        gbc_progressBar.fill = 2;
        gbc_progressBar.gridx = 0;
        gbc_progressBar.gridy = 24;
        this.getContentPane().add((Component)this.progressBar, gbc_progressBar);
        this.setLocationRelativeTo(null);
    }

    static String convertStreamToString(InputStream is) throws IOException {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        String string = s.hasNext() ? s.next() : "";
        is.close();
        s.close();
        return string;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }
}

