/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.api;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;

public final class ASMUtil_OLD {
    public static void renameFieldNode(String originalParentName, String originalFieldName, String originalFieldDesc, String newFieldParent, String newFieldName, String newFieldDesc) {
        for (ClassNode c : BytecodeViewer.getLoadedClasses()) {
            for (Object o : c.methods.toArray()) {
                MethodNode m = (MethodNode)o;
                for (AbstractInsnNode i : m.instructions.toArray()) {
                    if (!(i instanceof FieldInsnNode)) continue;
                    FieldInsnNode field = (FieldInsnNode)i;
                    if (!field.owner.equals(originalParentName) || !field.name.equals(originalFieldName) || !field.desc.equals(originalFieldDesc)) continue;
                    if (newFieldParent != null) {
                        field.owner = newFieldParent;
                    }
                    if (newFieldName != null) {
                        field.name = newFieldName;
                    }
                    if (newFieldDesc == null) continue;
                    field.desc = newFieldDesc;
                }
            }
        }
    }

    public static void renameMethodNode(String originalParentName, String originalMethodName, String originalMethodDesc, String newParent, String newName, String newDesc) {
        for (ClassNode c : BytecodeViewer.getLoadedClasses()) {
            for (Object o : c.methods.toArray()) {
                MethodNode m = (MethodNode)o;
                for (AbstractInsnNode i : m.instructions.toArray()) {
                    if (!(i instanceof MethodInsnNode)) continue;
                    MethodInsnNode mi = (MethodInsnNode)i;
                    if (!mi.owner.equals(originalParentName) || !mi.name.equals(originalMethodName) || !mi.desc.equals(originalMethodDesc)) continue;
                    if (newParent != null) {
                        mi.owner = newParent;
                    }
                    if (newName != null) {
                        mi.name = newName;
                    }
                    if (newDesc == null) continue;
                    mi.desc = newDesc;
                }
                if (m.signature != null) {
                    if (newName != null) {
                        m.signature = m.signature.replace(originalMethodName, newName);
                    }
                    if (newParent != null) {
                        m.signature = m.signature.replace(originalParentName, newParent);
                    }
                }
                if (!m.name.equals(originalMethodName) || !m.desc.equals(originalMethodDesc) || !c.name.equals(originalParentName)) continue;
                if (newName != null) {
                    m.name = newName;
                }
                if (newDesc == null) continue;
                m.desc = newDesc;
            }
        }
    }

    public static void renameClassNode(String oldName, String newName) {
        for (ClassNode c : BytecodeViewer.getLoadedClasses()) {
            Object[] objectArray = c.innerClasses.iterator();
            while (objectArray.hasNext()) {
                InnerClassNode oo;
                InnerClassNode innerClassNode = oo = objectArray.next();
                if (innerClassNode.innerName != null && innerClassNode.innerName.equals(oldName)) {
                    innerClassNode.innerName = newName;
                }
                if (innerClassNode.name.equals(oldName)) {
                    innerClassNode.name = newName;
                }
                if (innerClassNode.outerName == null || !innerClassNode.outerName.equals(oldName)) continue;
                innerClassNode.outerName = newName;
            }
            if (c.signature != null) {
                c.signature = c.signature.replace(oldName, newName);
            }
            if (c.superName.equals(oldName)) {
                c.superName = newName;
            }
            for (Object o : c.fields.toArray()) {
                FieldNode f = (FieldNode)o;
                f.desc = f.desc.replace(oldName, newName);
            }
            for (Object o : c.interfaces.toArray()) {
                String truxerLipton = (String)o;
                truxerLipton = truxerLipton.replace(oldName, newName);
            }
            for (Object o : c.methods.toArray()) {
                MethodNode m = (MethodNode)o;
                if (m.localVariables != null) {
                    for (LocalVariableNode node : m.localVariables) {
                        node.desc = node.desc.replace(oldName, newName);
                    }
                }
                if (m.signature != null) {
                    m.signature = m.signature.replace(oldName, newName);
                }
                for (int i = 0; i < m.exceptions.size(); ++i) {
                    if (!m.exceptions.get(i).equals(oldName)) continue;
                    m.exceptions.set(i, newName);
                }
                for (AbstractInsnNode i : m.instructions.toArray()) {
                    if (i instanceof TypeInsnNode) {
                        TypeInsnNode t = (TypeInsnNode)i;
                        if (t.desc.equals(oldName)) {
                            t.desc = newName;
                        }
                    }
                    if (i instanceof MethodInsnNode) {
                        MethodInsnNode mi = (MethodInsnNode)i;
                        if (mi.owner.equals(oldName)) {
                            mi.owner = newName;
                        }
                        mi.desc = mi.desc.replace(oldName, newName);
                    }
                    if (!(i instanceof FieldInsnNode)) continue;
                    FieldInsnNode fi = (FieldInsnNode)i;
                    if (fi.owner.equals(oldName)) {
                        fi.owner = newName;
                    }
                    fi.desc = fi.desc.replace(oldName, newName);
                }
            }
        }
    }
}

