/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.compilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.io.FileUtils;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.MiscUtils;
import the.bytecode.club.bytecodeviewer.Settings;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.compilers.Compiler;

public class JavaCompiler
extends Compiler {
    @Override
    public byte[] compile(String contents, String name) {
        String fileStart = BytecodeViewer.tempDir.getAbsolutePath() + BytecodeViewer.fs + "temp" + MiscUtils.randomString(12) + BytecodeViewer.fs;
        String fileStart2 = BytecodeViewer.tempDir.getAbsolutePath() + BytecodeViewer.fs + "temp" + MiscUtils.randomString(12) + BytecodeViewer.fs;
        File java = new File(fileStart + BytecodeViewer.fs + name + ".java");
        File clazz = new File(fileStart2 + BytecodeViewer.fs + name + ".class");
        File cp = new File(BytecodeViewer.tempDir, "cpath_" + MiscUtils.randomString(12) + ".jar");
        File tempD = new File(fileStart + BytecodeViewer.fs + name.substring(0, name.length() - name.split("/")[name.split("/").length - 1].length()));
        tempD.mkdirs();
        new File(fileStart2).mkdirs();
        if (Settings.JAVAC_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set your Javac path, this requires the JDK to be downloaded." + BytecodeViewer.nl + "(C:/programfiles/Java/JRE_xx/bin/javac.exe)");
            BytecodeViewer.viewer.javac();
        }
        if (Settings.JAVAC_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set Javac!");
            return null;
        }
        try {
            FileUtils.write((File)java, (CharSequence)contents, (String)"UTF-8", (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JarUtils.saveAsJar(BytecodeViewer.getLoadedBytes(), cp.getAbsolutePath());
        boolean cont = true;
        BytecodeViewer.sm.stopBlocking();
        try {
            String line;
            String log = "";
            ProcessBuilder pb = Settings.PATH.isEmpty() ? new ProcessBuilder(Settings.JAVAC_LOCATION.get(), "-d", fileStart2, "-classpath", cp.getAbsolutePath(), java.getAbsolutePath()) : new ProcessBuilder(Settings.JAVAC_LOCATION.get(), "-d", fileStart2, "-classpath", cp.getAbsolutePath() + ";" + Settings.PATH.get(), java.getAbsolutePath());
            Process process = pb.start();
            BytecodeViewer.createdProcesses.add(process);
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                log = log + BytecodeViewer.nl + line;
            }
            br.close();
            log = log + BytecodeViewer.nl + BytecodeViewer.nl + "Error:" + BytecodeViewer.nl + BytecodeViewer.nl;
            is = process.getErrorStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                log = log + BytecodeViewer.nl + line;
            }
            br.close();
            int exitValue = process.waitFor();
            log = log + BytecodeViewer.nl + BytecodeViewer.nl + "Exit Value is " + exitValue;
            System.out.println(log);
            if (!clazz.exists()) {
                throw new Exception(log);
            }
        }
        catch (Exception e) {
            cont = false;
            e.printStackTrace();
        }
        BytecodeViewer.sm.setBlocking();
        cp.delete();
        if (cont) {
            try {
                return FileUtils.readFileToByteArray((File)clazz);
            }
            catch (IOException e) {
                new ExceptionUI(e);
            }
        }
        return null;
    }
}

