/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers.bytecode;

import java.util.ArrayList;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldNode;
import the.bytecode.club.bytecodeviewer.decompilers.bytecode.PrefixedStringBuilder;

public class FieldNodeDecompiler {
    private FieldNodeDecompiler() {
    }

    public static PrefixedStringBuilder decompile(PrefixedStringBuilder sb, FieldNode f) {
        String s = FieldNodeDecompiler.getAccessString(f.access);
        sb.append(s);
        if (s.length() > 0) {
            sb.append(" ");
        }
        sb.append(Type.getType(f.desc).getClassName());
        sb.append(" ");
        sb.append(f.name);
        if (f.value != null) {
            sb.append(" = ");
            if (f.value instanceof String) {
                sb.append("\"");
                sb.append(f.value);
                sb.append("\"");
            } else {
                sb.append(f.value);
                sb.append(" (");
                sb.append(f.value.getClass().getCanonicalName());
                sb.append(")");
            }
        }
        sb.append(";");
        return sb;
    }

    private static String getAccessString(int access) {
        ArrayList<String> tokens = new ArrayList<String>();
        if ((access & 1) != 0) {
            tokens.add("public");
        }
        if ((access & 2) != 0) {
            tokens.add("private");
        }
        if ((access & 4) != 0) {
            tokens.add("protected");
        }
        if ((access & 0x1000) != 0) {
            tokens.add("synthetic");
        }
        if ((access & 8) != 0) {
            tokens.add("static");
        }
        if ((access & 0x10) != 0) {
            tokens.add("final");
        }
        if ((access & 0x80) != 0) {
            tokens.add("transient");
        }
        if ((access & 0x40) != 0) {
            tokens.add("volatile");
        }
        if (tokens.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder((String)tokens.get(0));
        for (int i = 1; i < tokens.size(); ++i) {
            sb.append(" ");
            sb.append((String)tokens.get(i));
        }
        return sb.toString();
    }
}

