/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers.bytecode;

import eu.bibl.banalysis.filter.InstructionFilter;
import eu.bibl.banalysis.filter.OpcodeFilter;
import eu.bibl.banalysis.filter.insn.FieldInstructionFilter;
import eu.bibl.banalysis.filter.insn.IincInstructionFilter;
import eu.bibl.banalysis.filter.insn.InsnInstructionFilter;
import eu.bibl.banalysis.filter.insn.JumpInstructionFilter;
import eu.bibl.banalysis.filter.insn.LdcInstructionFilter;
import eu.bibl.banalysis.filter.insn.MethodInstructionFilter;
import eu.bibl.banalysis.filter.insn.MultiANewArrayInstructionFilter;
import eu.bibl.banalysis.filter.insn.TypeInstructionFilter;
import eu.bibl.banalysis.filter.insn.VarInstructionFilter;
import java.util.Arrays;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InstructionPattern
implements Opcodes {
    protected int pointer;
    protected InstructionFilter[] filters;
    protected AbstractInsnNode[] lastMatch;

    public InstructionPattern(AbstractInsnNode[] insns) {
        this.filters = InstructionPattern.translate(insns);
        this.lastMatch = new AbstractInsnNode[insns.length];
    }

    public InstructionPattern(int[] opcodes) {
        this.filters = new InstructionFilter[opcodes.length];
        this.lastMatch = new AbstractInsnNode[opcodes.length];
        for (int i = 0; i < opcodes.length; ++i) {
            this.filters[i] = new OpcodeFilter(opcodes[i]);
        }
    }

    public InstructionPattern(InstructionFilter[] filters) {
        this.filters = filters;
        this.lastMatch = new AbstractInsnNode[filters.length];
    }

    public boolean accept(AbstractInsnNode ain) {
        InstructionFilter filter;
        if (this.pointer >= this.filters.length) {
            this.reset();
        }
        if ((filter = this.filters[this.pointer]).accept((Object)ain)) {
            this.lastMatch[this.pointer] = ain;
            if (this.pointer >= this.filters.length - 1) {
                return true;
            }
            ++this.pointer;
        } else {
            this.reset();
        }
        return false;
    }

    public AbstractInsnNode[] getLastMatch() {
        return this.lastMatch;
    }

    public void resetMatch() {
        this.reset();
        AbstractInsnNode[] match = this.lastMatch;
        this.lastMatch = new AbstractInsnNode[match.length];
    }

    public void reset() {
        this.pointer = 0;
    }

    public static InstructionFilter[] translate(AbstractInsnNode[] ains) {
        InstructionFilter[] filters = new InstructionFilter[ains.length];
        for (int i = 0; i < ains.length; ++i) {
            filters[i] = InstructionPattern.translate(ains[i]);
        }
        return filters;
    }

    public static InstructionFilter translate(AbstractInsnNode ain) {
        if (ain instanceof LdcInsnNode) {
            return new LdcInstructionFilter(((LdcInsnNode)ain).cst);
        }
        if (ain instanceof TypeInsnNode) {
            return new TypeInstructionFilter(ain.opcode(), ((TypeInsnNode)ain).desc);
        }
        if (ain instanceof FieldInsnNode) {
            return new FieldInstructionFilter(ain.opcode(), ((FieldInsnNode)ain).owner, ((FieldInsnNode)ain).name, ((FieldInsnNode)ain).desc);
        }
        if (ain instanceof MethodInsnNode) {
            return new MethodInstructionFilter(ain.opcode(), ((MethodInsnNode)ain).owner, ((MethodInsnNode)ain).name, ((MethodInsnNode)ain).desc);
        }
        if (ain instanceof VarInsnNode) {
            return new VarInstructionFilter(ain.opcode(), ((VarInsnNode)ain).var);
        }
        if (ain instanceof InsnNode) {
            return new InsnInstructionFilter(ain.opcode());
        }
        if (ain instanceof IincInsnNode) {
            return new IincInstructionFilter(((IincInsnNode)ain).incr, ((IincInsnNode)ain).var);
        }
        if (ain instanceof JumpInsnNode) {
            return new JumpInstructionFilter(ain.opcode());
        }
        if (ain instanceof LabelNode) {
            return InstructionFilter.ACCEPT_ALL;
        }
        if (ain instanceof MultiANewArrayInsnNode) {
            return new MultiANewArrayInstructionFilter(((MultiANewArrayInsnNode)ain).desc, ((MultiANewArrayInsnNode)ain).dims);
        }
        return InstructionFilter.ACCEPT_ALL;
    }

    public static void main(String[] args) {
        AbstractInsnNode[] ains = new AbstractInsnNode[]{new LdcInsnNode("ldc"), new VarInsnNode(58, 0), new LdcInsnNode("ldc")};
        InstructionPattern pattern = new InstructionPattern(new AbstractInsnNode[]{new LdcInsnNode("ldc"), new VarInsnNode(-1, -1)});
        for (AbstractInsnNode ain : ains) {
            if (!pattern.accept(ain)) continue;
            System.out.println(Arrays.toString(pattern.getLastMatch()));
        }
    }
}

