/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Methods {
    public static final Pattern regex = Pattern.compile("\\s*(?:static|public|private|protected|final|abstract)[\\w\\s.<>\\[\\]]*\\s+(?<name>[\\w]+)\\s*\\((?<params>[\\w\\s,.<>\\[\\]$?]*)\\)");
    private TreeMap<Integer, Method> methods = new TreeMap();

    private static String removeBrackets(String string) {
        if (string.indexOf(60) != -1 && string.indexOf(62) != -1) {
            return Methods.removeBrackets(string.replaceAll("<[^<>]*>", ""));
        }
        return string;
    }

    public void addMethod(int line, String name, String params) {
        String[] args = new String[]{};
        if (!params.isEmpty()) {
            params = Methods.removeBrackets(params);
            args = params.split(",");
            for (int i = 0; i < args.length; ++i) {
                int dollar;
                int dot;
                args[i] = args[i].trim();
                if (args[i].indexOf(32) != -1) {
                    String[] strings = args[i].split(" ");
                    args[i] = strings[strings.length - 2];
                }
                if ((dot = args[i].lastIndexOf(46)) != -1) {
                    args[i] = args[i].substring(dot + 1);
                }
                if ((dollar = args[i].lastIndexOf(36)) == -1) continue;
                args[i] = args[i].substring(dollar + 1);
            }
        }
        Method method = new Method(name, Arrays.asList(args));
        this.methods.put(line, method);
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    public Method getMethod(int line) {
        return this.methods.get(line);
    }

    public Integer[] getMethodsLines() {
        Integer[] lines = new Integer[this.methods.size()];
        return this.methods.keySet().toArray(lines);
    }

    public String getMethodName(int line) {
        Method method = this.methods.get(line);
        if (method != null && !method.name.isEmpty()) {
            return method.name;
        }
        return "";
    }

    public List<String> getMethodParams(int line) {
        Method method = this.methods.get(line);
        if (method != null && !method.params.isEmpty()) {
            return method.params;
        }
        return null;
    }

    public int findMethod(Method method) {
        return this.findMethod(method.name, method.params);
    }

    public int findMethod(String name, List<String> params) {
        for (Map.Entry<Integer, Method> entry : this.methods.entrySet()) {
            if (!name.equals(entry.getValue().name) || params.size() != entry.getValue().params.size() || !params.equals(entry.getValue().params)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public int findActiveMethod(int line) {
        Map.Entry<Integer, Method> low;
        if (!this.methods.isEmpty() && (low = this.methods.floorEntry(line)) != null) {
            return low.getKey();
        }
        return -1;
    }

    public int findNearestMethod(int line) {
        if (!this.methods.isEmpty()) {
            if (this.methods.size() == 1) {
                return this.methods.firstKey();
            }
            Map.Entry<Integer, Method> low = this.methods.floorEntry(line);
            Map.Entry<Integer, Method> high = this.methods.ceilingEntry(line);
            if (low != null && high != null) {
                return Math.abs(line - low.getKey()) < Math.abs(line - high.getKey()) ? low.getKey() : high.getKey();
            }
            if (low != null || high != null) {
                return low != null ? low.getKey() : high.getKey();
            }
        }
        return -1;
    }

    public static class Method {
        public String name;
        public List<String> params;

        public Method(String name, List<String> params) {
            this.name = name;
            this.params = params;
        }

        public String toString() {
            String params = this.params.toString();
            return this.name + "(" + params.substring(1, params.length() - 1) + ")";
        }
    }
}

