/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.plugin.preinstalled;

import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.api.Plugin;
import the.bytecode.club.bytecodeviewer.api.PluginConsole;

public class ReplaceStrings
extends Plugin {
    PluginConsole frame = new PluginConsole("Replace Strings");
    String originalLDC;
    String newLDC;
    String className;
    boolean contains;

    public ReplaceStrings(String originalLDC, String newLDC, String className, boolean contains) {
        this.originalLDC = originalLDC;
        this.newLDC = newLDC;
        this.className = className;
        this.contains = contains;
    }

    @Override
    public void execute(ArrayList<ClassNode> classNodeList) {
        if (!this.className.equals("*")) {
            for (ClassNode classNode : classNodeList) {
                if (!classNode.name.equals(this.className)) continue;
                this.scanClassNode(classNode);
            }
        } else {
            for (ClassNode classNode : classNodeList) {
                this.scanClassNode(classNode);
            }
        }
        this.frame.setVisible(true);
    }

    public void scanClassNode(ClassNode classNode) {
        for (Object o : classNode.fields.toArray()) {
            FieldNode f = (FieldNode)o;
            Object v = f.value;
            if (v instanceof String) {
                String s = (String)v;
                if (this.contains) {
                    if (s.contains(this.originalLDC)) {
                        f.value = ((String)f.value).replaceAll(this.originalLDC, this.newLDC);
                    }
                } else if (s.equals(this.originalLDC)) {
                    f.value = this.newLDC;
                }
            }
            if (!(v instanceof String[])) continue;
            for (int i = 0; i < ((String[])v).length; ++i) {
                String ugh;
                String s = ((String[])v)[i];
                if (this.contains) {
                    if (!s.contains(this.originalLDC)) continue;
                    f.value = ((String[])f.value)[i].replaceAll(this.originalLDC, this.newLDC);
                    ugh = s.replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r");
                    this.frame.appendText(classNode.name + "." + f.name + "" + f.desc + " -> \"" + ugh + "\" replaced with \"" + s.replaceAll(this.originalLDC, this.newLDC) + "\"");
                    continue;
                }
                if (!s.equals(this.originalLDC)) continue;
                ((String[])f.value)[i] = this.newLDC;
                ugh = s.replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r");
                this.frame.appendText(classNode.name + "." + f.name + "" + f.desc + " -> \"" + ugh + "\" replaced with \"" + this.newLDC + "\"");
            }
        }
        for (Object o : classNode.methods.toArray()) {
            MethodNode m = (MethodNode)o;
            InsnList iList = m.instructions;
            for (AbstractInsnNode a : iList.toArray()) {
                String ugh;
                if (!(a instanceof LdcInsnNode) || !(((LdcInsnNode)a).cst instanceof String)) continue;
                String s = (String)((LdcInsnNode)a).cst;
                if (this.contains) {
                    if (!s.contains(this.originalLDC)) continue;
                    ((LdcInsnNode)a).cst = ((String)((LdcInsnNode)a).cst).replaceAll(this.originalLDC, this.newLDC);
                    ugh = s.replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r");
                    this.frame.appendText(classNode.name + "." + m.name + "" + m.desc + " -> \"" + ugh + "\" replaced with \"" + s.replaceAll(this.originalLDC, this.newLDC).replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r") + "\"");
                    continue;
                }
                if (!s.equals(this.originalLDC)) continue;
                ((LdcInsnNode)a).cst = this.newLDC;
                ugh = s.replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r");
                this.frame.appendText(classNode.name + "." + m.name + "" + m.desc + " -> \"" + ugh + "\" replaced with \"" + this.newLDC.replaceAll("\\n", "\\\\n").replaceAll("\\r", "\\\\r") + "\"");
            }
        }
    }
}

