/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.plugin.strategies;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.api.Plugin;
import the.bytecode.club.bytecodeviewer.plugin.PluginLaunchStrategy;

public class CompiledJavaPluginLaunchStrategy
implements PluginLaunchStrategy {
    private static final String PLUGIN_CLASS_NAME = Plugin.class.getCanonicalName().replace(".", "/");
    private final Set<LoadedPluginData> loaded = new HashSet<LoadedPluginData>();

    @Override
    public Plugin run(File file) throws Throwable {
        Set<LoadedNodeData> set = CompiledJavaPluginLaunchStrategy.loadData(file);
        LoadedNodeData pdata = null;
        for (LoadedNodeData d : set) {
            ClassNode cn = d.node;
            if (!cn.superName.equals(PLUGIN_CLASS_NAME)) continue;
            if (pdata == null) {
                pdata = d;
                continue;
            }
            throw new RuntimeException("Multiple plugin subclasses.");
        }
        LoadingClassLoader cl = new LoadingClassLoader(pdata, set);
        Plugin p = (Plugin)cl.pluginKlass.newInstance();
        LoadedPluginData npdata = new LoadedPluginData(pdata, cl, p);
        this.loaded.add(npdata);
        return p;
    }

    public Set<LoadedPluginData> getLoaded() {
        return this.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<LoadedNodeData> loadData(File jarFile) throws Throwable {
        ZipEntry entry;
        ZipInputStream jis = new ZipInputStream(new FileInputStream(jarFile));
        HashSet<LoadedNodeData> set = new HashSet<LoadedNodeData>();
        while ((entry = jis.getNextEntry()) != null) {
            try {
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                byte[] bytes = JarUtils.getBytes(jis);
                String magic = String.format("%02X", bytes[0]) + String.format("%02X", bytes[1]) + String.format("%02X", bytes[2]) + String.format("%02X", bytes[3]);
                if (magic.toLowerCase().equals("cafebabe")) {
                    try {
                        ClassReader cr = new ClassReader(bytes);
                        ClassNode cn = new ClassNode();
                        cr.accept(cn, 0);
                        LoadedNodeData data = new LoadedNodeData(bytes, cn);
                        set.add(data);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                System.out.println(jarFile + ">" + name + ": Header does not start with CAFEBABE, ignoring.");
            }
            catch (Exception e) {
                new ExceptionUI(e);
            }
            finally {
                jis.closeEntry();
            }
        }
        jis.close();
        return set;
    }

    public static class LoadingClassLoader
    extends ClassLoader {
        private final LoadedNodeData data;
        private Map<String, LoadedNodeData> cache;
        private Map<String, Class<?>> ccache;
        private final Class<? extends Plugin> pluginKlass;

        public LoadingClassLoader(LoadedNodeData data, Set<LoadedNodeData> set) throws Throwable {
            this.data = data;
            this.cache = new HashMap<String, LoadedNodeData>();
            this.ccache = new HashMap();
            for (LoadedNodeData d : set) {
                this.cache.put(((LoadedNodeData)d).node.name, d);
            }
            Class<?> pluginKlass = this.loadClass(((LoadedNodeData)data).node.name.replace("/", "."));
            if (pluginKlass == null) {
                throw new RuntimeException();
            }
            this.pluginKlass = pluginKlass;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            name = name.replace(".", "/");
            System.out.println("finding " + name);
            if (this.ccache.containsKey(name)) {
                return this.ccache.get(name);
            }
            LoadedNodeData data = this.cache.get(name);
            if (data != null) {
                byte[] bytes = data.bytes;
                Class<?> klass = this.defineClass(((LoadedNodeData)data).node.name.replace("/", "."), bytes, 0, bytes.length);
                this.ccache.put(name, klass);
                return klass;
            }
            return super.findClass(name);
        }

        public LoadedNodeData getPluginNode() {
            return this.data;
        }

        public Class<? extends Plugin> getPluginKlass() {
            return this.pluginKlass;
        }
    }

    public static class LoadedPluginData {
        private final LoadedNodeData data;
        private final LoadingClassLoader classLoader;
        private final Plugin plugin;

        public LoadedPluginData(LoadedNodeData data, LoadingClassLoader classLoader, Plugin plugin) {
            this.data = data;
            this.classLoader = classLoader;
            this.plugin = plugin;
        }

        public LoadedNodeData getData() {
            return this.data;
        }

        public LoadingClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }
    }

    public static class LoadedNodeData {
        private final byte[] bytes;
        private final ClassNode node;

        public LoadedNodeData(byte[] bytes, ClassNode node) {
            this.bytes = bytes;
            this.node = node;
        }
    }
}

