/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.searching;

import eu.bibl.banalysis.asm.desc.OpcodeInfo;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.searching.SearchResultNotifier;
import the.bytecode.club.bytecodeviewer.searching.SearchTypeDetails;

public class FieldCallSearch
implements SearchTypeDetails {
    JTextField mOwner = new JTextField("");
    JTextField mName = new JTextField("");
    JTextField mDesc = new JTextField("");
    JPanel myPanel = null;

    @Override
    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = new JPanel(new GridLayout(3, 2));
            this.myPanel.add(new JLabel("Owner: "));
            this.myPanel.add(this.mOwner);
            this.myPanel.add(new JLabel("Name: "));
            this.myPanel.add(this.mName);
            this.myPanel.add(new JLabel("Desc: "));
            this.myPanel.add(this.mDesc);
        }
        return this.myPanel;
    }

    @Override
    public void search(ClassNode node, SearchResultNotifier srn, boolean exact) {
        String desc;
        String name;
        Iterator<MethodNode> methods = node.methods.iterator();
        String owner = this.mOwner.getText();
        if (owner.isEmpty()) {
            owner = null;
        }
        if ((name = this.mName.getText()).isEmpty()) {
            name = null;
        }
        if ((desc = this.mDesc.getText()).isEmpty()) {
            desc = null;
        }
        while (methods.hasNext()) {
            MethodNode method = methods.next();
            InsnList insnlist = method.instructions;
            ListIterator<AbstractInsnNode> instructions = insnlist.iterator();
            while (instructions.hasNext()) {
                String desc2;
                AbstractInsnNode insnNode = instructions.next();
                if (!(insnNode instanceof FieldInsnNode)) continue;
                FieldInsnNode min = (FieldInsnNode)insnNode;
                if (name == null && owner == null && desc == null) continue;
                if (exact) {
                    if (name != null && !name.equals(min.name) || owner != null && !owner.equals(min.owner) || desc != null && !desc.equals(min.desc)) continue;
                    desc2 = method.desc;
                    try {
                        desc2 = Type.getType(method.desc).toString();
                        if (desc2 == null || desc2.equals("null")) {
                            desc2 = method.desc;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    srn.notifyOfResult(node.name + "." + method.name + desc2 + " > " + ((String)OpcodeInfo.OPCODES.get(insnNode.opcode())).toLowerCase());
                    continue;
                }
                if (name != null && !min.name.contains(name) || owner != null && !min.owner.contains(owner) || desc != null && !min.desc.contains(desc)) continue;
                desc2 = method.desc;
                try {
                    desc2 = Type.getType(method.desc).toString();
                    if (desc2 == null || desc2.equals("null")) {
                        desc2 = method.desc;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                srn.notifyOfResult(node.name + "." + method.name + desc2 + " > " + ((String)OpcodeInfo.OPCODES.get(insnNode.opcode())).toLowerCase());
            }
        }
    }
}

