/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.searching;

import java.awt.GridLayout;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.searching.SearchResultNotifier;
import the.bytecode.club.bytecodeviewer.searching.SearchTypeDetails;

public class LDCSearch
implements SearchTypeDetails {
    JTextField searchText = new JTextField("");
    JPanel myPanel = null;

    @Override
    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = new JPanel(new GridLayout(1, 2));
            this.myPanel.add(new JLabel("Search String: "));
            this.myPanel.add(this.searchText);
        }
        return this.myPanel;
    }

    @Override
    public void search(ClassNode node, SearchResultNotifier srn, boolean exact) {
        Iterator<MethodNode> methods = node.methods.iterator();
        String srchText = this.searchText.getText();
        if (srchText.isEmpty()) {
            return;
        }
        while (methods.hasNext()) {
            MethodNode method = methods.next();
            InsnList insnlist = method.instructions;
            ListIterator<AbstractInsnNode> instructions = insnlist.iterator();
            while (instructions.hasNext()) {
                AbstractInsnNode insnNode = instructions.next();
                if (!(insnNode instanceof LdcInsnNode)) continue;
                LdcInsnNode ldcObject = (LdcInsnNode)insnNode;
                String ldcString = ldcObject.cst.toString();
                String desc2 = method.desc;
                try {
                    desc2 = Type.getType(method.desc).toString();
                    if (desc2 == null || desc2.equals("null")) {
                        desc2 = method.desc;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if ((!exact || !ldcString.equals(srchText)) && (exact || !ldcString.contains(srchText))) continue;
                srn.notifyOfResult(node.name + "." + method.name + desc2 + " -> \"" + ldcString + "\" > " + ldcObject.cst.getClass().getCanonicalName());
            }
        }
        Iterator<FieldNode> fields = node.fields.iterator();
        while (methods.hasNext()) {
            FieldNode field = fields.next();
            String desc2 = field.desc;
            try {
                desc2 = Type.getType(field.desc).toString();
                if (desc2 == null || desc2.equals("null")) {
                    desc2 = field.desc;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (!(field.value instanceof String)) continue;
            srn.notifyOfResult(node.name + "." + field.name + desc2 + " -> \"" + field.value + "\" > field");
        }
    }
}

