/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.searching;

import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;

public class RegexInsnFinder {
    private static String[] opcodes = new String[]{"NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1", "BIPUSH", "SIPUSH", "LDC", "LDC_W", "LDC2_W", "ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", "ILOAD_0", "ILOAD_1", "ILOAD_2", "ILOAD_3", "LLOAD_0", "LLOAD_1", "LLOAD_2", "LLOAD_3", "FLOAD_0", "FLOAD_1", "FLOAD_2", "FLOAD_3", "DLOAD_0", "DLOAD_1", "DLOAD_2", "DLOAD_3", "ALOAD_0", "ALOAD_1", "ALOAD_2", "ALOAD_3", "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", "ISTORE_0", "ISTORE_1", "ISTORE_2", "ISTORE_3", "LSTORE_0", "LSTORE_1", "LSTORE_2", "LSTORE_3", "FSTORE_0", "FSTORE_1", "FSTORE_2", "FSTORE_3", "DSTORE_0", "DSTORE_1", "DSTORE_2", "DSTORE_3", "ASTORE_0", "ASTORE_1", "ASTORE_2", "ASTORE_3", "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP2_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", "IINC", "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG", "IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE", "GOTO", "JSR", "RET", "TABLESWITCH", "LOOKUPSWITCH", "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN", "GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD", "INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE", "INVOKEDYNAMIC", "NEW", "NEWARRAY", "ANEWARRAY", "ARRAYLENGTH", "ATHROW", "CHECKCAST", "INSTANCEOF", "MONITORENTER", "MONITOREXIT", "WIDE", "MULTIANEWARRAY", "IFNULL", "IFNONNULL", "GOTO_W", "JSR_W"};
    private static String[] opcodesVar = new String[]{"ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", "RET"};
    private static String opcodeVars = RegexInsnFinder.buildRegexItems(opcodesVar);
    private static String[] opcodesInt = new String[]{"BIPUSH", "SIPUSH", "NEWARRAY"};
    private static String opcodesInts = RegexInsnFinder.buildRegexItems(opcodesInt);
    private static String[] opcodesField = new String[]{"GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD"};
    private static String opcodesFields = RegexInsnFinder.buildRegexItems(opcodesField);
    private static String[] opcodesMethod = new String[]{"INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE", "INVOKEDYNAMIC"};
    private static String opcodesMethods = RegexInsnFinder.buildRegexItems(opcodesMethod);
    private static String[] opcodesType = new String[]{"NEW", "ANEWARRAY", "ARRAYLENGTH", "CHECKCAST", "INSTANCEOF"};
    private static String opcodesTypes = RegexInsnFinder.buildRegexItems(opcodesType);
    private static String[] opcodesIf = new String[]{"IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE"};
    private static String opcodesIfs = RegexInsnFinder.buildRegexItems(opcodesIf, false, false);
    private static String[] opcodesAny = new String[]{"NOP", "ACONST_NULL", "ICONST_M1", "ICONST_0", "ICONST_1", "ICONST_2", "ICONST_3", "ICONST_4", "ICONST_5", "LCONST_0", "LCONST_1", "FCONST_0", "FCONST_1", "FCONST_2", "DCONST_0", "DCONST_1", "BIPUSH", "SIPUSH", "LDC", "LDC_W", "LDC2_W", "ILOAD", "LLOAD", "FLOAD", "DLOAD", "ALOAD", "IALOAD", "LALOAD", "FALOAD", "DALOAD", "AALOAD", "BALOAD", "CALOAD", "SALOAD", "ISTORE", "LSTORE", "FSTORE", "DSTORE", "ASTORE", "IASTORE", "LASTORE", "FASTORE", "DASTORE", "AASTORE", "BASTORE", "CASTORE", "SASTORE", "POP", "POP2", "DUP", "DUP_X1", "DUP_X2", "DUP2", "DUP2_X1", "DUP2_X2", "SWAP", "IADD", "LADD", "FADD", "DADD", "ISUB", "LSUB", "FSUB", "DSUB", "IMUL", "LMUL", "FMUL", "DMUL", "IDIV", "LDIV", "FDIV", "DDIV", "IREM", "LREM", "FREM", "DREM", "INEG", "LNEG", "FNEG", "DNEG", "ISHL", "LSHL", "ISHR", "LSHR", "IUSHR", "LUSHR", "IAND", "LAND", "IOR", "LOR", "IXOR", "LXOR", "IINC", "I2L", "I2F", "I2D", "L2I", "L2F", "L2D", "F2I", "F2L", "F2D", "D2I", "D2L", "D2F", "I2B", "I2C", "I2S", "LCMP", "FCMPL", "FCMPG", "DCMPL", "DCMPG", "IFEQ", "IFNE", "IFLT", "IFGE", "IFGT", "IFLE", "IF_ICMPEQ", "IF_ICMPNE", "IF_ICMPLT", "IF_ICMPGE", "IF_ICMPGT", "IF_ICMPLE", "IF_ACMPEQ", "IF_ACMPNE", "GOTO", "JSR", "RET", "TABLESWITCH", "LOOKUPSWITCH", "IRETURN", "LRETURN", "FRETURN", "DRETURN", "ARETURN", "RETURN", "GETSTATIC", "PUTSTATIC", "GETFIELD", "PUTFIELD", "INVOKEVIRTUAL", "INVOKESPECIAL", "INVOKESTATIC", "INVOKEINTERFACE", "INVOKEDYNAMIC", "NEW", "NEWARRAY", "ANEWARRAY", "ARRAYLENGTH", "ATHROW", "CHECKCAST", "INSTANCEOF", "MONITORENTER", "MONITOREXIT", "MULTIANEWARRAY", "IFNULL", "IFNONNULL"};
    private static String opcodesAnys = RegexInsnFinder.buildRegexItems(opcodesAny, false, false);
    private MethodNode mn;
    private AbstractInsnNode[] origInstructions;
    private AbstractInsnNode[] instructions;
    private int[] offsets;
    private String insnString;

    private static String buildRegexItems(String[] items, boolean capture, boolean stdRepl) {
        if (items.length == 0) {
            return "()";
        }
        String result = (stdRepl ? "\\b" : "") + "(" + (capture ? "" : "?:") + items[0];
        for (int i = 1; i < items.length; ++i) {
            result = result + "|" + items[i];
        }
        result = result + ")";
        return result;
    }

    private static String buildRegexItems(String[] items) {
        return RegexInsnFinder.buildRegexItems(items, true, true);
    }

    public static String processRegex(String regex) {
        String result = regex.trim();
        result = result.replaceAll("\\bANYINSN *", opcodesAnys);
        result = result.replaceAll(opcodesInts + "\\\\\\{\\s*(\\d+)\\s*\\\\\\} *", "$1\\\\{$2\\\\} ");
        result = result.replaceAll(opcodesInts + " *", "$1\\\\{\\\\d+\\\\} ");
        result = result.replaceAll("\\bLDC\\\\\\{(.*?)\\\\\\}(?<!\\\\\\\\\\}) *", "LDC\\\\{$1\\\\}(?<!\\\\\\\\\\\\}) ");
        result = result.replaceAll("\\bLDC *", "LDC\\\\{.*?\\\\}(?<!\\\\\\\\\\\\}) ");
        result = result.replaceAll(opcodeVars + "(_\\d+) *", "$1$2 ");
        result = result.replaceAll(opcodeVars + "(?!_) *", "$1_\\\\d+ ");
        result = result.replaceAll("\\bIINC\\\\\\{\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\\\\\} *", "IINC\\\\{$1,$2\\\\} ");
        result = result.replaceAll("\\bIINC\\\\\\{\\s*(\\d+)\\s*\\\\\\} *", "IINC\\\\{\\d+,$1\\\\} ");
        result = result.replaceAll("\\bIINC *", "IINC\\\\{\\d+,\\d+\\\\} ");
        result = result.replaceAll(opcodesFields + "\\\\\\{\\s*(.*?)\\s*,\\s*(.*?)\\s*,\\s*(.*?)\\s*\\\\\\} *", "$1\\\\{$2,$3,$4\\\\} ");
        result = result.replaceAll(opcodesFields + "\\\\\\{((?:.(?!,))*)\\\\\\} *", "$1\\\\{$2,.*?,.*?\\\\} ");
        result = result.replaceAll(opcodesFields + " *", "$1\\\\{.*?\\\\} ");
        result = result.replaceAll(opcodesMethods + "\\\\\\{\\s*(.*?)\\s*,\\s*(.*?)\\s*,\\s*(.*?)\\s*\\\\\\} *", "$1\\\\{$2,$3,$4\\\\} ");
        result = result.replaceAll(opcodesMethods + "\\\\\\{((?:.(?!,))*)\\\\\\} *", "$1\\\\{$2,.*?,.*?\\\\} ");
        result = result.replaceAll(opcodesMethods + " *", "$1\\\\{.*?,.*?,.*?\\\\} ");
        result = result.replaceAll(opcodesTypes + "\\\\\\{\\s*(.*?)\\s*\\\\\\} +", "$1\\\\{$2\\\\} ");
        result = result.replaceAll(opcodesTypes + " +", "$1\\\\{\\\\.*?\\\\} ");
        result = result.replaceAll("\\bMULTIANEWARRAY\\\\\\{\\s*(\\d+)\\s*,\\s*(.*?)\\s*\\\\\\} *", "MULTIANEWARRAY\\\\{$1,$2\\\\} ");
        result = result.replaceAll("\\bMULTIANEWARRAY\\\\\\{\\s*(.*?)\\s*\\\\\\} *", "MULTIANEWARRAY\\\\{\\d+,$1\\\\} ");
        result = result.replaceAll("\\bMULTIANEWARRAY *", "MULTIANEWARRAY\\\\{\\\\\\d+,.*?\\\\} ");
        result = result.replaceAll("\\bIFINSN *", opcodesIfs + " ");
        return result;
    }

    public RegexInsnFinder(ClassNode clazz, MethodNode method) {
        this.setMethod(clazz, method);
    }

    private AbstractInsnNode[] cleanInsn(InsnList insnList) {
        ArrayList<AbstractInsnNode> il = new ArrayList<AbstractInsnNode>();
        ListIterator<AbstractInsnNode> iIt = insnList.iterator();
        while (iIt.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iIt.next();
            if (node.opcode() < 0) continue;
            il.add(node);
        }
        return il.toArray(new AbstractInsnNode[il.size()]);
    }

    public void refresh() {
        this.origInstructions = this.cleanInsn(this.mn.instructions);
        ArrayList<AbstractInsnNode> il = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode ain : this.mn.instructions.toArray()) {
            if (ain.opcode() < 0) continue;
            il.add(ain);
        }
        this.instructions = il.toArray(new AbstractInsnNode[il.size()]);
        this.offsets = new int[this.instructions.length];
        this.insnString = "";
        for (int i = 0; i < this.instructions.length; ++i) {
            this.offsets[i] = -1;
            AbstractInsnNode ain = this.instructions[i];
            if (ain.opcode() < 0) continue;
            if (ain.opcode() >= opcodes.length) {
                try {
                    throw new UnexpectedException("Unknown opcode encountered: " + ain.opcode());
                }
                catch (UnexpectedException e) {
                    new ExceptionUI(e);
                }
            }
            this.offsets[i] = this.insnString.length();
            this.insnString = this.insnString + opcodes[ain.opcode()];
            switch (ain.type()) {
                case 1: {
                    IntInsnNode iin = (IntInsnNode)ain;
                    this.insnString = this.insnString + "{" + iin.operand + "}";
                    break;
                }
                case 9: {
                    LdcInsnNode lin = (LdcInsnNode)ain;
                    this.insnString = this.insnString + "{" + lin.cst.toString().replace("}", "\\}") + "}";
                    break;
                }
                case 2: {
                    VarInsnNode vin = (VarInsnNode)ain;
                    this.insnString = this.insnString + "_" + vin.var;
                    break;
                }
                case 10: {
                    IincInsnNode iiin = (IincInsnNode)ain;
                    this.insnString = this.insnString + "{" + iiin.var + "," + iiin.incr + "}";
                    break;
                }
                case 4: {
                    FieldInsnNode fin = (FieldInsnNode)ain;
                    this.insnString = this.insnString + "{" + fin.desc + "," + fin.owner + "," + fin.name + "}";
                    break;
                }
                case 5: {
                    MethodInsnNode min = (MethodInsnNode)ain;
                    this.insnString = this.insnString + "{" + min.desc + "," + min.owner + "," + min.name + "}";
                    break;
                }
                case 3: {
                    TypeInsnNode tin = (TypeInsnNode)ain;
                    this.insnString = this.insnString + "{" + tin.desc + "}";
                    break;
                }
                case 13: {
                    MultiANewArrayInsnNode manain = (MultiANewArrayInsnNode)ain;
                    this.insnString = this.insnString + "{" + manain.dims + "," + manain.desc + "}";
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(ain.type()));
                }
            }
            this.insnString = this.insnString + " ";
        }
    }

    public void setMethod(ClassNode ci, MethodNode mi) {
        this.mn = mi;
        this.refresh();
    }

    private AbstractInsnNode[] makeResult(int start, int end) {
        int startIndex = 0;
        int endIndex = -1;
        for (int i = 0; i < this.offsets.length - 1; ++i) {
            int offset = this.offsets[i];
            if (offset == start) {
                startIndex = i;
            }
            if (offset >= end || this.offsets[i + 1] < end) continue;
            endIndex = i;
            break;
        }
        if (endIndex == -1) {
            endIndex = this.offsets.length - 1;
        }
        int length = endIndex - startIndex + 1;
        AbstractInsnNode[] result = new AbstractInsnNode[length];
        System.arraycopy(this.origInstructions, startIndex, result, 0, length);
        return result;
    }

    public AbstractInsnNode[] find(String regex) {
        try {
            Matcher regexMatcher = Pattern.compile(RegexInsnFinder.processRegex(regex), 8).matcher(this.insnString);
            if (regexMatcher.find()) {
                return this.makeResult(regexMatcher.start(), regexMatcher.end());
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return new AbstractInsnNode[0];
    }

    public List<AbstractInsnNode[]> findAll(String regex) {
        ArrayList<AbstractInsnNode[]> results = new ArrayList<AbstractInsnNode[]>();
        try {
            Matcher regexMatcher = Pattern.compile(RegexInsnFinder.processRegex(regex), 8).matcher(this.insnString);
            while (regexMatcher.find()) {
                results.add(this.makeResult(regexMatcher.start(), regexMatcher.end()));
            }
        }
        catch (PatternSyntaxException ex) {
            new ExceptionUI(ex);
        }
        return results;
    }

    public AbstractInsnNode[][] findGroups(String regex) {
        try {
            Matcher regexMatcher = Pattern.compile(RegexInsnFinder.processRegex(regex), 8).matcher(this.insnString);
            if (regexMatcher.find()) {
                AbstractInsnNode[][] result = new AbstractInsnNode[regexMatcher.groupCount() + 1][0];
                for (int i = 0; i <= regexMatcher.groupCount(); ++i) {
                    result[i] = this.makeResult(regexMatcher.start(i), regexMatcher.end(i));
                }
                return result;
            }
        }
        catch (PatternSyntaxException ex) {
            new ExceptionUI(ex);
        }
        return new AbstractInsnNode[0][0];
    }

    public List<AbstractInsnNode[][]> findAllGroups(String regex) {
        ArrayList<AbstractInsnNode[][]> results = new ArrayList<AbstractInsnNode[][]>();
        try {
            Matcher regexMatcher = Pattern.compile(RegexInsnFinder.processRegex(regex), 8).matcher(this.insnString);
            if (regexMatcher.find()) {
                AbstractInsnNode[][] result = new AbstractInsnNode[regexMatcher.groupCount() + 1][0];
                for (int i = 0; i <= regexMatcher.groupCount(); ++i) {
                    result[i] = this.makeResult(regexMatcher.start(i), regexMatcher.end(i));
                }
                results.add(result);
            }
        }
        catch (PatternSyntaxException ex) {
            new ExceptionUI(ex);
        }
        return results;
    }
}

