/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.storage.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.objectweb.asm.tree.FieldInsnNode;

public class FieldInsnNodeSerializer
implements JsonSerializer<FieldInsnNode>,
JsonDeserializer<FieldInsnNode> {
    public FieldInsnNode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String owner = null;
        String name = null;
        String desc = null;
        JsonObject object = (JsonObject)json;
        int opcode = object.get("opcode").getAsInt();
        owner = object.get("owner").getAsString();
        name = object.get("name").getAsString();
        desc = object.get("desc").getAsString();
        if (owner == null || name == null || desc == null) {
            throw new JsonParseException("Could not parse FieldInsnNode");
        }
        return new FieldInsnNode(opcode, owner, name, desc);
    }

    public JsonElement serialize(FieldInsnNode src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("opcode", context.serialize((Object)src.getOpcode(), Integer.class));
        jsonObject.add("owner", context.serialize((Object)src.owner, String.class));
        jsonObject.add("name", context.serialize((Object)src.name, String.class));
        jsonObject.add("desc", context.serialize((Object)src.desc, String.class));
        return jsonObject;
    }
}

