/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.view.component;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import jd.gui.api.feature.ContentCopyable;
import jd.gui.api.feature.ContentSearchable;
import jd.gui.api.feature.ContentSelectable;
import jd.gui.api.feature.LineNumberNavigable;
import jd.gui.api.feature.UriOpenable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;

public class TextPage
extends JPanel
implements ContentCopyable,
ContentSelectable,
LineNumberNavigable,
ContentSearchable,
UriOpenable,
GroovyObject {
    protected static final ImageIcon collapsedIcon;
    protected static final ImageIcon expandedIcon;
    protected static final Color doubleClickHighlightColor;
    protected static final Color searchHighlightColor;
    protected RSyntaxTextArea textArea;
    protected RTextScrollPane scrollPane;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public TextPage() {
        super(new BorderLayout());
        RTextScrollPane rTextScrollPane;
        RSyntaxTextArea rSyntaxTextArea;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.textArea = rSyntaxTextArea = this.newRSyntaxTextArea();
        this.textArea.setSyntaxEditingStyle(this.getSyntaxStyle());
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setAntiAliasingEnabled(true);
        int n = 0;
        this.textArea.setCaretPosition(n);
        boolean bl = false;
        this.textArea.setEditable(bl);
        Object var5_5 = null;
        this.textArea.setDropTarget((DropTarget)ScriptBytecodeAdapter.castToType(var5_5, DropTarget.class));
        Object var6_6 = null;
        this.textArea.setPopupMenu((JPopupMenu)ScriptBytecodeAdapter.castToType(var6_6, JPopupMenu.class));
        this.textArea.addMouseListener((MouseListener)((Object)new GroovyObject(this){
            public /* synthetic */ TextPage this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                TextPage textPage;
                this.this$0 = textPage = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Color color = doubleClickHighlightColor;
                    ((RSyntaxTextArea)this.getProperty("textArea")).setMarkAllHighlightColor(color);
                    int selectionStart = ((RSyntaxTextArea)this.getProperty("textArea")).getSelectionStart();
                    int selectionEnd = ((RSyntaxTextArea)this.getProperty("textArea")).getSelectionEnd();
                    SearchEngine.find((JTextArea)ScriptBytecodeAdapter.castToType(this.getProperty("textArea"), JTextArea.class), this.this$0.newSearchContext(((RSyntaxTextArea)this.getProperty("textArea")).getSelectedText(), true, true, true, false));
                    ((RSyntaxTextArea)this.getProperty("textArea")).select(selectionStart, selectionEnd);
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$5(name, args);
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$5(name, val);
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$5(name);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Override
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Override
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Override
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Override
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty(this, string);
            }

            @Override
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty(this, string, object);
            }
        }));
        KeyStroke ctrlA = KeyStroke.getKeyStroke(KeyEvent.VK_A, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke ctrlC = KeyStroke.getKeyStroke(KeyEvent.VK_C, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke ctrlV = KeyStroke.getKeyStroke(KeyEvent.VK_V, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        InputMap inputMap = this.textArea.getInputMap();
        inputMap.put(ctrlA, "none");
        inputMap.put(ctrlC, "none");
        inputMap.put(ctrlV, "none");
        Theme theme = Theme.load(this.getClass().getClassLoader().getResourceAsStream("rsyntaxtextarea/themes/eclipse.xml"));
        theme.apply(this.textArea);
        this.scrollPane = rTextScrollPane = new RTextScrollPane(this.textArea);
        boolean bl2 = true;
        this.scrollPane.setFoldIndicatorEnabled(bl2);
        Font font = this.textArea.getFont();
        this.scrollPane.setFont(font);
        Gutter gutter = this.scrollPane.getGutter();
        gutter.setFoldIcons(collapsedIcon, expandedIcon);
        Color color = gutter.getBorderColor();
        gutter.setFoldIndicatorForeground(color);
        this.add((Component)this.scrollPane, BorderLayout.CENTER);
    }

    protected RSyntaxTextArea newRSyntaxTextArea() {
        return new RSyntaxTextArea();
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String text) {
        String string = text;
        this.textArea.setText(string);
        int n = 0;
        this.textArea.setCaretPosition(n);
    }

    public String getSyntaxStyle() {
        return SyntaxConstants.SYNTAX_STYLE_NONE;
    }

    public void setCaretPositionAndCenter(DocumentRange range) {
        block7: {
            Reference<Integer> start = new Reference<Integer>(range.getStartOffset());
            Reference<Integer> end = new Reference<Integer>(range.getEndOffset());
            boolean foldsExpanded = false;
            FoldManager fm = this.textArea.getFoldManager();
            if (fm.isCodeFoldingSupportedAndEnabled()) {
                boolean bl;
                foldsExpanded = bl = fm.ensureOffsetNotInClosedFold(start.get());
                Boolean bl2 = DefaultGroovyMethods.or(foldsExpanded, fm.ensureOffsetNotInClosedFold(end.get()));
                foldsExpanded = DefaultTypeTransformation.booleanUnbox(bl2);
            }
            if (ScriptBytecodeAdapter.compareEqual(foldsExpanded, false)) {
                try {
                    Reference<Rectangle> r = new Reference<Rectangle>(this.textArea.modelToView(start.get()));
                    if (DefaultTypeTransformation.booleanUnbox(r.get())) {
                        this.setCaretPositionAndCenter(start.get(), end.get(), r.get());
                        break block7;
                    }
                    SwingUtilities.invokeLater(new Runnable(this, start, r, end){
                        public /* synthetic */ Reference end;
                        public /* synthetic */ Reference r;
                        public /* synthetic */ Reference start;
                        public /* synthetic */ TextPage this$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private transient /* synthetic */ MetaClass metaClass;
                        {
                            MetaClass metaClass;
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            TextPage textPage;
                            this.this$0 = textPage = p0;
                            this.end = reference3 = p3;
                            this.r = reference2 = p2;
                            this.start = reference = p1;
                            this.metaClass = metaClass = this.$getStaticMetaClass();
                        }

                        @Override
                        public void run() {
                            Rectangle rectangle = ((RSyntaxTextArea)this.getProperty("textArea")).modelToView(DefaultTypeTransformation.intUnbox(this.start.get()));
                            this.r.set(rectangle);
                            if (DefaultTypeTransformation.booleanUnbox(this.r.get())) {
                                this.this$0.setCaretPositionAndCenter(DefaultTypeTransformation.intUnbox(this.start.get()), DefaultTypeTransformation.intUnbox(this.end.get()), (Rectangle)ScriptBytecodeAdapter.castToType(this.r.get(), Rectangle.class));
                            }
                        }

                        public /* synthetic */ Object methodMissing(String name, Object args) {
                            return this.this$0.this$dist$invoke$5(name, args);
                        }

                        public /* synthetic */ void propertyMissing(String name, Object val) {
                            this.this$0.this$dist$set$5(name, val);
                        }

                        public /* synthetic */ Object propertyMissing(String name) {
                            return this.this$0.this$dist$get$5(name);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (this.getClass() != 2.class) {
                                return ScriptBytecodeAdapter.initMetaClass(this);
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        @Override
                        public /* synthetic */ MetaClass getMetaClass() {
                            MetaClass metaClass = this.metaClass;
                            if (metaClass != null) {
                                return metaClass;
                            }
                            this.metaClass = this.$getStaticMetaClass();
                            return this.metaClass;
                        }

                        @Override
                        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                            this.metaClass = metaClass;
                        }

                        @Override
                        public /* synthetic */ Object invokeMethod(String string, Object object) {
                            return this.getMetaClass().invokeMethod((Object)this, string, object);
                        }

                        @Override
                        public /* synthetic */ Object getProperty(String string) {
                            return this.getMetaClass().getProperty(this, string);
                        }

                        @Override
                        public /* synthetic */ void setProperty(String string, Object object) {
                            this.getMetaClass().setProperty(this, string, object);
                        }
                    });
                }
                catch (BadLocationException ignore) {
                }
            }
        }
    }

    protected void setCaretPositionAndCenter(int start, int end, Rectangle r) {
        if (end != start) {
            Rectangle rectangle;
            r = rectangle = r.union(this.textArea.modelToView(end));
        }
        Rectangle visible = this.textArea.getVisibleRect();
        int n = DefaultTypeTransformation.intUnbox(ScriptBytecodeAdapter.asType(NumberNumberMinus.minus(r.y, NumberNumberDiv.div(visible.height - r.height, 2)), Integer.TYPE));
        ScriptBytecodeAdapter.setField(n, TextPage.class, visible, "y");
        Rectangle bounds = this.textArea.getBounds();
        Insets i = this.textArea.getInsets();
        int n2 = i.top;
        ScriptBytecodeAdapter.setField(n2, TextPage.class, bounds, "y");
        ScriptBytecodeAdapter.setField(bounds.height - (i.top + i.bottom), TextPage.class, bounds, "height");
        if (visible.y < bounds.y) {
            int n3 = bounds.y;
            ScriptBytecodeAdapter.setField(n3, TextPage.class, visible, "y");
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            int n4 = bounds.y + bounds.height - visible.height;
            ScriptBytecodeAdapter.setField(n4, TextPage.class, visible, "y");
        }
        this.textArea.scrollRectToVisible(visible);
        int n5 = start;
        this.textArea.setCaretPosition(n5);
    }

    @Override
    public void copy() {
        if (this.textArea.getSelectionStart() == this.textArea.getSelectionEnd()) {
            this.getToolkit().getSystemClipboard().setContents(new StringSelection(""), null);
        } else {
            this.textArea.copyAsRtf();
        }
    }

    @Override
    public void selectAll() {
        this.textArea.selectAll();
    }

    @Override
    public int getMaximumLineNumber() {
        return this.textArea.getLineOfOffset(this.textArea.getDocument().getLength());
    }

    @Override
    public void goToLineNumber(int lineNumber) {
        int n = this.textArea.getLineStartOffset(lineNumber - 1);
        this.textArea.setCaretPosition(n);
    }

    @Override
    public boolean checkLineNumber(int lineNumber) {
        return true;
    }

    @Override
    public boolean highlightText(String text, boolean caseSensitive) {
        if (text.length() > 1) {
            Color color = searchHighlightColor;
            this.textArea.setMarkAllHighlightColor(color);
            int n = this.textArea.getSelectionStart();
            this.textArea.setCaretPosition(n);
            SearchContext context = this.newSearchContext(text, caseSensitive, false, true, false);
            SearchResult result = SearchEngine.find(this.textArea, context);
            if (!result.wasFound()) {
                SearchResult searchResult;
                int n2 = 0;
                this.textArea.setCaretPosition(n2);
                result = searchResult = SearchEngine.find(this.textArea, context);
            }
            return result.wasFound();
        }
        return true;
    }

    @Override
    public void findNext(String text, boolean caseSensitive) {
        if (text.length() > 1) {
            Color color = searchHighlightColor;
            this.textArea.setMarkAllHighlightColor(color);
            SearchContext context = this.newSearchContext(text, caseSensitive, false, true, false);
            SearchResult result = SearchEngine.find(this.textArea, context);
            if (!result.wasFound()) {
                int n = 0;
                this.textArea.setCaretPosition(n);
                SearchEngine.find(this.textArea, context);
            }
        }
    }

    @Override
    public void findPrevious(String text, boolean caseSensitive) {
        if (text.length() > 1) {
            Color color = searchHighlightColor;
            this.textArea.setMarkAllHighlightColor(color);
            SearchContext context = this.newSearchContext(text, caseSensitive, false, false, false);
            SearchResult result = SearchEngine.find(this.textArea, context);
            if (!result.wasFound()) {
                int n = this.textArea.getDocument().getLength();
                this.textArea.setCaretPosition(n);
                SearchEngine.find(this.textArea, context);
            }
        }
    }

    protected SearchContext newSearchContext(String searchFor, boolean matchCase, boolean wholeWord, boolean searchForward, boolean regexp) {
        SearchContext context = new SearchContext(searchFor, matchCase);
        boolean bl = true;
        context.setMarkAll(bl);
        boolean bl2 = wholeWord;
        context.setWholeWord(bl2);
        boolean bl3 = searchForward;
        context.setSearchForward(bl3);
        boolean bl4 = regexp;
        context.setRegularExpression(bl4);
        return context;
    }

    @Override
    public boolean openUri(URI uri) {
        String query = uri.getQuery();
        if (DefaultTypeTransformation.booleanUnbox(query)) {
            Map<String, String> parameters = this.parseQuery(query);
            if (parameters.containsKey("lineNumber")) {
                String lineNumber = ShortTypeHandling.castToString(parameters.get("lineNumber"));
                if (StringGroovyMethods.isNumber((CharSequence)lineNumber)) {
                    this.goToLineNumber(StringGroovyMethods.toInteger((CharSequence)lineNumber));
                    return true;
                }
            } else if (parameters.containsKey("position")) {
                String position = ShortTypeHandling.castToString(parameters.get("position"));
                if (StringGroovyMethods.isNumber((CharSequence)position)) {
                    int pos = StringGroovyMethods.toInteger((CharSequence)position);
                    if (this.textArea.getDocument().getLength() > pos) {
                        this.setCaretPositionAndCenter(new DocumentRange(pos, pos));
                        return true;
                    }
                }
            } else if (parameters.containsKey("highlightFlags")) {
                String highlightFlags = ShortTypeHandling.castToString(parameters.get("highlightFlags"));
                if (ScriptBytecodeAdapter.compareNotEqual(highlightFlags.indexOf("s"), -1) && parameters.containsKey("highlightPattern")) {
                    Color color = searchHighlightColor;
                    this.textArea.setMarkAllHighlightColor(color);
                    int n = 0;
                    this.textArea.setCaretPosition(n);
                    String searchFor = TextPage.createRegExp(ShortTypeHandling.castToString(parameters.get("highlightPattern")));
                    SearchContext context = this.newSearchContext(searchFor, true, false, true, true);
                    SearchResult result = SearchEngine.find(this.textArea, context);
                    if (DefaultTypeTransformation.booleanUnbox(result.getMatchRange())) {
                        int n2 = result.getMatchRange().getStartOffset();
                        this.textArea.setCaretPosition(n2);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected Map<String, String> parseQuery(String query) {
        LinkedHashMap parameters = (LinkedHashMap)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createMap(new Object[0]), LinkedHashMap.class);
        String param = null;
        Iterator iterator = DefaultGroovyMethods.iterator(query.split("&"));
        while (iterator.hasNext()) {
            param = ShortTypeHandling.castToString(iterator.next());
            int index = param.indexOf("=");
            if (ScriptBytecodeAdapter.compareEqual(index, -1)) {
                parameters.put(URLDecoder.decode(param, "UTF-8"), "");
                continue;
            }
            String key = param.substring(0, index);
            String value = param.substring(index + 1);
            parameters.put(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
        }
        return parameters;
    }

    public static String createRegExp(String pattern) {
        int patternLength = pattern.length();
        StringBuffer sbPattern = new StringBuffer(patternLength * 2);
        int i = 0;
        while (i < patternLength) {
            char c = pattern.charAt(i);
            if (ScriptBytecodeAdapter.compareEqual(Character.valueOf(c), "*")) {
                sbPattern.append(".*");
            } else if (ScriptBytecodeAdapter.compareEqual(Character.valueOf(c), "?")) {
                sbPattern.append(".");
            } else if (ScriptBytecodeAdapter.compareEqual(Character.valueOf(c), ".")) {
                sbPattern.append("\\.");
            } else {
                sbPattern.append(c);
            }
            int n = i;
            int cfr_ignored_0 = n + 1;
        }
        return sbPattern.toString();
    }

    public /* synthetic */ Object this$dist$invoke$5(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(TextPage.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$5(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, TextPage.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$5(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(TextPage.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TextPage.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    static {
        Color color;
        Color color2;
        ImageIcon imageIcon;
        ImageIcon imageIcon2;
        collapsedIcon = imageIcon2 = new ImageIcon(TextPage.class.getClassLoader().getResource("images/plus.png"));
        expandedIcon = imageIcon = new ImageIcon(TextPage.class.getClassLoader().getResource("images/minus.png"));
        doubleClickHighlightColor = color2 = Color.GREEN;
        searchHighlightColor = color = Color.YELLOW;
    }
}

