/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.commons.cfg.query;

import org.objectweb.asm.commons.cfg.query.InsnQuery;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NumberQuery
extends InsnQuery {
    private int number = -1;

    public NumberQuery(int opcode) {
        super(opcode);
    }

    public NumberQuery(int opcode, int number) {
        this(opcode);
        this.number = number;
    }

    @Override
    public boolean matches(AbstractInsnNode ain) {
        if (!(ain instanceof IntInsnNode || ain instanceof LdcInsnNode || ain instanceof VarInsnNode)) {
            return false;
        }
        if (ain instanceof IntInsnNode) {
            return this.number == -1 || ((IntInsnNode)ain).operand == this.number;
        }
        if (ain instanceof LdcInsnNode) {
            Object cst = ((LdcInsnNode)ain).cst;
            return this.number == -1 || cst instanceof Number && ((Number)cst).intValue() == this.number;
        }
        return this.number == -1 || ((VarInsnNode)ain).var == this.number;
    }
}

