/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer;

import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.zip.ZipUtil;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.InitialBootScreen;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;

public class Boot {
    private static InitialBootScreen screen;

    public static void boot() throws Exception {
        File enjarifyDirectory = new File(BytecodeViewer.getBCVDirectory() + BytecodeViewer.fs + "enjarify_" + "2");
        File krakatauDirectory = new File(BytecodeViewer.getBCVDirectory() + BytecodeViewer.fs + "krakatau_" + "8");
        if (!enjarifyDirectory.exists() || !krakatauDirectory.exists()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    screen.setVisible(true);
                }
            });
        }
        screen.getProgressBar().setMaximum(BootSequence.values().length);
        Boot.setState(BootSequence.CHECKING_LIBRARIES);
        Boot.checkEnjarify();
        Boot.checkKrakatau();
        Boot.setState(BootSequence.BOOTING);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                screen.setVisible(false);
            }
        });
    }

    public static void setState(BootSequence s) {
        screen.setTitle("Initialzing Bytecode Viewer - " + s.getMessage());
        screen.getProgressBar().setValue(s.ordinal());
        System.out.println(s.getMessage());
    }

    public static void checkEnjarify() {
        Boot.setState(BootSequence.CHECKING_ENJARIFY);
        for (File f : new File(BytecodeViewer.getBCVDirectory()).listFiles()) {
            if (!f.getName().toLowerCase().startsWith("enjarify_") || f.getName().split("_")[1].split("\\.")[0].equals("2")) continue;
            Boot.setState(BootSequence.CLEANING_ENJARIFY);
            try {
                FileUtils.deleteDirectory((File)f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File enjarifyDirectory = new File(BytecodeViewer.getBCVDirectory() + BytecodeViewer.fs + "enjarify_" + "2");
        if (!enjarifyDirectory.exists()) {
            try {
                Boot.setState(BootSequence.MOVING_ENJARIFY);
                Path temporaryEnjarifyZip = Files.createTempFile("enjarify", ".zip", new FileAttribute[0]);
                Files.delete(temporaryEnjarifyZip);
                InputStream inputStream = Boot.class.getResourceAsStream("/enjarify-2.zip");
                Files.copy(inputStream, temporaryEnjarifyZip, new CopyOption[0]);
                ZipUtil.unpack((File)temporaryEnjarifyZip.toFile(), (File)enjarifyDirectory);
                Files.delete(temporaryEnjarifyZip);
            }
            catch (Exception e) {
                BytecodeViewer.showMessage("ERROR: There was an issue unzipping enjarify (possibly corrupt). Restart BCV." + BytecodeViewer.nl + "If the error persists contact @Konloch.");
                new ExceptionUI(e);
            }
        }
    }

    public static void checkKrakatau() {
        Boot.setState(BootSequence.CHECKING_KRAKATAU);
        for (File f : new File(BytecodeViewer.getBCVDirectory()).listFiles()) {
            if (!f.getName().toLowerCase().startsWith("krakatau_") || f.getName().split("_")[1].split("\\.")[0].equals("8")) continue;
            Boot.setState(BootSequence.CLEANING_KRAKATAU);
            try {
                FileUtils.deleteDirectory((File)f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File krakatauDirectory = new File(BytecodeViewer.getBCVDirectory() + BytecodeViewer.fs + "krakatau_" + "8");
        if (!krakatauDirectory.exists()) {
            try {
                Boot.setState(BootSequence.MOVING_KRAKATAU);
                Path temporaryKrakatauZip = Files.createTempFile("krakatau", ".zip", new FileAttribute[0]);
                Files.delete(temporaryKrakatauZip);
                InputStream inputStream = Boot.class.getResourceAsStream("/Krakatau-8.zip");
                Files.copy(inputStream, temporaryKrakatauZip, new CopyOption[0]);
                ZipUtil.unpack((File)temporaryKrakatauZip.toFile(), (File)krakatauDirectory);
                Files.delete(temporaryKrakatauZip);
            }
            catch (Exception e) {
                BytecodeViewer.showMessage("ERROR: There was an issue unzipping Krakatau decompiler (possibly corrupt). Restart BCV." + BytecodeViewer.nl + "If the error persists contact @Konloch.");
                new ExceptionUI(e);
            }
        }
    }

    static {
        try {
            screen = new InitialBootScreen();
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
    }

    static enum BootSequence {
        CHECKING_LIBRARIES("Checking libraries"),
        CHECKING_ENJARIFY("Checking Enjarify"),
        CLEANING_ENJARIFY("Cleaning Enjarify"),
        MOVING_ENJARIFY("Moving Enjarify"),
        CHECKING_KRAKATAU("Checking Krakatau"),
        CLEANING_KRAKATAU("Cleaning Krakatau"),
        MOVING_KRAKATAU("Moving Krakatau"),
        BOOTING("Booting");

        private String message;

        private BootSequence(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

