/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer;

import com.eclipsesource.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;

public class DecompilerSettings {
    private Decompiler decompiler;
    private Map<Setting, JCheckBoxMenuItem> menuItems = new HashMap<Setting, JCheckBoxMenuItem>();
    private List<Setting> registrationOrder = new ArrayList<Setting>();

    public DecompilerSettings(Decompiler decompiler) {
        this.decompiler = decompiler;
    }

    public void registerSetting(Setting setting) {
        if (!this.menuItems.containsKey(setting)) {
            this.registrationOrder.add(setting);
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(setting.getText());
            if (setting.isDefaultOn()) {
                item.setSelected(true);
            }
            this.menuItems.put(setting, item);
        }
    }

    public boolean isSelected(Setting setting) {
        return this.menuItems.get(setting).isSelected();
    }

    public JCheckBoxMenuItem getMenuItem(Setting setting) {
        return this.menuItems.get(setting);
    }

    public int size() {
        return this.registrationOrder.size();
    }

    public void loadFrom(JsonObject rootSettings) {
        JsonObject decompilerSection;
        if (rootSettings.get("decompilers") != null && (decompilerSection = rootSettings.get("decompilers").asObject()).get(this.decompiler.getName()) != null) {
            JsonObject thisDecompiler = decompilerSection.get(this.decompiler.getName()).asObject();
            for (Map.Entry<Setting, JCheckBoxMenuItem> entry : this.menuItems.entrySet()) {
                if (thisDecompiler.get(entry.getKey().getParam()) == null) continue;
                entry.getValue().setSelected(thisDecompiler.get(entry.getKey().getParam()).asBoolean());
            }
        }
    }

    public void saveTo(JsonObject rootSettings) {
        JsonObject decompilerSection;
        if (rootSettings.get("decompilers") == null) {
            rootSettings.add("decompilers", new JsonObject());
        }
        if ((decompilerSection = rootSettings.get("decompilers").asObject()).get(this.decompiler.getName()) == null) {
            decompilerSection.add(this.decompiler.getName(), new JsonObject());
        }
        JsonObject thisDecompiler = decompilerSection.get(this.decompiler.getName()).asObject();
        for (Map.Entry<Setting, JCheckBoxMenuItem> entry : this.menuItems.entrySet()) {
            thisDecompiler.add(entry.getKey().getParam(), entry.getValue().isSelected());
        }
    }

    public static interface Setting {
        public String getText();

        public String getParam();

        public boolean isDefaultOn();
    }
}

