/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.ParseException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButtonMenuItem;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;

public class Settings<T> {
    private static final Map<String, Settings> ALL_SETTINGS = new HashMap<String, Settings>();
    public static final Settings<String> PYTHON2_LOCATION = new Settings<String>("python2location", "");
    public static final Settings<String> PYTHON3_LOCATION = new Settings<String>("python3location", "");
    public static final Settings<String> JAVAC_LOCATION = new Settings<String>("javaclocation", "");
    public static final Settings<String> JAVA_LOCATION = new Settings<String>("javalocation", "");
    public static final Settings<String> RT_LOCATION = new Settings<String>("rtlocation", "");
    public static final Settings<String> PATH = new Settings<String>("path", "");
    public static final Settings<List<Decompiler>> PANES = new Settings<List<Decompiler>>("panes", Arrays.asList(Decompiler.FERNFLOWER, Decompiler.BYTECODE, null));
    public static final Settings<Boolean> COMPILE_ON_SAVE = new Settings<Boolean>("compileOnSave", true);
    public static final Settings<Boolean> COMPILE_ON_REFRESH = new Settings<Boolean>("compileOnRefresh", true);
    public static final Settings<Boolean> REFRESH_ON_CHANGE = new Settings<Boolean>("refreshOnChange", false);
    public static final Settings<Boolean> DECODE_APK_RESOURCES = new Settings<Boolean>("decodeAPKResources", true);
    public static final Settings<Boolean> UPDATE_CHECK = new Settings<Boolean>("updateCheck", true);
    public static final Settings<Boolean> DELETE_OUTDATED_LIBS = new Settings<Boolean>("deleteOutdatedLibs", true);
    public static final Settings<Integer> GUI_WIDTH = new Settings<Integer>("guiWidth", 800);
    public static final Settings<Integer> GUI_HEIGHT = new Settings<Integer>("guiHeight", 400);
    public static final Settings<Integer> FILE_NAVIGATION_PANE_WIDTH = new Settings<Integer>("fileNavigationPaneWidth", 200);
    public static final Settings<Integer> FILE_NAVIGATION_PANE_HEIGHT = new Settings<Integer>("fileNavigationPaneHeight", 50);
    public static final Settings<Integer> SEARCHING_PANE_WIDTH = new Settings<Integer>("searchingPaneWidth", 200);
    public static final Settings<Integer> SEARCHING_PANE_HEIGHT = new Settings<Integer>("searchingPaneHeight", 50);
    public static final Settings<Boolean> SYNCHRONIZE_VIEWING = new Settings<Boolean>("synchronizeViewing", false);
    public static final Settings<Boolean> SHOW_METHODS_LIST = new Settings<Boolean>("showMethodsList", false);
    private String key;
    private T value;

    public Settings(String key, T value) {
        this.key = key;
        this.value = value;
        ALL_SETTINGS.put(this.key, this);
    }

    public T get() {
        if (this.isEmpty()) {
            return null;
        }
        return this.value;
    }

    public String getType() {
        if (this.value != null) {
            return this.value.getClass().getSimpleName();
        }
        return "";
    }

    public void set(T value) {
        this.value = value;
    }

    public boolean isEmpty() {
        return this.value == null || this.value instanceof String && ((String)this.value).isEmpty() || this.value instanceof Integer && (Integer)this.value == 0 || this.value instanceof ArrayList && ((ArrayList)this.value).isEmpty();
    }

    private static void savePanes(JsonObject rootSettings) {
        if (rootSettings.get("panes") == null) {
            rootSettings.add("panes", new JsonObject());
        }
        JsonObject panes = rootSettings.get("panes").asObject();
        for (int i = 0; i < BytecodeViewer.viewer.allPanes.size(); ++i) {
            ButtonGroup group = BytecodeViewer.viewer.allPanes.get(i);
            for (Map.Entry<JRadioButtonMenuItem, Decompiler> entry : BytecodeViewer.viewer.allDecompilers.get(group).entrySet()) {
                if (!group.isSelected(entry.getKey().getModel()) || entry.getValue() == null) continue;
                panes.add(Integer.toString(i), entry.getValue().getName());
            }
        }
    }

    private static void loadPanes(JsonObject rootSettings) {
        if (rootSettings.get("panes") != null) {
            JsonObject panes = rootSettings.get("panes").asObject();
            ArrayList<Decompiler> decompilers = new ArrayList<Decompiler>();
            for (JsonObject.Member value : panes) {
                decompilers.add(Decompiler.getByName(value.getValue().asString()));
            }
            PANES.set(decompilers);
        }
    }

    public static void saveSettings() {
        try {
            JsonObject settings = new JsonObject();
            Decompiler.CFR.getSettings().saveTo(settings);
            Decompiler.FERNFLOWER.getSettings().saveTo(settings);
            Decompiler.PROCYON.getSettings().saveTo(settings);
            Decompiler.BYTECODE.getSettings().saveTo(settings);
            if (settings.get("settings") == null) {
                settings.add("settings", new JsonObject());
            }
            JsonObject rootSettings = settings.get("settings").asObject();
            block13: for (Map.Entry<String, Settings> setting : ALL_SETTINGS.entrySet()) {
                if (setting.getValue().get() == null) continue;
                switch (setting.getValue().getType()) {
                    case "Integer": {
                        rootSettings.add(setting.getKey(), (Integer)setting.getValue().get());
                        continue block13;
                    }
                    case "Boolean": {
                        rootSettings.add(setting.getKey(), (Boolean)setting.getValue().get());
                        continue block13;
                    }
                    case "ArrayList": {
                        if (!setting.getKey().equals(Settings.PANES.key)) continue block13;
                        Settings.savePanes(rootSettings);
                        continue block13;
                    }
                }
                rootSettings.add(setting.getKey(), setting.getValue().get().toString());
            }
            FileOutputStream out = new FileOutputStream(BytecodeViewer.settingsFile);
            out.write(settings.toString().getBytes("UTF-8"));
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void loadSettings() {
        try {
            JsonObject settings = new JsonObject();
            try {
                settings = JsonObject.readFrom(new FileReader(BytecodeViewer.settingsFile));
            }
            catch (ParseException | UnsupportedOperationException runtimeException) {
                // empty catch block
            }
            Decompiler.CFR.getSettings().loadFrom(settings);
            Decompiler.FERNFLOWER.getSettings().loadFrom(settings);
            Decompiler.PROCYON.getSettings().loadFrom(settings);
            Decompiler.BYTECODE.getSettings().loadFrom(settings);
            if (settings.get("settings") != null) {
                JsonObject rootSettings = settings.get("settings").asObject();
                block15: for (Map.Entry<String, Settings> setting : ALL_SETTINGS.entrySet()) {
                    if (rootSettings.get(setting.getKey()) == null) continue;
                    switch (setting.getValue().getType()) {
                        case "Integer": {
                            setting.getValue().set(rootSettings.get(setting.getKey()).asInt());
                            continue block15;
                        }
                        case "Boolean": {
                            setting.getValue().set(rootSettings.get(setting.getKey()).asBoolean());
                            continue block15;
                        }
                        case "ArrayList": {
                            if (!setting.getKey().equals(Settings.PANES.key)) continue block15;
                            Settings.loadPanes(rootSettings);
                            continue block15;
                        }
                    }
                    setting.getValue().set(rootSettings.get(setting.getKey()).asString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

