/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.api;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.api.BytecodeHook;
import the.bytecode.club.bytecodeviewer.api.ClassNodeLoader;
import the.bytecode.club.bytecodeviewer.compilers.Compiler;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;
import the.bytecode.club.bytecodeviewer.plugin.preinstalled.EZInjection;

public class BytecodeViewer {
    private static URLClassLoader cl;

    private BytecodeViewer() {
    }

    public static ClassNodeLoader getClassNodeLoader() {
        return the.bytecode.club.bytecodeviewer.BytecodeViewer.loader;
    }

    public static URLClassLoader getClassLoaderInstance() {
        return cl;
    }

    public static List<Class<?>> loadClassesIntoClassLoader(ArrayList<ClassNode> nodeList) throws IOException, ClassNotFoundException {
        File f = new File(the.bytecode.club.bytecodeviewer.BytecodeViewer.tempDir, "loaded_temp.jar");
        JarUtils.saveAsJarClassesOnly(nodeList, f.getAbsolutePath());
        JarFile jarFile = new JarFile("" + f.getAbsolutePath());
        Enumeration<JarEntry> e = jarFile.entries();
        cl = URLClassLoader.newInstance(new URL[]{f.toURL()});
        ArrayList ret = new ArrayList();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
            String className = je.getName().replace("/", ".").replace(".class", "");
            className = className.replace('/', '.');
            ret.add(cl.loadClass(className));
        }
        jarFile.close();
        return ret;
    }

    public static List<Class<?>> loadAllClassesIntoClassLoader() throws ClassNotFoundException, IOException {
        return BytecodeViewer.loadClassesIntoClassLoader(BytecodeViewer.getLoadedClasses());
    }

    public static void createNewClassNodeLoaderInstance() {
        the.bytecode.club.bytecodeviewer.BytecodeViewer.loader.clear();
        the.bytecode.club.bytecodeviewer.BytecodeViewer.loader = new ClassNodeLoader();
    }

    public static void startPlugin(File plugin) {
        the.bytecode.club.bytecodeviewer.BytecodeViewer.startPlugin(plugin);
    }

    public static void openFiles(File[] files, boolean recentFiles) {
        the.bytecode.club.bytecodeviewer.BytecodeViewer.openFiles(files, recentFiles);
    }

    public static ClassNode getCurrentlyOpenedClassNode() {
        return the.bytecode.club.bytecodeviewer.BytecodeViewer.getCurrentlyOpenedClassNode();
    }

    public static ClassNode getClassNode(String containerName, String name) {
        return the.bytecode.club.bytecodeviewer.BytecodeViewer.getClassNode(containerName, name);
    }

    public static ArrayList<ClassNode> getLoadedClasses() {
        return the.bytecode.club.bytecodeviewer.BytecodeViewer.getLoadedClasses();
    }

    public static void insertHook(BytecodeHook hook) {
        EZInjection.hookArray.add(hook);
    }

    public static void resetWorkSpace(boolean ask) {
        the.bytecode.club.bytecodeviewer.BytecodeViewer.resetWorkSpace(ask);
    }

    public static void setBusy(boolean busy) {
        the.bytecode.club.bytecodeviewer.BytecodeViewer.viewer.setIcon(busy);
    }

    public static void showMessage(String message) {
        the.bytecode.club.bytecodeviewer.BytecodeViewer.showMessage(message);
    }

    public static Decompiler getKrakatauDecompiler() {
        return Decompiler.KRAKATAU;
    }

    public static Decompiler getProcyonDecompiler() {
        return Decompiler.PROCYON;
    }

    public static Decompiler getCFRDecompiler() {
        return Decompiler.CFR;
    }

    public static Decompiler getFernFlowerDecompiler() {
        return Decompiler.FERNFLOWER;
    }

    public static Decompiler getKrakatauDisassembler() {
        return Decompiler.KRAKATAU_DA;
    }

    public static Compiler getKrakatauCompiler() {
        return Compiler.krakatau;
    }

    public static Compiler getSmaliCompiler() {
        return Compiler.smali;
    }

    public static Decompiler getDJGUIDecompiler() {
        return Decompiler.JDGUI;
    }
}

