/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.compilers;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.jf.smali.main;
import org.zeroturnaround.zip.ZipUtil;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.Dex2Jar;
import the.bytecode.club.bytecodeviewer.Enjarify;
import the.bytecode.club.bytecodeviewer.MiscUtils;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.compilers.Compiler;

public class SmaliAssembler
extends Compiler {
    @Override
    public byte[] compile(String contents, String name) {
        String fileStart = BytecodeViewer.tempDir.getAbsoluteFile() + BytecodeViewer.fs + "temp";
        int fileNumber = MiscUtils.getClassNumber(fileStart, ".dex");
        File tempSmaliFolder = new File(fileStart + fileNumber + "-smalifolder" + BytecodeViewer.fs);
        tempSmaliFolder.mkdir();
        File tempSmali = new File(tempSmaliFolder.getAbsolutePath() + BytecodeViewer.fs + fileNumber + ".smali");
        File tempDex = new File(fileStart + fileNumber + ".dex");
        File tempJar = new File(fileStart + fileNumber + ".jar");
        File tempJarFolder = new File(fileStart + fileNumber + "-jar" + BytecodeViewer.fs);
        try {
            FileUtils.write((File)tempSmali, (CharSequence)contents, (String)"UTF-8", (boolean)false);
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
        try {
            main.main((String[])new String[]{tempSmaliFolder.getAbsolutePath(), "-o", tempDex.getAbsolutePath()});
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
        if (BytecodeViewer.viewer.apkConversionGroup.isSelected(BytecodeViewer.viewer.apkConversionDex.getModel())) {
            Dex2Jar.dex2Jar(tempDex, tempJar);
        } else if (BytecodeViewer.viewer.apkConversionGroup.isSelected(BytecodeViewer.viewer.apkConversionEnjarify.getModel())) {
            Enjarify.apk2Jar(tempDex, tempJar);
        }
        try {
            ZipUtil.unpack((File)tempJar, (File)tempJarFolder);
            File outputClass = null;
            boolean found = false;
            File current = tempJarFolder;
            try {
                while (!found) {
                    File f = current.listFiles()[0];
                    if (f.isDirectory()) {
                        current = f;
                        continue;
                    }
                    outputClass = f;
                    found = true;
                }
                return FileUtils.readFileToByteArray(outputClass);
            }
            catch (NullPointerException nullPointerException) {
            }
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
        return null;
    }
}

