/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.decompiler.ConsoleDecompiler;
import org.jetbrains.java.decompiler.main.decompiler.PrintStreamLogger;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.objectweb.asm.tree.ClassNode;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.DecompilerSettings;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;

public class FernFlowerDecompiler
extends Decompiler {
    public FernFlowerDecompiler() {
        for (Settings setting : Settings.values()) {
            this.settings.registerSetting(setting);
        }
    }

    @Override
    public String getName() {
        return "FernFlower";
    }

    @Override
    public String decompileClassNode(ClassNode cn, byte[] b) {
        try {
            if (cn.version < 49) {
                b = this.fixBytes(b);
            }
            final byte[] bytesToUse = b;
            Map<String, Object> options = this.main(this.generateMainMethod());
            final AtomicReference result = new AtomicReference();
            result.set(null);
            BaseDecompiler baseDecompiler = new BaseDecompiler(new IBytecodeProvider(){

                public byte[] getBytecode(String s, String s1) throws IOException {
                    byte[] clone = new byte[bytesToUse.length];
                    System.arraycopy(bytesToUse, 0, clone, 0, bytesToUse.length);
                    return clone;
                }
            }, new IResultSaver(){

                public void saveFolder(String s) {
                }

                public void copyFile(String s, String s1, String s2) {
                }

                public void saveClassFile(String s, String s1, String s2, String s3, int[] ints) {
                    result.set(s3);
                }

                public void createArchive(String s, String s1, Manifest manifest) {
                }

                public void saveDirEntry(String s, String s1, String s2) {
                }

                public void copyEntry(String s, String s1, String s2, String s3) {
                }

                public void saveClassEntry(String s, String s1, String s2, String s3, String s4) {
                }

                public void closeArchive(String s, String s1) {
                }
            }, options, (IFernflowerLogger)new PrintStreamLogger(System.out));
            baseDecompiler.addSpace(new File(cn.name + ".class"), true);
            baseDecompiler.decompileContext();
            while (result.get() == null) {
            }
            return (String)result.get();
        }
        catch (Exception e) {
            return this.parseException(e);
        }
    }

    @Override
    public void decompileToZip(String zipName) {
        try {
            Path outputDir = Files.createTempDirectory("fernflower_output", new FileAttribute[0]);
            Path tempJar = Files.createTempFile("fernflower_input", ".jar", new FileAttribute[0]);
            File output = new File(zipName);
            JarUtils.saveAsJar(BytecodeViewer.getLoadedBytes(), tempJar.toAbsolutePath().toString());
            ConsoleDecompiler decompiler = new ConsoleDecompiler(outputDir.toFile(), this.main(this.generateMainMethod()));
            decompiler.addSpace(tempJar.toFile(), true);
            decompiler.decompileContext();
            Files.move(outputDir.toFile().listFiles()[0].toPath(), output.toPath(), new CopyOption[0]);
            Files.delete(tempJar);
            FileUtils.deleteDirectory((File)outputDir.toFile());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public Map<String, Object> main(String[] args) {
        HashMap<String, Object> mapOptions = new HashMap<String, Object>();
        boolean isOption = true;
        for (int destination = 0; destination < args.length - 1; ++destination) {
            String logger = args[destination];
            if (isOption && logger.length() > 5 && logger.charAt(0) == '-' && logger.charAt(4) == '=') {
                String decompiler = logger.substring(5);
                if ("true".equalsIgnoreCase(decompiler)) {
                    decompiler = "1";
                } else if ("false".equalsIgnoreCase(decompiler)) {
                    decompiler = "0";
                }
                mapOptions.put(logger.substring(1, 4), decompiler);
                continue;
            }
            isOption = false;
        }
        return mapOptions;
    }

    private String[] generateMainMethod() {
        String[] result = new String[this.getSettings().size()];
        int index = 0;
        for (Settings setting : Settings.values()) {
            result[index++] = String.format("-%s=%s", setting.getParam(), this.getSettings().isSelected(setting) ? "1" : "0");
        }
        return result;
    }

    public static enum Settings implements DecompilerSettings.Setting
    {
        HIDE_BRIDGE_METHODS("rbr", "Hide Bridge Methods", true),
        HIDE_SYNTHETIC_CLASS_MEMBERS("rsy", "Hide Synthetic Class Members"),
        DECOMPILE_INNER_CLASSES("din", "Decompile Inner Classes", true),
        COLLAPSE_14_CLASS_REFERENCES("dc4", "Collapse 1.4 Class References", true),
        DECOMPILE_ASSERTIONS("das", "Decompile Assertions", true),
        HIDE_EMPTY_SUPER_INVOCATION("hes", "Hide Empty Super Invocation", true),
        HIDE_EMPTY_DEFAULT_CONSTRUCTOR("hec", "Hide Empty Default Constructor", true),
        DECOMPILE_GENERIC_SIGNATURES("dgs", "Decompile Generic Signatures"),
        ASSUME_RETURN_NOT_THROWING_EXCEPTIONS("ner", "Assume return not throwing exceptions", true),
        DECOMPILE_ENUMS("den", "Decompile enumerations", true),
        REMOVE_GETCLASS("rgn", "Remove getClass()", true),
        OUTPUT_NUMBERIC_LITERALS("lit", "Output numeric literals 'as-is'"),
        ENCODE_UNICODE("asc", "Encode non-ASCII as unicode escapes"),
        INT_1_AS_BOOLEAN_TRUE("bto", "Assume int 1 is boolean true", true),
        ALLOW_NOT_SET_SYNTHETIC("nns", "Allow not set synthetic attribute", true),
        NAMELESS_TYPES_AS_OBJECT("uto", "Consider nameless types as java.lang.Object", true),
        RECOVER_VARIABLE_NAMES("udv", "Recover variable names", true),
        REMOVE_EMPTY_EXCEPTIONS("rer", "Remove empty exceptions", true),
        DEINLINE_FINALLY("fdi", "De-inline finally", true),
        RENAME_AMBIGIOUS_MEMBERS("ren", "Rename ambigious members"),
        REMOVE_INTELLIJ_NOTNULL("inn", "Remove IntelliJ @NotNull", true),
        DECOMPILE_LAMBDA_TO_ANONYMOUS("lac", "Decompile lambdas to anonymous classes");

        private String name;
        private String param;
        private boolean on;

        private Settings(String param, String name) {
            this(param, name, false);
        }

        private Settings(String param, String name, boolean on) {
            this.name = name;
            this.param = param;
            this.on = on;
        }

        @Override
        public String getText() {
            return this.name;
        }

        @Override
        public boolean isDefaultOn() {
            return this.on;
        }

        @Override
        public String getParam() {
            return this.param;
        }
    }
}

