/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.decompilers;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.tree.ClassNode;
import org.zeroturnaround.zip.ZipUtil;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.JarUtils;
import the.bytecode.club.bytecodeviewer.MiscUtils;
import the.bytecode.club.bytecodeviewer.Settings;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.decompilers.Decompiler;

public class KrakatauDecompiler
extends Decompiler {
    @Override
    public String getName() {
        return "Krakatau";
    }

    public String quick() {
        if (Settings.PATH.isEmpty()) {
            return "";
        }
        return ";" + Settings.PATH.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String decompileClassNode(ClassNode cn, byte[] b) {
        if (Settings.PYTHON2_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set your Python (or PyPy for speed) 2.7 executable path.");
            BytecodeViewer.viewer.pythonC();
        }
        if (Settings.RT_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set your JRE RT Library.\r\n(C:\\Program Files (x86)\\Java\\jre7\\lib\\rt.jar)");
            BytecodeViewer.viewer.rtC();
        }
        if (Settings.PYTHON2_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set Python!");
            return "Set your paths";
        }
        if (Settings.RT_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set RT.jar!");
            return "Set your paths";
        }
        String s = "Bytecode Viewer Version: 3.0.0" + BytecodeViewer.nl + BytecodeViewer.nl + "Please send this to konloch@gmail.com. " + BytecodeViewer.nl + BytecodeViewer.nl;
        try {
            String line;
            Path outputJar = Files.createTempFile("kdeout", ".zip", new FileAttribute[0]);
            Path inputJar = Files.createTempFile("kdein", ".jar", new FileAttribute[0]);
            JarUtils.saveAsJarClassesOnly(BytecodeViewer.getLoadedBytes(), inputJar.toAbsolutePath().toString());
            BytecodeViewer.sm.stopBlocking();
            ProcessBuilder pb = new ProcessBuilder(Settings.PYTHON2_LOCATION.get(), "-O", BytecodeViewer.krakatauDirectory.getAbsolutePath() + BytecodeViewer.fs + "decompile.py", "-skip", "-nauto", "-path", Settings.RT_LOCATION.get() + ";" + inputJar.toAbsolutePath().toString() + this.quick(), "-out", outputJar.toAbsolutePath().toString(), cn.name + ".class");
            Process process = pb.start();
            BytecodeViewer.createdProcesses.add(process);
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String log = "Process:" + BytecodeViewer.nl + BytecodeViewer.nl;
            while ((line = br.readLine()) != null) {
                log = log + BytecodeViewer.nl + line;
            }
            br.close();
            log = log + BytecodeViewer.nl + BytecodeViewer.nl + "Error:" + BytecodeViewer.nl + BytecodeViewer.nl;
            is = process.getErrorStream();
            isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                log = log + BytecodeViewer.nl + line;
            }
            br.close();
            int exitValue = process.waitFor();
            s = log = log + BytecodeViewer.nl + BytecodeViewer.nl + "Exit Value is " + exitValue;
            ZipFile zipFile = new ZipFile(outputJar.toFile());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] data = null;
            while (entries.hasMoreElements()) {
                ZipEntry next = entries.nextElement();
                if (!next.getName().equals(cn.name + ".java")) continue;
                data = IOUtils.toByteArray((InputStream)zipFile.getInputStream(next));
            }
            zipFile.close();
            Files.delete(inputJar);
            Files.delete(outputJar);
            String string = new String(data, "UTF-8");
            return string;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            e.printStackTrace();
            s = s + BytecodeViewer.nl + "Bytecode Viewer Version: " + "3.0.0" + BytecodeViewer.nl + BytecodeViewer.nl + sw.toString();
        }
        finally {
            BytecodeViewer.sm.setBlocking();
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompileToZip(String zipName) {
        if (Settings.PYTHON2_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set your Python (or PyPy for speed) 2.7 executable path.");
            BytecodeViewer.viewer.pythonC();
        }
        if (Settings.RT_LOCATION.isEmpty()) {
            BytecodeViewer.showMessage("You need to set your JRE RT Library.\r\n(C:\\Program Files (x86)\\Java\\jre7\\lib\\rt.jar)");
            BytecodeViewer.viewer.rtC();
        }
        try {
            File tempDir = Files.createTempDirectory("krakatauoutput", new FileAttribute[0]).toFile();
            File tempJar = new File(tempDir, "temp.jar");
            JarUtils.saveAsJarClassesOnly(BytecodeViewer.getLoadedBytes(), tempJar.getAbsolutePath());
            BytecodeViewer.sm.stopBlocking();
            ProcessBuilder pb = new ProcessBuilder(Settings.PYTHON2_LOCATION.get(), "-O", BytecodeViewer.krakatauDirectory.getAbsolutePath() + BytecodeViewer.fs + "decompile.py", "-skip", "-nauto", "-path", Settings.RT_LOCATION.get() + ";" + tempJar.getAbsolutePath(), "-out", tempDir.getAbsolutePath(), tempJar.getAbsolutePath());
            Process process = pb.start();
            BytecodeViewer.createdProcesses.add(process);
            MiscUtils.printProcess(process);
            process.waitFor();
            tempJar.delete();
            ZipUtil.pack((File)tempDir, (File)new File(zipName));
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
        finally {
            BytecodeViewer.sm.setBlocking();
        }
    }
}

