/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.gui;

import com.jhe.hexed.JHexEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.imgscalr.Scalr;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.Resources;
import the.bytecode.club.bytecodeviewer.api.ExceptionUI;
import the.bytecode.club.bytecodeviewer.gui.Viewer;

public class FileViewer
extends Viewer {
    private static final long serialVersionUID = 6103372882168257164L;
    private byte[] contents;
    RSyntaxTextArea panelArea = new RSyntaxTextArea();
    JPanel panel = new JPanel(new BorderLayout());
    JPanel panel2 = new JPanel(new BorderLayout());
    public JCheckBox check = new JCheckBox("Exact");
    final JTextField field = new JTextField();
    public BufferedImage image;
    boolean canRefresh = false;
    static CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
    private DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 62, 150));

    public void setContents() {
        String name = this.name.toLowerCase();
        this.panelArea.setCodeFoldingEnabled(true);
        this.panelArea.setAntiAliasingEnabled(true);
        RTextScrollPane scrollPane = new RTextScrollPane((Component)this.panelArea);
        this.panelArea.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 70 && (e.getModifiers() & 2) != 0) {
                    FileViewer.this.field.requestFocus();
                }
                BytecodeViewer.checkHotKey(e);
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        String contentsS = new String(this.contents);
        if (!FileViewer.isPureAscii(contentsS)) {
            if (name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".gif") || name.endsWith(".tif") || name.endsWith(".bmp")) {
                this.canRefresh = true;
                try {
                    this.image = ImageIO.read(new ByteArrayInputStream(this.contents));
                    JLabel label = new JLabel("", new ImageIcon(this.image), 0);
                    this.panel2.add((Component)label, "Center");
                    this.panel2.addMouseWheelListener(new MouseWheelListener(){

                        @Override
                        public void mouseWheelMoved(MouseWheelEvent e) {
                            int notches = e.getWheelRotation();
                            FileViewer.this.image = notches < 0 ? Scalr.resize(FileViewer.this.image, Scalr.Method.SPEED, FileViewer.this.image.getWidth() + 10, FileViewer.this.image.getHeight() + 10, new BufferedImageOp[0]) : Scalr.resize(FileViewer.this.image, Scalr.Method.SPEED, FileViewer.this.image.getWidth() - 10, FileViewer.this.image.getHeight() - 10, new BufferedImageOp[0]);
                            FileViewer.this.panel2.removeAll();
                            JLabel label = new JLabel("", new ImageIcon(FileViewer.this.image), 0);
                            FileViewer.this.panel2.add((Component)label, "Center");
                            FileViewer.this.panel2.updateUI();
                        }
                    });
                    return;
                }
                catch (Exception e) {
                    new ExceptionUI(e);
                }
            } else {
                JHexEditor hex = new JHexEditor(this.contents);
                this.panel2.add(hex);
                return;
            }
        }
        if (name.endsWith(".xml") || contentsS.startsWith("<?xml") || contentsS.startsWith("<xml")) {
            this.panelArea.setSyntaxEditingStyle("text/xml");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".py") || name.endsWith(".python")) {
            this.panelArea.setSyntaxEditingStyle("text/python");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".rb") || name.endsWith(".ruby")) {
            this.panelArea.setSyntaxEditingStyle("text/ruby");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".java")) {
            this.panelArea.setSyntaxEditingStyle("text/java");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".html")) {
            this.panelArea.setSyntaxEditingStyle("text/html");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".css")) {
            this.panelArea.setSyntaxEditingStyle("text/css");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".properties") || name.endsWith(".mf") || name.endsWith(".sf")) {
            this.panelArea.setSyntaxEditingStyle("text/properties");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".php") || contentsS.startsWith("<?php")) {
            this.panelArea.setSyntaxEditingStyle("text/php");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".js")) {
            this.panelArea.setSyntaxEditingStyle("text/javascript");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".bat")) {
            this.panelArea.setSyntaxEditingStyle("text/bat");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".sh")) {
            this.panelArea.setSyntaxEditingStyle("text/unix");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".c")) {
            this.panelArea.setSyntaxEditingStyle("text/c");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".cpp")) {
            this.panelArea.setSyntaxEditingStyle("text/cpp");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".scala")) {
            this.panelArea.setSyntaxEditingStyle("text/scala");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".clojure")) {
            this.panelArea.setSyntaxEditingStyle("text/clojure");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".groovy")) {
            this.panelArea.setSyntaxEditingStyle("text/groovy");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".lua")) {
            this.panelArea.setSyntaxEditingStyle("text/lua");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".sql")) {
            this.panelArea.setSyntaxEditingStyle("text/sql");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".json")) {
            this.panelArea.setSyntaxEditingStyle("text/json");
            this.panelArea.setText(contentsS);
        } else if (name.endsWith(".jsp")) {
            this.panelArea.setSyntaxEditingStyle("text/jsp");
            this.panelArea.setText(contentsS);
        } else {
            this.panelArea.setSyntaxEditingStyle("text/plain");
            this.panelArea.setText(contentsS);
        }
        this.panelArea.setCaretPosition(0);
        scrollPane.setColumnHeaderView((Component)this.panel);
        this.panel2.add((Component)scrollPane);
    }

    public static boolean isPureAscii(String v) {
        return asciiEncoder.canEncode(v);
    }

    public FileViewer(String name, String container, byte[] contents) {
        this.name = name;
        this.container = container;
        this.contents = contents;
        this.updateName();
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel2, "Center");
        JButton searchNext = new JButton();
        JButton searchPrev = new JButton();
        JPanel buttonPane = new JPanel(new BorderLayout());
        buttonPane.add((Component)searchNext, "West");
        buttonPane.add((Component)searchPrev, "East");
        searchNext.setIcon(Resources.nextIcon);
        searchPrev.setIcon(Resources.prevIcon);
        this.panel.add((Component)buttonPane, "West");
        this.panel.add((Component)this.field, "Center");
        this.panel.add((Component)this.check, "East");
        searchNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileViewer.this.search(FileViewer.this.field.getText(), true);
            }
        });
        searchPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileViewer.this.search(FileViewer.this.field.getText(), false);
            }
        });
        this.field.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 10) {
                    FileViewer.this.search(FileViewer.this.field.getText(), true);
                }
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.setContents();
    }

    public void search(String search, boolean next) {
        try {
            RSyntaxTextArea area = this.panelArea;
            if (search.isEmpty()) {
                this.highlight((JTextComponent)area, "");
                return;
            }
            int startLine = area.getDocument().getDefaultRootElement().getElementIndex(area.getCaretPosition()) + 1;
            int currentLine = 1;
            boolean canSearch = false;
            String[] test = null;
            test = area.getText().split("\n").length >= 2 ? area.getText().split("\n") : area.getText().split("\r");
            int lastGoodLine = -1;
            int firstPos = -1;
            boolean found = false;
            if (next) {
                for (String s : test) {
                    if (!this.check.isSelected()) {
                        s = s.toLowerCase();
                        search = search.toLowerCase();
                    }
                    if (currentLine == startLine) {
                        canSearch = true;
                    } else if (s.contains(search)) {
                        if (canSearch) {
                            area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(currentLine - 1).getStartOffset());
                            canSearch = false;
                            found = true;
                        }
                        if (firstPos == -1) {
                            firstPos = currentLine;
                        }
                    }
                    ++currentLine;
                }
                if (!found && firstPos != -1) {
                    area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(firstPos - 1).getStartOffset());
                }
            } else {
                canSearch = true;
                for (String s : test) {
                    if (!this.check.isSelected()) {
                        s = s.toLowerCase();
                        search = search.toLowerCase();
                    }
                    if (s.contains(search)) {
                        if (lastGoodLine != -1 && canSearch) {
                            area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(lastGoodLine - 1).getStartOffset());
                        }
                        lastGoodLine = currentLine;
                        if (currentLine >= startLine) {
                            canSearch = false;
                        }
                    }
                    ++currentLine;
                }
                if (lastGoodLine != -1 && area.getDocument().getDefaultRootElement().getElementIndex(area.getCaretPosition()) + 1 == startLine) {
                    area.setCaretPosition(area.getDocument().getDefaultRootElement().getElement(lastGoodLine - 1).getStartOffset());
                }
            }
            this.highlight((JTextComponent)area, search);
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
    }

    public void highlight(JTextComponent textComp, String pattern) {
        if (pattern.isEmpty()) {
            textComp.getHighlighter().removeAllHighlights();
            return;
        }
        try {
            Highlighter hilite = textComp.getHighlighter();
            hilite.removeAllHighlights();
            Document doc = textComp.getDocument();
            String text = doc.getText(0, doc.getLength());
            int pos = 0;
            if (!this.check.isSelected()) {
                pattern = pattern.toLowerCase();
                text = text.toLowerCase();
            }
            while ((pos = text.indexOf(pattern, pos)) >= 0) {
                hilite.addHighlight(pos, pos + pattern.length(), this.painter);
                pos += pattern.length();
            }
        }
        catch (Exception e) {
            new ExceptionUI(e);
        }
    }

    public void refresh(JButton src) {
        if (!this.canRefresh) {
            src.setEnabled(true);
            return;
        }
        this.panel2.removeAll();
        try {
            this.image = ImageIO.read(new ByteArrayInputStream(this.contents));
        }
        catch (IOException e) {
            new ExceptionUI(e);
        }
        JLabel label = new JLabel("", new ImageIcon(this.image), 0);
        this.panel2.add((Component)label, "Center");
        this.panel2.updateUI();
        src.setEnabled(true);
    }
}

