/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.plugin;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import the.bytecode.club.bytecodeviewer.BytecodeViewer;
import the.bytecode.club.bytecodeviewer.MiscUtils;
import the.bytecode.club.bytecodeviewer.api.Plugin;
import the.bytecode.club.bytecodeviewer.plugin.PluginLaunchStrategy;
import the.bytecode.club.bytecodeviewer.plugin.strategies.CompiledJavaPluginLaunchStrategy;
import the.bytecode.club.bytecodeviewer.plugin.strategies.GroovyPluginLaunchStrategy;
import the.bytecode.club.bytecodeviewer.plugin.strategies.JavaPluginLaunchStrategy;
import the.bytecode.club.bytecodeviewer.plugin.strategies.PythonPluginLaunchStrategy;
import the.bytecode.club.bytecodeviewer.plugin.strategies.RubyPluginLaunchStrategy;

public final class PluginManager {
    private static final Map<String, PluginLaunchStrategy> launchStrategies = new HashMap<String, PluginLaunchStrategy>();
    private static final PluginFileFilter filter = new PluginFileFilter();
    private static Plugin pluginInstance;

    private PluginManager() {
    }

    public static void runPlugin(Plugin newPluginInstance) {
        if (pluginInstance == null || pluginInstance.isFinished()) {
            pluginInstance = newPluginInstance;
            pluginInstance.start();
        } else if (!pluginInstance.isFinished()) {
            BytecodeViewer.showMessage("There is currently another plugin running right now, please wait for that to finish executing.");
        }
    }

    public static void runPlugin(File f) throws Throwable {
        String ext = f.getName().substring(f.getName().lastIndexOf(46) + 1);
        PluginLaunchStrategy strategy = launchStrategies.get(ext);
        if (strategy == null) {
            throw new RuntimeException(String.format("No launch strategy for extension %s (%s)", ext, f.getAbsolutePath()));
        }
        Plugin p = strategy.run(f);
        if (p != null) {
            PluginManager.runPlugin(p);
        }
    }

    public static void register(String name, PluginLaunchStrategy strat) {
        launchStrategies.put(name, strat);
    }

    public static Set<String> pluginExtensions() {
        return launchStrategies.keySet();
    }

    public static FileFilter fileFilter() {
        return filter;
    }

    static {
        launchStrategies.put("jar", new CompiledJavaPluginLaunchStrategy());
        launchStrategies.put("java", new JavaPluginLaunchStrategy());
        GroovyPluginLaunchStrategy groovy = new GroovyPluginLaunchStrategy();
        launchStrategies.put("gy", groovy);
        launchStrategies.put("groovy", groovy);
        PythonPluginLaunchStrategy python = new PythonPluginLaunchStrategy();
        launchStrategies.put("py", python);
        launchStrategies.put("python", python);
        RubyPluginLaunchStrategy ruby = new RubyPluginLaunchStrategy();
        launchStrategies.put("rb", ruby);
        launchStrategies.put("ruby", ruby);
    }

    public static class PluginFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return PluginManager.pluginExtensions().contains(MiscUtils.extension(f.getAbsolutePath()));
        }

        @Override
        public String getDescription() {
            return "BCV Plugins";
        }
    }
}

