/*
 * Decompiled with CFR 0.152.
 */
package the.bytecode.club.bytecodeviewer.searching;

import java.awt.GridLayout;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import the.bytecode.club.bytecodeviewer.searching.RegexInsnFinder;
import the.bytecode.club.bytecodeviewer.searching.SearchResultNotifier;
import the.bytecode.club.bytecodeviewer.searching.SearchTypeDetails;

public class RegexSearch
implements SearchTypeDetails {
    public static JTextField searchText = new JTextField("");
    JPanel myPanel = null;
    private static RegexInsnFinder regexFinder;

    @Override
    public JPanel getPanel() {
        if (this.myPanel == null) {
            this.myPanel = new JPanel(new GridLayout(1, 2));
            this.myPanel.add(new JLabel("Search Regex: "));
            this.myPanel.add(searchText);
        }
        return this.myPanel;
    }

    @Override
    public void search(ClassNode node, SearchResultNotifier srn, boolean exact) {
        Iterator<MethodNode> methods = node.methods.iterator();
        String srchText = searchText.getText();
        if (srchText.isEmpty()) {
            return;
        }
        while (methods.hasNext()) {
            MethodNode method = methods.next();
            if (regexFinder == null) {
                regexFinder = new RegexInsnFinder(node, method);
            } else {
                regexFinder.setMethod(node, method);
            }
            if (regexFinder.find(srchText).length <= 0) continue;
            String desc2 = method.desc;
            try {
                desc2 = Type.getType(method.desc).toString();
                if (desc2 == null || desc2.equals("null")) {
                    desc2 = method.desc;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            srn.notifyOfResult(node.name + "." + method.name + desc2);
        }
    }
}

