/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.reader;

import com.mxgraph.canvas.mxICanvas2D;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxDomOutputParser {
    protected mxICanvas2D canvas;
    protected transient Map<String, IElementHandler> handlers = new Hashtable<String, IElementHandler>();

    public mxDomOutputParser(mxICanvas2D mxICanvas2D2) {
        this.canvas = mxICanvas2D2;
        this.initHandlers();
    }

    public void read(Node node) {
        while (node != null) {
            Element element;
            IElementHandler iElementHandler;
            if (node instanceof Element && (iElementHandler = this.handlers.get((element = (Element)node).getNodeName())) != null) {
                iElementHandler.parseElement(element);
            }
            node = node.getNextSibling();
        }
    }

    protected void initHandlers() {
        this.handlers.put("save", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.save();
            }
        });
        this.handlers.put("restore", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.restore();
            }
        });
        this.handlers.put("scale", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.scale(Double.parseDouble(element.getAttribute("scale")));
            }
        });
        this.handlers.put("translate", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.translate(Double.parseDouble(element.getAttribute("dx")), Double.parseDouble(element.getAttribute("dy")));
            }
        });
        this.handlers.put("rotate", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.rotate(Double.parseDouble(element.getAttribute("theta")), element.getAttribute("flipH").equals("1"), element.getAttribute("flipV").equals("1"), Double.parseDouble(element.getAttribute("cx")), Double.parseDouble(element.getAttribute("cy")));
            }
        });
        this.handlers.put("strokewidth", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setStrokeWidth(Double.parseDouble(element.getAttribute("width")));
            }
        });
        this.handlers.put("strokecolor", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setStrokeColor(element.getAttribute("color"));
            }
        });
        this.handlers.put("dashed", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setDashed(element.getAttribute("dashed").equals("1"));
            }
        });
        this.handlers.put("dashpattern", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setDashPattern(element.getAttribute("pattern"));
            }
        });
        this.handlers.put("linecap", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setLineCap(element.getAttribute("cap"));
            }
        });
        this.handlers.put("linejoin", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setLineJoin(element.getAttribute("join"));
            }
        });
        this.handlers.put("miterlimit", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setMiterLimit(Double.parseDouble(element.getAttribute("limit")));
            }
        });
        this.handlers.put("fontsize", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setFontSize(Double.parseDouble(element.getAttribute("size")));
            }
        });
        this.handlers.put("fontcolor", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setFontColor(element.getAttribute("color"));
            }
        });
        this.handlers.put("fontbackgroundcolor", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setFontBackgroundColor(element.getAttribute("color"));
            }
        });
        this.handlers.put("fontbordercolor", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setFontBorderColor(element.getAttribute("color"));
            }
        });
        this.handlers.put("fontfamily", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setFontFamily(element.getAttribute("family"));
            }
        });
        this.handlers.put("fontstyle", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setFontStyle(Integer.parseInt(element.getAttribute("style")));
            }
        });
        this.handlers.put("alpha", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setAlpha(Double.parseDouble(element.getAttribute("alpha")));
            }
        });
        this.handlers.put("fillcolor", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setFillColor(element.getAttribute("color"));
            }
        });
        this.handlers.put("shadowcolor", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setShadowColor(element.getAttribute("color"));
            }
        });
        this.handlers.put("shadowalpha", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setShadowAlpha(Double.parseDouble(element.getAttribute("alpha")));
            }
        });
        this.handlers.put("shadowoffset", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setShadowOffset(Double.parseDouble(element.getAttribute("dx")), Double.parseDouble(element.getAttribute("dy")));
            }
        });
        this.handlers.put("shadow", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setShadow(element.getAttribute("enabled").equals("1"));
            }
        });
        this.handlers.put("gradient", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.setGradient(element.getAttribute("c1"), element.getAttribute("c2"), Double.parseDouble(element.getAttribute("x")), Double.parseDouble(element.getAttribute("y")), Double.parseDouble(element.getAttribute("w")), Double.parseDouble(element.getAttribute("h")), element.getAttribute("direction"), Double.parseDouble(mxDomOutputParser.this.getValue(element, "alpha1", "1")), Double.parseDouble(mxDomOutputParser.this.getValue(element, "alpha2", "1")));
            }
        });
        this.handlers.put("rect", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.rect(Double.parseDouble(element.getAttribute("x")), Double.parseDouble(element.getAttribute("y")), Double.parseDouble(element.getAttribute("w")), Double.parseDouble(element.getAttribute("h")));
            }
        });
        this.handlers.put("roundrect", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.roundrect(Double.parseDouble(element.getAttribute("x")), Double.parseDouble(element.getAttribute("y")), Double.parseDouble(element.getAttribute("w")), Double.parseDouble(element.getAttribute("h")), Double.parseDouble(element.getAttribute("dx")), Double.parseDouble(element.getAttribute("dy")));
            }
        });
        this.handlers.put("ellipse", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.ellipse(Double.parseDouble(element.getAttribute("x")), Double.parseDouble(element.getAttribute("y")), Double.parseDouble(element.getAttribute("w")), Double.parseDouble(element.getAttribute("h")));
            }
        });
        this.handlers.put("image", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.image(Double.parseDouble(element.getAttribute("x")), Double.parseDouble(element.getAttribute("y")), Double.parseDouble(element.getAttribute("w")), Double.parseDouble(element.getAttribute("h")), element.getAttribute("src"), element.getAttribute("aspect").equals("1"), element.getAttribute("flipH").equals("1"), element.getAttribute("flipV").equals("1"));
            }
        });
        this.handlers.put("text", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.text(Double.parseDouble(element.getAttribute("x")), Double.parseDouble(element.getAttribute("y")), Double.parseDouble(element.getAttribute("w")), Double.parseDouble(element.getAttribute("h")), element.getAttribute("str"), element.getAttribute("align"), element.getAttribute("valign"), mxDomOutputParser.this.getValue(element, "wrap", "").equals("1"), element.getAttribute("format"), element.getAttribute("overflow"), mxDomOutputParser.this.getValue(element, "clip", "").equals("1"), Double.parseDouble(mxDomOutputParser.this.getValue(element, "rotation", "0")));
            }
        });
        this.handlers.put("begin", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.begin();
            }
        });
        this.handlers.put("move", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.moveTo(Double.parseDouble(element.getAttribute("x")), Double.parseDouble(element.getAttribute("y")));
            }
        });
        this.handlers.put("line", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.lineTo(Double.parseDouble(element.getAttribute("x")), Double.parseDouble(element.getAttribute("y")));
            }
        });
        this.handlers.put("quad", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.quadTo(Double.parseDouble(element.getAttribute("x1")), Double.parseDouble(element.getAttribute("y1")), Double.parseDouble(element.getAttribute("x2")), Double.parseDouble(element.getAttribute("y2")));
            }
        });
        this.handlers.put("curve", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.curveTo(Double.parseDouble(element.getAttribute("x1")), Double.parseDouble(element.getAttribute("y1")), Double.parseDouble(element.getAttribute("x2")), Double.parseDouble(element.getAttribute("y2")), Double.parseDouble(element.getAttribute("x3")), Double.parseDouble(element.getAttribute("y3")));
            }
        });
        this.handlers.put("close", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.close();
            }
        });
        this.handlers.put("stroke", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.stroke();
            }
        });
        this.handlers.put("fill", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.fill();
            }
        });
        this.handlers.put("fillstroke", new IElementHandler(){

            @Override
            public void parseElement(Element element) {
                mxDomOutputParser.this.canvas.fillAndStroke();
            }
        });
    }

    protected String getValue(Element element, String string, String string2) {
        String string3 = element.getAttribute(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    protected static interface IElementHandler {
        public void parseElement(Element var1);
    }
}

