/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.asm.desc;

import eu.bibl.banalysis.filter.InstructionFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class OpcodeInfo
implements Opcodes {
    public static final HashMap<Integer, String> OPCODES = new HashMap();
    public static final HashMap<String, Integer> OPCODE_NAMES = new HashMap();
    public static final int TYPE_LOAD = 1;
    public static final int TYPE_RETURN = 2;

    public static final int[] toOpcodes(String opcodeString) {
        String[] stringOpcodes = opcodeString.split(" ");
        int[] opcodes = new int[stringOpcodes.length];
        for (int i = 0; i < stringOpcodes.length; ++i) {
            opcodes[i] = OPCODE_NAMES.get(stringOpcodes[i]);
        }
        return opcodes;
    }

    public static final String opcodesToString(AbstractInsnNode[] ains) {
        Object[] ops = new String[ains.length];
        for (int i = 0; i < ains.length; ++i) {
            ops[i] = OPCODES.get(ains[i].getOpcode());
        }
        return Arrays.toString(ops).replace("[", "").replace("]", "");
    }

    public static int getReturnOpcode(String typeDesc) {
        return OpcodeInfo.getOpcode(typeDesc, 2);
    }

    public static int getLoadOpcode(String typeDesc) {
        return OpcodeInfo.getOpcode(typeDesc, 1);
    }

    public static int getOpcode(String typeDesc, int opcodeType) {
        if (opcodeType != 1 && opcodeType != 2) {
            return -1;
        }
        char c = typeDesc.charAt(0);
        switch (c) {
            case 'F': {
                return opcodeType == 1 ? 23 : (opcodeType == 2 ? 174 : -1);
            }
            case 'D': {
                return opcodeType == 1 ? 24 : (opcodeType == 2 ? 175 : -1);
            }
            case 'J': {
                return opcodeType == 1 ? 22 : (opcodeType == 2 ? 173 : -1);
            }
            case 'B': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return opcodeType == 1 ? 21 : (opcodeType == 2 ? 172 : -1);
            }
        }
        return opcodeType == 1 ? 25 : (opcodeType == 2 ? 176 : -1);
    }

    public static AbstractInsnNode[] getInstructions(MethodNode m) {
        return OpcodeInfo.getInstructions(m, InstructionFilter.ACCEPT_ALL);
    }

    public static AbstractInsnNode[] getInstructions(MethodNode m, InstructionFilter filter) {
        ArrayList<AbstractInsnNode> insns = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode ain : m.instructions) {
            if (!filter.accept(ain)) continue;
            insns.add(ain);
        }
        return insns.toArray(new AbstractInsnNode[insns.size()]);
    }

    static {
        try {
            ClassReader cr = new ClassReader("org.objectweb.asm.Opcodes");
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 6);
            ListIterator fnIt = cn.fields.listIterator();
            while (fnIt.hasNext()) {
                Object fO = fnIt.next();
                FieldNode f = (FieldNode)fO;
                try {
                    OPCODES.put((Integer)f.value, f.name);
                    OPCODE_NAMES.put(f.name, (Integer)f.value);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

