/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.asm.insn;

import eu.bibl.banalysis.asm.insn.InstructionPattern;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LineNumberNode;

public class InstructionSearcher
implements Opcodes {
    protected InsnList insns;
    protected InstructionPattern pattern;
    protected List<AbstractInsnNode[]> matches;

    public InstructionSearcher(InsnList insns, int[] opcodes) {
        this(insns, new InstructionPattern(opcodes));
    }

    public InstructionSearcher(InsnList insns, AbstractInsnNode[] ains) {
        this(insns, new InstructionPattern(ains));
    }

    public InstructionSearcher(InsnList insns, InstructionPattern pattern) {
        this.insns = insns;
        this.pattern = pattern;
        this.matches = new ArrayList<AbstractInsnNode[]>();
    }

    public boolean search() {
        for (AbstractInsnNode ain : this.insns.toArray()) {
            if (ain instanceof LineNumberNode || ain instanceof FrameNode || !this.pattern.accept(ain)) continue;
            this.matches.add(this.pattern.getLastMatch());
            this.pattern.resetMatch();
        }
        return this.size() != 0;
    }

    public List<AbstractInsnNode[]> getMatches() {
        return this.matches;
    }

    public int size() {
        return this.matches.size();
    }
}

