/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceGetStaticVisitor {
    private int index;
    private Instruction newInstruction;
    private Instruction parentFound;

    public ReplaceGetStaticVisitor(int index, Instruction newInstruction) {
        this.index = index;
        this.newInstruction = newInstruction;
        this.parentFound = null;
    }

    public void visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                if (this.match(al, al.arrayref)) {
                    al.arrayref = this.newInstruction;
                    break;
                }
                this.visit(al.arrayref);
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                if (this.match(asi, asi.arrayref)) {
                    asi.arrayref = this.newInstruction;
                    break;
                }
                this.visit(asi.arrayref);
                if (this.parentFound != null) break;
                if (this.match(asi, asi.indexref)) {
                    asi.indexref = this.newInstruction;
                    break;
                }
                this.visit(asi.indexref);
                if (this.parentFound != null) break;
                if (this.match(asi, asi.valueref)) {
                    asi.valueref = this.newInstruction;
                    break;
                }
                this.visit(asi.valueref);
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                if (this.match(ai, ai.test)) {
                    ai.test = this.newInstruction;
                    break;
                }
                this.visit(ai.test);
                if (this.parentFound != null || ai.msg == null) break;
                if (this.match(ai, ai.msg)) {
                    ai.msg = this.newInstruction;
                    break;
                }
                this.visit(ai.msg);
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                if (this.match(aThrow, aThrow.value)) {
                    aThrow.value = this.newInstruction;
                    break;
                }
                this.visit(aThrow.value);
                break;
            }
            case 266: {
                UnaryOperatorInstruction uoi = (UnaryOperatorInstruction)instruction;
                if (this.match(uoi, uoi.value)) {
                    uoi.value = this.newInstruction;
                    break;
                }
                this.visit(uoi.value);
                break;
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                if (this.match(boi, boi.value1)) {
                    boi.value1 = this.newInstruction;
                    break;
                }
                this.visit(boi.value1);
                if (this.parentFound != null) break;
                if (this.match(boi, boi.value2)) {
                    boi.value2 = this.newInstruction;
                    break;
                }
                this.visit(boi.value2);
                break;
            }
            case 192: {
                CheckCast checkCast = (CheckCast)instruction;
                if (this.match(checkCast, checkCast.objectref)) {
                    checkCast.objectref = this.newInstruction;
                    break;
                }
                this.visit(checkCast.objectref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                StoreInstruction storeInstruction = (StoreInstruction)instruction;
                if (this.match(storeInstruction, storeInstruction.valueref)) {
                    storeInstruction.valueref = this.newInstruction;
                    break;
                }
                this.visit(storeInstruction.valueref);
                break;
            }
            case 264: {
                DupStore dupStore = (DupStore)instruction;
                if (this.match(dupStore, dupStore.objectref)) {
                    dupStore.objectref = this.newInstruction;
                    break;
                }
                this.visit(dupStore.objectref);
                break;
            }
            case 275: 
            case 276: {
                ConvertInstruction ci = (ConvertInstruction)instruction;
                if (this.match(ci, ci.value)) {
                    ci.value = this.newInstruction;
                    break;
                }
                this.visit(ci.value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                if (this.match(ifCmp, ifCmp.value1)) {
                    ifCmp.value1 = this.newInstruction;
                    break;
                }
                this.visit(ifCmp.value1);
                if (this.parentFound != null) break;
                if (this.match(ifCmp, ifCmp.value2)) {
                    ifCmp.value2 = this.newInstruction;
                    break;
                }
                this.visit(ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                IfInstruction iff = (IfInstruction)instruction;
                if (this.match(iff, iff.value)) {
                    iff.value = this.newInstruction;
                    break;
                }
                this.visit(iff.value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0 && this.parentFound == null) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                InstanceOf instanceOf = (InstanceOf)instruction;
                if (this.match(instanceOf, instanceOf.objectref)) {
                    instanceOf.objectref = this.newInstruction;
                    break;
                }
                this.visit(instanceOf.objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                if (this.match(insi, insi.objectref)) {
                    insi.objectref = this.newInstruction;
                } else {
                    this.visit(insi.objectref);
                }
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0 && this.parentFound == null) {
                    if (this.match(instruction, list.get(i))) {
                        list.set(i, this.newInstruction);
                    } else {
                        this.visit(list.get(i));
                    }
                    --i;
                }
                break;
            }
            case 171: {
                LookupSwitch ls = (LookupSwitch)instruction;
                if (this.match(ls, ls.key)) {
                    ls.key = this.newInstruction;
                    break;
                }
                this.visit(ls.key);
                break;
            }
            case 194: {
                MonitorEnter monitorEnter = (MonitorEnter)instruction;
                if (this.match(monitorEnter, monitorEnter.objectref)) {
                    monitorEnter.objectref = this.newInstruction;
                    break;
                }
                this.visit(monitorEnter.objectref);
                break;
            }
            case 195: {
                MonitorExit monitorExit = (MonitorExit)instruction;
                if (this.match(monitorExit, monitorExit.objectref)) {
                    monitorExit.objectref = this.newInstruction;
                    break;
                }
                this.visit(monitorExit.objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0 && this.parentFound == null) {
                    if (this.match(instruction, dimensions[i])) {
                        dimensions[i] = this.newInstruction;
                    } else {
                        this.visit(dimensions[i]);
                    }
                    --i;
                }
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                if (this.match(newArray, newArray.dimension)) {
                    newArray.dimension = this.newInstruction;
                    break;
                }
                this.visit(newArray.dimension);
                break;
            }
            case 189: {
                ANewArray aNewArray = (ANewArray)instruction;
                if (this.match(aNewArray, aNewArray.dimension)) {
                    aNewArray.dimension = this.newInstruction;
                    break;
                }
                this.visit(aNewArray.dimension);
                break;
            }
            case 87: {
                Pop pop = (Pop)instruction;
                if (this.match(pop, pop.objectref)) {
                    pop.objectref = this.newInstruction;
                    break;
                }
                this.visit(pop.objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                if (this.match(putField, putField.objectref)) {
                    putField.objectref = this.newInstruction;
                    break;
                }
                this.visit(putField.objectref);
                if (this.parentFound != null) break;
                if (this.match(putField, putField.valueref)) {
                    putField.valueref = this.newInstruction;
                    break;
                }
                this.visit(putField.valueref);
                break;
            }
            case 179: {
                PutStatic putStatic = (PutStatic)instruction;
                if (this.match(putStatic, putStatic.valueref)) {
                    putStatic.valueref = this.newInstruction;
                    break;
                }
                this.visit(putStatic.valueref);
                break;
            }
            case 273: {
                ReturnInstruction ri = (ReturnInstruction)instruction;
                if (this.match(ri, ri.valueref)) {
                    ri.valueref = this.newInstruction;
                    break;
                }
                this.visit(ri.valueref);
                break;
            }
            case 170: {
                TableSwitch ts = (TableSwitch)instruction;
                if (this.match(ts, ts.key)) {
                    ts.key = this.newInstruction;
                    break;
                }
                this.visit(ts.key);
                break;
            }
            case 280: {
                TernaryOpStore tos = (TernaryOpStore)instruction;
                if (this.match(tos, tos.objectref)) {
                    tos.objectref = this.newInstruction;
                    break;
                }
                this.visit(tos.objectref);
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                if (this.match(to, to.test)) {
                    to.test = this.newInstruction;
                    break;
                }
                this.visit(to.test);
                if (this.parentFound != null) break;
                if (this.match(to, to.value1)) {
                    to.value1 = this.newInstruction;
                    break;
                }
                this.visit(to.value1);
                if (this.parentFound != null) break;
                if (this.match(to, to.value2)) {
                    to.value2 = this.newInstruction;
                    break;
                }
                this.visit(to.value2);
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                if (this.match(ai, ai.value1)) {
                    ai.value1 = this.newInstruction;
                    break;
                }
                this.visit(ai.value1);
                if (this.parentFound != null) break;
                if (this.match(ai, ai.value2)) {
                    ai.value2 = this.newInstruction;
                    break;
                }
                this.visit(ai.value2);
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                if (this.match(ali, ali.arrayref)) {
                    ali.arrayref = this.newInstruction;
                    break;
                }
                this.visit(ali.arrayref);
                if (this.parentFound != null) break;
                if (this.match(ali, ali.indexref)) {
                    ali.indexref = this.newInstruction;
                    break;
                }
                this.visit(ali.indexref);
                break;
            }
            case 277: 
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                if (this.match(ii, ii.value)) {
                    ii.value = this.newInstruction;
                    break;
                }
                this.visit(ii.value);
                break;
            }
            case 180: {
                GetField gf = (GetField)instruction;
                if (this.match(gf, gf.objectref)) {
                    gf.objectref = this.newInstruction;
                    break;
                }
                this.visit(gf.objectref);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                if (this.match(iai, iai.newArray)) {
                    iai.newArray = this.newInstruction;
                    break;
                }
                this.visit(iai.newArray);
                if (this.parentFound != null || iai.values == null) break;
                this.visit(iai.values);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 279: {
                break;
            }
            default: {
                System.err.println("Can not replace DupLoad in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    private void visit(List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            this.visit(instructions.get(i));
            --i;
        }
    }

    public Instruction getParentFound() {
        return this.parentFound;
    }

    private boolean match(Instruction parent, Instruction i) {
        if (i.opcode == 178 && ((GetStatic)i).index == this.index) {
            this.parentFound = parent;
            return true;
        }
        return false;
    }
}

