/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.service.indexer;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import jd.gui.api.model.Container;
import jd.gui.spi.Indexer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class IndexerService
implements GroovyObject {
    protected List<Indexer> providers;
    protected Map<String, Indexers> mapProviders;
    private static volatile IndexerService instance;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private IndexerService() {
        MetaClass metaClass;
        List<Indexer> list = DefaultGroovyMethods.toList(ServiceLoader.load(Indexer.class));
        this.providers = list;
        Map<String, Indexers> map = this.populate(this.providers);
        this.mapProviders = map;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (instance != null) {
            throw (Throwable)new RuntimeException("Can't instantiate singleton jd.gui.service.indexer.IndexerService. Use jd.gui.service.indexer.IndexerService.instance");
        }
    }

    protected Map<String, Indexers> populate(List<Indexer> providers) {
        LinkedHashMap mapProviders = (LinkedHashMap)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createMap(new Object[0]), LinkedHashMap.class);
        Map mapProvidersWithDefault = DefaultGroovyMethods.withDefault(mapProviders, (Closure)((Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public Object doCall(Object it) {
                return new Indexers();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _populate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }));
        Indexer provider = null;
        Iterator<Indexer> iterator = providers.iterator();
        while (iterator.hasNext()) {
            provider = (Indexer)ScriptBytecodeAdapter.castToType(iterator.next(), Indexer.class);
            String type = null;
            Iterator iterator2 = DefaultGroovyMethods.iterator(provider.getTypes());
            while (iterator2.hasNext()) {
                type = ShortTypeHandling.castToString(iterator2.next());
                ((Indexers)DefaultGroovyMethods.getAt(mapProvidersWithDefault, type)).add(provider);
            }
        }
        return mapProviders;
    }

    public Indexer get(Container.Entry entry) {
        Indexer indexer = this.get(entry.getContainer().getType(), entry);
        Indexer indexer2 = indexer;
        return DefaultTypeTransformation.booleanUnbox(indexer2) ? indexer2 : this.get("*", entry);
    }

    public Indexer get(String containerType, Container.Entry entry) {
        String path = entry.getPath();
        String type = entry.isDirectory() ? "dir" : "file";
        String prefix = StringGroovyMethods.plus(StringGroovyMethods.plus(containerType, (CharSequence)":"), (CharSequence)type);
        Indexers indexers = this.mapProviders.get(StringGroovyMethods.plus(StringGroovyMethods.plus(prefix, (CharSequence)":"), (CharSequence)path));
        Indexer indexer = indexers != null ? indexers.match(path) : null;
        if (!DefaultTypeTransformation.booleanUnbox(indexer)) {
            Indexer indexer2;
            int lastSlashIndex = path.lastIndexOf("/");
            String name = path.substring(lastSlashIndex + 1);
            Indexers indexers2 = this.mapProviders.get(StringGroovyMethods.plus(StringGroovyMethods.plus(prefix, (CharSequence)":*/"), (CharSequence)name));
            indexer = indexer2 = indexers2 != null ? indexers2.match(path) : null;
            if (!DefaultTypeTransformation.booleanUnbox(indexer)) {
                int index = name.lastIndexOf(".");
                if (ScriptBytecodeAdapter.compareNotEqual(index, -1)) {
                    Indexer indexer3;
                    String extension = name.substring(index + 1);
                    Indexers indexers3 = this.mapProviders.get(StringGroovyMethods.plus(StringGroovyMethods.plus(prefix, (CharSequence)":*."), (CharSequence)extension));
                    indexer = indexer3 = indexers3 != null ? indexers3.match(path) : null;
                }
                if (!DefaultTypeTransformation.booleanUnbox(indexer)) {
                    Indexer indexer4;
                    Indexers indexers4 = this.mapProviders.get(StringGroovyMethods.plus(prefix, (CharSequence)":*"));
                    indexer = indexer4 = indexers4 != null ? indexers4.match(path) : null;
                }
            }
        }
        return indexer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IndexerService getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<IndexerService> clazz = IndexerService.class;
        synchronized (clazz) {
            if (instance != null) {
                return instance;
            }
            {
                IndexerService indexerService3;
                instance = indexerService3 = new IndexerService();
                return indexerService3;
            }
        }
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IndexerService.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, IndexerService.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(IndexerService.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IndexerService.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    public static class Indexers
    implements GroovyObject {
        private ArrayList<Indexer> indexers;
        private Indexer defaultIndexer;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public Indexers() {
            MetaClass metaClass;
            ArrayList arrayList = new ArrayList();
            this.indexers = arrayList;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void add(Indexer indexer) {
            if (indexer.getPathPattern() != null) {
                DefaultGroovyMethods.leftShift(this.indexers, indexer);
            } else {
                Indexer indexer2;
                this.defaultIndexer = indexer2 = indexer;
            }
        }

        public Indexer match(String path) {
            Indexer indexer = null;
            Iterator<Indexer> iterator = this.indexers.iterator();
            while (iterator.hasNext()) {
                indexer = (Indexer)ScriptBytecodeAdapter.castToType(iterator.next(), Indexer.class);
                if (!ScriptBytecodeAdapter.matchRegex(path, indexer.getPathPattern())) continue;
                return indexer;
            }
            return this.defaultIndexer;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Indexers.class, IndexerService.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, IndexerService.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Indexers.class, IndexerService.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Indexers.class) {
                return ScriptBytecodeAdapter.initMetaClass(this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Override
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Override
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Override
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Override
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty(this, string);
        }

        @Override
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty(this, string, object);
        }

        public ArrayList<Indexer> getIndexers() {
            return this.indexers;
        }

        public void setIndexers(ArrayList<Indexer> arrayList) {
            this.indexers = arrayList;
        }

        public Indexer getDefaultIndexer() {
            return this.defaultIndexer;
        }

        public void setDefaultIndexer(Indexer indexer) {
            this.defaultIndexer = indexer;
        }
    }
}

