/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.service.sourcesaver;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Pattern;
import jd.core.Decompiler;
import jd.core.process.DecompilerImpl;
import jd.gui.api.API;
import jd.gui.api.model.Container;
import jd.gui.spi.SourceSaver;
import jd.gui.util.decompiler.ContainerLoader;
import jd.gui.util.decompiler.GuiPreferences;
import jd.gui.util.decompiler.PlainTextPrinter;

public class ClassFileSourceSaverProvider
implements SourceSaver {
    protected static final String ESCAPE_UNICODE_CHARACTERS = "ClassFileSaverPreferences.escapeUnicodeCharacters";
    protected static final String OMIT_THIS_PREFIX = "ClassFileSaverPreferences.omitThisPrefix";
    protected static final String WRITE_DEFAULT_CONSTRUCTOR = "ClassFileSaverPreferences.writeDefaultConstructor";
    protected static final String REALIGN_LINE_NUMBERS = "ClassFileSaverPreferences.realignLineNumbers";
    protected static final String WRITE_LINE_NUMBERS = "ClassFileSaverPreferences.writeLineNumbers";
    protected static final String WRITE_METADATA = "ClassFileSaverPreferences.writeMetadata";
    protected static final String[] TYPES = new String[]{"*:file:*.class"};
    protected static final Decompiler DECOMPILER = new DecompilerImpl();
    protected GuiPreferences preferences = new GuiPreferences();
    protected ContainerLoader loader = new ContainerLoader();
    protected PlainTextPrinter printer = new PlainTextPrinter();
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream();

    @Override
    public String[] getTypes() {
        return TYPES;
    }

    @Override
    public Pattern getPathPattern() {
        return null;
    }

    @Override
    public String getSourcePath(Container.Entry entry) {
        String path = entry.getPath();
        return path.substring(0, path.length() - 6) + ".java";
    }

    @Override
    public int getFileCount(API api, Container.Entry entry) {
        if (entry.getPath().indexOf(36) == -1) {
            return 1;
        }
        return 0;
    }

    @Override
    public void save(API api, SourceSaver.Controller controller, SourceSaver.Listener listener, Path path, Container.Entry entry) {
        try {
            if (path.toString().indexOf(36) == -1) {
                listener.pathSaved(path);
            }
            Map<String, String> p = api.getPreferences();
            this.preferences.setUnicodeEscape(ClassFileSourceSaverProvider.getPreferenceValue(p, ESCAPE_UNICODE_CHARACTERS, false));
            this.preferences.setShowPrefixThis(!ClassFileSourceSaverProvider.getPreferenceValue(p, OMIT_THIS_PREFIX, false));
            this.preferences.setShowDefaultConstructor(ClassFileSourceSaverProvider.getPreferenceValue(p, WRITE_DEFAULT_CONSTRUCTOR, false));
            this.preferences.setRealignmentLineNumber(ClassFileSourceSaverProvider.getPreferenceValue(p, REALIGN_LINE_NUMBERS, true));
            this.preferences.setShowLineNumbers(ClassFileSourceSaverProvider.getPreferenceValue(p, WRITE_LINE_NUMBERS, true));
            this.loader.setEntry(entry);
            this.baos.reset();
            PrintStream ps = new PrintStream(this.baos);
            this.printer.setPrintStream(ps);
            this.printer.setPreferences(this.preferences);
            DECOMPILER.decompile(this.preferences, this.loader, this.printer, entry.getPath());
            if (ClassFileSourceSaverProvider.getPreferenceValue(p, WRITE_METADATA, true)) {
                ps.print("\n\n/* Location:              ");
                ps.print(new File(entry.getUri()).getPath());
                int majorVersion = this.printer.getMajorVersion();
                if (majorVersion >= 45) {
                    ps.print("\n * Java compiler version: ");
                    if (majorVersion >= 49) {
                        ps.print(majorVersion - 44);
                    } else {
                        ps.print(majorVersion - 44);
                    }
                    ps.print(" (");
                    ps.print(majorVersion);
                    ps.print('.');
                    ps.print(this.printer.getMinorVersion());
                    ps.print(')');
                }
                ps.print("\n * JD-Core Version:       ");
                ps.print("0.7.1-SNAPSHOT-20140817");
                ps.print("\n */");
            }
            try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                this.baos.writeTo(os);
            }
            catch (IOException ignore) {}
        }
        catch (Exception ignore) {
            try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
                writer.write("// INTERNAL ERROR //");
            }
            catch (IOException ignoreAgain) {
                // empty catch block
            }
        }
    }

    protected static boolean getPreferenceValue(Map<String, String> preferences, String key, boolean defaultValue) {
        String v = preferences.get(key);
        if (v == null) {
            return defaultValue;
        }
        return Boolean.valueOf(v);
    }
}

