/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.service.sourcesaver;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import jd.gui.api.model.Container;
import jd.gui.spi.SourceSaver;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class SourceSaverService
implements GroovyObject {
    protected List<SourceSaver> providers;
    protected Map<String, SourceSavers> mapProviders;
    private static volatile SourceSaverService instance;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private SourceSaverService() {
        MetaClass metaClass;
        List<SourceSaver> list = DefaultGroovyMethods.toList(ServiceLoader.load(SourceSaver.class));
        this.providers = list;
        Map<String, SourceSavers> map = this.populate(this.providers);
        this.mapProviders = map;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (instance != null) {
            throw (Throwable)new RuntimeException("Can't instantiate singleton jd.gui.service.sourcesaver.SourceSaverService. Use jd.gui.service.sourcesaver.SourceSaverService.instance");
        }
    }

    protected Map<String, SourceSavers> populate(List<SourceSaver> providers) {
        LinkedHashMap mapProviders = (LinkedHashMap)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createMap(new Object[0]), LinkedHashMap.class);
        Map mapProvidersWithDefault = DefaultGroovyMethods.withDefault(mapProviders, (Closure)((Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public Object doCall(Object it) {
                return new SourceSavers();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _populate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }));
        SourceSaver provider = null;
        Iterator<SourceSaver> iterator = providers.iterator();
        while (iterator.hasNext()) {
            provider = (SourceSaver)ScriptBytecodeAdapter.castToType(iterator.next(), SourceSaver.class);
            String type = null;
            Iterator iterator2 = DefaultGroovyMethods.iterator(provider.getTypes());
            while (iterator2.hasNext()) {
                type = ShortTypeHandling.castToString(iterator2.next());
                ((SourceSavers)DefaultGroovyMethods.getAt(mapProvidersWithDefault, type)).add(provider);
            }
        }
        return mapProviders;
    }

    public SourceSaver get(Container.Entry entry) {
        SourceSaver saver = this.get(entry.getContainer().getType(), entry);
        SourceSaver sourceSaver = saver;
        return DefaultTypeTransformation.booleanUnbox(sourceSaver) ? sourceSaver : this.get("*", entry);
    }

    public SourceSaver get(String containerType, Container.Entry entry) {
        String path = entry.getPath();
        String type = entry.isDirectory() ? "dir" : "file";
        String prefix = StringGroovyMethods.plus(StringGroovyMethods.plus(containerType, (CharSequence)":"), (CharSequence)type);
        SourceSavers sourceSavers = this.mapProviders.get(StringGroovyMethods.plus(StringGroovyMethods.plus(prefix, (CharSequence)":"), (CharSequence)path));
        SourceSaver saver = sourceSavers != null ? sourceSavers.match(path) : null;
        if (!DefaultTypeTransformation.booleanUnbox(saver)) {
            SourceSaver sourceSaver;
            int lastSlashIndex = path.lastIndexOf("/");
            String name = path.substring(lastSlashIndex + 1);
            SourceSavers sourceSavers2 = this.mapProviders.get(StringGroovyMethods.plus(StringGroovyMethods.plus(prefix, (CharSequence)":*/"), (CharSequence)name));
            saver = sourceSaver = sourceSavers2 != null ? sourceSavers2.match(path) : null;
            if (!DefaultTypeTransformation.booleanUnbox(saver)) {
                int index = name.lastIndexOf(".");
                if (ScriptBytecodeAdapter.compareNotEqual(index, -1)) {
                    SourceSaver sourceSaver2;
                    String extension = name.substring(index + 1);
                    SourceSavers sourceSavers3 = this.mapProviders.get(StringGroovyMethods.plus(StringGroovyMethods.plus(prefix, (CharSequence)":*."), (CharSequence)extension));
                    saver = sourceSaver2 = sourceSavers3 != null ? sourceSavers3.match(path) : null;
                }
                if (!DefaultTypeTransformation.booleanUnbox(saver)) {
                    SourceSaver sourceSaver3;
                    SourceSavers sourceSavers4 = this.mapProviders.get(StringGroovyMethods.plus(prefix, (CharSequence)":*"));
                    saver = sourceSaver3 = sourceSavers4 != null ? sourceSavers4.match(path) : null;
                }
            }
        }
        return saver;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SourceSaverService getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<SourceSaverService> clazz = SourceSaverService.class;
        synchronized (clazz) {
            if (instance != null) {
                return instance;
            }
            {
                SourceSaverService sourceSaverService3;
                instance = sourceSaverService3 = new SourceSaverService();
                return sourceSaverService3;
            }
        }
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SourceSaverService.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, SourceSaverService.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(SourceSaverService.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SourceSaverService.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    public static class SourceSavers
    implements GroovyObject {
        private ArrayList<SourceSaver> savers;
        private SourceSaver defaultSaver;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public SourceSavers() {
            MetaClass metaClass;
            ArrayList arrayList = new ArrayList();
            this.savers = arrayList;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void add(SourceSaver saver) {
            if (saver.getPathPattern() != null) {
                DefaultGroovyMethods.leftShift(this.savers, saver);
            } else {
                SourceSaver sourceSaver;
                this.defaultSaver = sourceSaver = saver;
            }
        }

        public SourceSaver match(String path) {
            SourceSaver saver = null;
            Iterator<SourceSaver> iterator = this.savers.iterator();
            while (iterator.hasNext()) {
                saver = (SourceSaver)ScriptBytecodeAdapter.castToType(iterator.next(), SourceSaver.class);
                if (!ScriptBytecodeAdapter.matchRegex(path, saver.getPathPattern())) continue;
                return saver;
            }
            return this.defaultSaver;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(SourceSavers.class, SourceSaverService.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, SourceSaverService.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(SourceSavers.class, SourceSaverService.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SourceSavers.class) {
                return ScriptBytecodeAdapter.initMetaClass(this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Override
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Override
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Override
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Override
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty(this, string);
        }

        @Override
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty(this, string, object);
        }

        public ArrayList<SourceSaver> getSavers() {
            return this.savers;
        }

        public void setSavers(ArrayList<SourceSaver> arrayList) {
            this.savers = arrayList;
        }

        public SourceSaver getDefaultSaver() {
            return this.defaultSaver;
        }

        public void setDefaultSaver(SourceSaver sourceSaver) {
            this.defaultSaver = sourceSaver;
        }
    }
}

