/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.service.treenode;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import jd.gui.api.model.Container;
import jd.gui.spi.TreeNodeFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class TreeNodeFactoryService
implements GroovyObject {
    protected List<TreeNodeFactory> providers;
    protected Map<String, TreeNodeFactories> mapProviders;
    private static volatile TreeNodeFactoryService instance;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    private TreeNodeFactoryService() {
        MetaClass metaClass;
        List<TreeNodeFactory> list = DefaultGroovyMethods.toList(ServiceLoader.load(TreeNodeFactory.class));
        this.providers = list;
        Map<String, TreeNodeFactories> map = this.populate(this.providers);
        this.mapProviders = map;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (instance != null) {
            throw (Throwable)new RuntimeException("Can't instantiate singleton jd.gui.service.treenode.TreeNodeFactoryService. Use jd.gui.service.treenode.TreeNodeFactoryService.instance");
        }
    }

    protected Map<String, TreeNodeFactories> populate(List<TreeNodeFactory> providers) {
        LinkedHashMap mapProviders = (LinkedHashMap)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.createMap(new Object[0]), LinkedHashMap.class);
        Map mapProvidersWithDefault = DefaultGroovyMethods.withDefault(mapProviders, (Closure)((Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public Object doCall(Object it) {
                return new TreeNodeFactories();
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            @Override
            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != _populate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass(this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }
        }));
        TreeNodeFactory provider = null;
        Iterator<TreeNodeFactory> iterator = providers.iterator();
        while (iterator.hasNext()) {
            provider = (TreeNodeFactory)ScriptBytecodeAdapter.castToType(iterator.next(), TreeNodeFactory.class);
            String type = null;
            Iterator iterator2 = DefaultGroovyMethods.iterator(provider.getTypes());
            while (iterator2.hasNext()) {
                type = ShortTypeHandling.castToString(iterator2.next());
                ((TreeNodeFactories)DefaultGroovyMethods.getAt(mapProvidersWithDefault, type)).add(provider);
            }
        }
        return mapProviders;
    }

    public TreeNodeFactory get(Container.Entry entry) {
        TreeNodeFactory factory = this.get(entry.getContainer().getType(), entry);
        TreeNodeFactory treeNodeFactory = factory;
        return DefaultTypeTransformation.booleanUnbox(treeNodeFactory) ? treeNodeFactory : this.get("*", entry);
    }

    public TreeNodeFactory get(String containerType, Container.Entry entry) {
        String path = entry.getPath();
        String type = entry.isDirectory() ? "dir" : "file";
        String prefix = StringGroovyMethods.plus(StringGroovyMethods.plus(StringGroovyMethods.plus(containerType, (CharSequence)":"), (CharSequence)type), (CharSequence)":");
        TreeNodeFactories treeNodeFactories = this.mapProviders.get(StringGroovyMethods.plus(prefix, (CharSequence)path));
        TreeNodeFactory factory = treeNodeFactories != null ? treeNodeFactories.match(path) : null;
        if (!DefaultTypeTransformation.booleanUnbox(factory)) {
            TreeNodeFactory treeNodeFactory;
            int lastSlashIndex = path.lastIndexOf("/");
            String name = path.substring(lastSlashIndex + 1);
            TreeNodeFactories treeNodeFactories2 = this.mapProviders.get(StringGroovyMethods.plus(StringGroovyMethods.plus(prefix, (CharSequence)"*/"), (CharSequence)name));
            factory = treeNodeFactory = treeNodeFactories2 != null ? treeNodeFactories2.match(path) : null;
            if (!DefaultTypeTransformation.booleanUnbox(factory)) {
                int index = name.lastIndexOf(".");
                if (ScriptBytecodeAdapter.compareNotEqual(index, -1)) {
                    TreeNodeFactory treeNodeFactory2;
                    String extension = name.substring(index + 1);
                    TreeNodeFactories treeNodeFactories3 = this.mapProviders.get(StringGroovyMethods.plus(StringGroovyMethods.plus(prefix, (CharSequence)"*."), (CharSequence)extension));
                    factory = treeNodeFactory2 = treeNodeFactories3 != null ? treeNodeFactories3.match(path) : null;
                }
                if (!DefaultTypeTransformation.booleanUnbox(factory)) {
                    TreeNodeFactory treeNodeFactory3;
                    TreeNodeFactories treeNodeFactories4 = this.mapProviders.get(StringGroovyMethods.plus(prefix, (CharSequence)"*"));
                    factory = treeNodeFactory3 = treeNodeFactories4 != null ? treeNodeFactories4.match(path) : null;
                }
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TreeNodeFactoryService getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<TreeNodeFactoryService> clazz = TreeNodeFactoryService.class;
        synchronized (clazz) {
            if (instance != null) {
                return instance;
            }
            {
                TreeNodeFactoryService treeNodeFactoryService3;
                instance = treeNodeFactoryService3 = new TreeNodeFactoryService();
                return treeNodeFactoryService3;
            }
        }
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(TreeNodeFactoryService.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty(object, TreeNodeFactoryService.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(TreeNodeFactoryService.class, this, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TreeNodeFactoryService.class) {
            return ScriptBytecodeAdapter.initMetaClass(this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Override
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Override
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Override
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty(this, string);
    }

    @Override
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty(this, string, object);
    }

    public static class TreeNodeFactories
    implements GroovyObject {
        private ArrayList<TreeNodeFactory> factories;
        private TreeNodeFactory defaultFactory;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public TreeNodeFactories() {
            MetaClass metaClass;
            ArrayList arrayList = new ArrayList();
            this.factories = arrayList;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void add(TreeNodeFactory factory) {
            if (factory.getPathPattern() != null) {
                DefaultGroovyMethods.leftShift(this.factories, factory);
            } else {
                TreeNodeFactory treeNodeFactory;
                this.defaultFactory = treeNodeFactory = factory;
            }
        }

        public TreeNodeFactory match(String path) {
            TreeNodeFactory factory = null;
            Iterator<TreeNodeFactory> iterator = this.factories.iterator();
            while (iterator.hasNext()) {
                factory = (TreeNodeFactory)ScriptBytecodeAdapter.castToType(iterator.next(), TreeNodeFactory.class);
                if (!ScriptBytecodeAdapter.matchRegex(path, factory.getPathPattern())) continue;
                return factory;
            }
            return this.defaultFactory;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(TreeNodeFactories.class, TreeNodeFactoryService.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})), ScriptBytecodeAdapter.despreadList(new Object[0], new Object[]{args}, new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty(object, null, TreeNodeFactoryService.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(TreeNodeFactories.class, TreeNodeFactoryService.class, ShortTypeHandling.castToString(new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != TreeNodeFactories.class) {
                return ScriptBytecodeAdapter.initMetaClass(this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Override
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Override
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Override
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Override
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty(this, string);
        }

        @Override
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty(this, string, object);
        }

        public ArrayList<TreeNodeFactory> getFactories() {
            return this.factories;
        }

        public void setFactories(ArrayList<TreeNodeFactory> arrayList) {
            this.factories = arrayList;
        }

        public TreeNodeFactory getDefaultFactory() {
            return this.defaultFactory;
        }

        public void setDefaultFactory(TreeNodeFactory treeNodeFactory) {
            this.defaultFactory = treeNodeFactory;
        }
    }
}

