import nidigital

with nidigital.Session(resource_name="PXIe_6570") as session:
    session.load_pin_map('my.pinmap')
    wave_cfg = {
        'waveform_name': 'my_wave',
        'data_mapping': nidigital.SourceDataMapping.BROADCAST,
        'sample_width': 1,
        'bit_order': nidigital.BitOrder.LSB,
    }
    print('Calling create_source on specific pin works.')
    session.pins['SYNC1'].create_source_waveform_serial(**wave_cfg)
    print('###')
    print('calling create_source on more than one pin raises expected error message:')
    try:
        session.pins['SYNC1', 'SYNC2'].create_source_waveform_serial(**wave_cfg)
    except nidigital.errors.DriverError as error:
        print(error)
    print('###')
    print('calling create_source on session raises misleading error message:')
    session.create_source_waveform_serial(**wave_cfg)