(function() {var type_impls = {
"std":[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#414\">source</a><a href=\"#impl-Vec%3CT%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.new\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"const since 1.39.0\">const: 1.39.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#429\">source</a></span><h4 class=\"code-header\">pub const fn <a href=\"alloc/vec/struct.Vec.html#tymethod.new\" class=\"fn\">new</a>() -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Constructs a new, empty <code>Vec&lt;T&gt;</code>.</p>\n<p>The vector will not allocate until elements are pushed onto it.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec: Vec&lt;i32&gt; = Vec::new();</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Ballow(unused_mut)%5D%0Afn+main()+%7B%0Alet+mut+vec:+Vec%3Ci32%3E+=+Vec::new();%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.with_capacity\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#487\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.with_capacity\" class=\"fn\">with_capacity</a>(capacity: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Constructs a new, empty <code>Vec&lt;T&gt;</code> with at least the specified capacity.</p>\n<p>The vector will be able to hold at least <code>capacity</code> elements without\nreallocating. This method is allowed to allocate for more elements than\n<code>capacity</code>. If <code>capacity</code> is 0, the vector will not allocate.</p>\n<p>It is important to note that although the returned vector has the\nminimum <em>capacity</em> specified, the vector will have a zero <em>length</em>. For\nan explanation of the difference between length and capacity, see\n<em><a href=\"#capacity-and-reallocation\">Capacity and reallocation</a></em>.</p>\n<p>If it is important to know the exact allocated capacity of a <code>Vec</code>,\nalways use the <a href=\"alloc/vec/struct.Vec.html#method.capacity\" title=\"method alloc::vec::Vec::capacity\"><code>capacity</code></a> method after construction.</p>\n<p>For <code>Vec&lt;T&gt;</code> where <code>T</code> is a zero-sized type, there will be no allocation\nand the capacity will always be <code>usize::MAX</code>.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the new capacity exceeds <code>isize::MAX</code> bytes.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = Vec::with_capacity(<span class=\"number\">10</span>);\n\n<span class=\"comment\">// The vector contains no items, even though it has capacity for more\n</span><span class=\"macro\">assert_eq!</span>(vec.len(), <span class=\"number\">0</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">10</span>);\n\n<span class=\"comment\">// These are all done without reallocating...\n</span><span class=\"kw\">for </span>i <span class=\"kw\">in </span><span class=\"number\">0</span>..<span class=\"number\">10 </span>{\n    vec.push(i);\n}\n<span class=\"macro\">assert_eq!</span>(vec.len(), <span class=\"number\">10</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">10</span>);\n\n<span class=\"comment\">// ...but this may make the vector reallocate\n</span>vec.push(<span class=\"number\">11</span>);\n<span class=\"macro\">assert_eq!</span>(vec.len(), <span class=\"number\">11</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">11</span>);\n\n<span class=\"comment\">// A vector of a zero-sized type will always over-allocate, since no\n// allocation is necessary\n</span><span class=\"kw\">let </span>vec_units = Vec::&lt;()&gt;::with_capacity(<span class=\"number\">10</span>);\n<span class=\"macro\">assert_eq!</span>(vec_units.capacity(), usize::MAX);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+Vec::with_capacity(10);%0A%0A//+The+vector+contains+no+items,+even+though+it+has+capacity+for+more%0Aassert_eq!(vec.len(),+0);%0Aassert!(vec.capacity()+%3E=+10);%0A%0A//+These+are+all+done+without+reallocating...%0Afor+i+in+0..10+%7B%0A++++vec.push(i);%0A%7D%0Aassert_eq!(vec.len(),+10);%0Aassert!(vec.capacity()+%3E=+10);%0A%0A//+...but+this+may+make+the+vector+reallocate%0Avec.push(11);%0Aassert_eq!(vec.len(),+11);%0Aassert!(vec.capacity()+%3E=+11);%0A%0A//+A+vector+of+a+zero-sized+type+will+always+over-allocate,+since+no%0A//+allocation+is+necessary%0Alet+vec_units+=+Vec::%3C()%3E::with_capacity(10);%0Aassert_eq!(vec_units.capacity(),+usize::MAX);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_raw_parts\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#594\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"alloc/vec/struct.Vec.html#tymethod.from_raw_parts\" class=\"fn\">from_raw_parts</a>(\n    ptr: <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>,\n    length: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>,\n    capacity: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>\n) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Creates a <code>Vec&lt;T&gt;</code> directly from a pointer, a capacity, and a length.</p>\n<h5 id=\"safety\"><a href=\"#safety\">Safety</a></h5>\n<p>This is highly unsafe, due to the number of invariants that aren’t\nchecked:</p>\n<ul>\n<li><code>ptr</code> must have been allocated using the global allocator, such as via\nthe <a href=\"std/alloc/fn.alloc.html\" title=\"fn std::alloc::alloc\"><code>alloc::alloc</code></a> function.</li>\n<li><code>T</code> needs to have the same alignment as what <code>ptr</code> was allocated with.\n(<code>T</code> having a less strict alignment is not sufficient, the alignment really\nneeds to be equal to satisfy the <a href=\"std/alloc/trait.GlobalAlloc.html#tymethod.dealloc\" title=\"method std::alloc::GlobalAlloc::dealloc\"><code>dealloc</code></a> requirement that memory must be\nallocated and deallocated with the same layout.)</li>\n<li>The size of <code>T</code> times the <code>capacity</code> (ie. the allocated size in bytes) needs\nto be the same size as the pointer was allocated with. (Because similar to\nalignment, <a href=\"std/alloc/trait.GlobalAlloc.html#tymethod.dealloc\" title=\"method std::alloc::GlobalAlloc::dealloc\"><code>dealloc</code></a> must be called with the same layout <code>size</code>.)</li>\n<li><code>length</code> needs to be less than or equal to <code>capacity</code>.</li>\n<li>The first <code>length</code> values must be properly initialized values of type <code>T</code>.</li>\n<li><code>capacity</code> needs to be the capacity that the pointer was allocated with.</li>\n<li>The allocated size in bytes must be no larger than <code>isize::MAX</code>.\nSee the safety documentation of <a href=\"std/primitive.pointer.html#method.offset\" title=\"method pointer::offset\"><code>pointer::offset</code></a>.</li>\n</ul>\n<p>These requirements are always upheld by any <code>ptr</code> that has been allocated\nvia <code>Vec&lt;T&gt;</code>. Other allocation sources are allowed if the invariants are\nupheld.</p>\n<p>Violating these may cause problems like corrupting the allocator’s\ninternal data structures. For example it is normally <strong>not</strong> safe\nto build a <code>Vec&lt;u8&gt;</code> from a pointer to a C <code>char</code> array with length\n<code>size_t</code>, doing so is only safe if the array was initially allocated by\na <code>Vec</code> or <code>String</code>.\nIt’s also not safe to build one from a <code>Vec&lt;u16&gt;</code> and its length, because\nthe allocator cares about the alignment, and these two types have different\nalignments. The buffer was allocated with alignment 2 (for <code>u16</code>), but after\nturning it into a <code>Vec&lt;u8&gt;</code> it’ll be deallocated with alignment 1. To avoid\nthese issues, it is often preferable to do casting/transmuting using\n<a href=\"std/slice/fn.from_raw_parts.html\" title=\"fn std::slice::from_raw_parts\"><code>slice::from_raw_parts</code></a> instead.</p>\n<p>The ownership of <code>ptr</code> is effectively transferred to the\n<code>Vec&lt;T&gt;</code> which may then deallocate, reallocate or change the\ncontents of memory pointed to by the pointer at will. Ensure\nthat nothing else uses the pointer after calling this\nfunction.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::ptr;\n<span class=\"kw\">use </span>std::mem;\n\n<span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n\n<span class=\"comment\">// Prevent running `v`&#39;s destructor so we are in complete control\n// of the allocation.\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = mem::ManuallyDrop::new(v);\n\n<span class=\"comment\">// Pull out the various important pieces of information about `v`\n</span><span class=\"kw\">let </span>p = v.as_mut_ptr();\n<span class=\"kw\">let </span>len = v.len();\n<span class=\"kw\">let </span>cap = v.capacity();\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"comment\">// Overwrite memory with 4, 5, 6\n    </span><span class=\"kw\">for </span>i <span class=\"kw\">in </span><span class=\"number\">0</span>..len {\n        ptr::write(p.add(i), <span class=\"number\">4 </span>+ i);\n    }\n\n    <span class=\"comment\">// Put everything back together into a Vec\n    </span><span class=\"kw\">let </span>rebuilt = Vec::from_raw_parts(p, len, cap);\n    <span class=\"macro\">assert_eq!</span>(rebuilt, [<span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>]);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::ptr;%0Ause+std::mem;%0A%0Alet+v+=+vec!%5B1,+2,+3%5D;%0A%0A//+Prevent+running+%60v%60's+destructor+so+we+are+in+complete+control%0A//+of+the+allocation.%0Alet+mut+v+=+mem::ManuallyDrop::new(v);%0A%0A//+Pull+out+the+various+important+pieces+of+information+about+%60v%60%0Alet+p+=+v.as_mut_ptr();%0Alet+len+=+v.len();%0Alet+cap+=+v.capacity();%0A%0Aunsafe+%7B%0A++++//+Overwrite+memory+with+4,+5,+6%0A++++for+i+in+0..len+%7B%0A++++++++ptr::write(p.add(i),+4+%2B+i);%0A++++%7D%0A%0A++++//+Put+everything+back+together+into+a+Vec%0A++++let+rebuilt+=+Vec::from_raw_parts(p,+len,+cap);%0A++++assert_eq!(rebuilt,+%5B4,+5,+6%5D);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Using memory that was allocated elsewhere:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::alloc::{alloc, Layout};\n\n<span class=\"kw\">fn </span>main() {\n    <span class=\"kw\">let </span>layout = Layout::array::&lt;u32&gt;(<span class=\"number\">16</span>).expect(<span class=\"string\">&quot;overflow cannot happen&quot;</span>);\n\n    <span class=\"kw\">let </span>vec = <span class=\"kw\">unsafe </span>{\n        <span class=\"kw\">let </span>mem = alloc(layout).cast::&lt;u32&gt;();\n        <span class=\"kw\">if </span>mem.is_null() {\n            <span class=\"kw\">return</span>;\n        }\n\n        mem.write(<span class=\"number\">1_000_000</span>);\n\n        Vec::from_raw_parts(mem, <span class=\"number\">1</span>, <span class=\"number\">16</span>)\n    };\n\n    <span class=\"macro\">assert_eq!</span>(vec, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1_000_000</span>]);\n    <span class=\"macro\">assert_eq!</span>(vec.capacity(), <span class=\"number\">16</span>);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Ause+std::alloc::%7Balloc,+Layout%7D;%0A%0Afn+main()+%7B%0A++++let+layout+=+Layout::array::%3Cu32%3E(16).expect(%22overflow+cannot+happen%22);%0A%0A++++let+vec+=+unsafe+%7B%0A++++++++let+mem+=+alloc(layout).cast::%3Cu32%3E();%0A++++++++if+mem.is_null()+%7B%0A++++++++++++return;%0A++++++++%7D%0A%0A++++++++mem.write(1_000_000);%0A%0A++++++++Vec::from_raw_parts(mem,+1,+16)%0A++++%7D;%0A%0A++++assert_eq!(vec,+%26%5B1_000_000%5D);%0A++++assert_eq!(vec.capacity(),+16);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#599\">source</a><a href=\"#impl-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.new_in\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#616\">source</a><h4 class=\"code-header\">pub const fn <a href=\"alloc/vec/struct.Vec.html#tymethod.new_in\" class=\"fn\">new_in</a>(alloc: A) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>allocator_api</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/32838\">#32838</a>)</span></div></span></summary><div class=\"docblock\"><p>Constructs a new, empty <code>Vec&lt;T, A&gt;</code>.</p>\n<p>The vector will not allocate until elements are pushed onto it.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(allocator_api)]\n\n</span><span class=\"kw\">use </span>std::alloc::System;\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec: Vec&lt;i32, <span class=\"kw\">_</span>&gt; = Vec::new_in(System);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(allocator_api)%5D%0A%0Afn+main()+%7B%0Ause+std::alloc::System;%0A%0A%23%5Ballow(unused_mut)%5D%0Alet+mut+vec:+Vec%3Ci32,+_%3E+=+Vec::new_in(System);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#620\">source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.with_capacity_in\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#679\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.with_capacity_in\" class=\"fn\">with_capacity_in</a>(capacity: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, alloc: A) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>allocator_api</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/32838\">#32838</a>)</span></div></span></summary><div class=\"docblock\"><p>Constructs a new, empty <code>Vec&lt;T, A&gt;</code> with at least the specified capacity\nwith the provided allocator.</p>\n<p>The vector will be able to hold at least <code>capacity</code> elements without\nreallocating. This method is allowed to allocate for more elements than\n<code>capacity</code>. If <code>capacity</code> is 0, the vector will not allocate.</p>\n<p>It is important to note that although the returned vector has the\nminimum <em>capacity</em> specified, the vector will have a zero <em>length</em>. For\nan explanation of the difference between length and capacity, see\n<em><a href=\"#capacity-and-reallocation\">Capacity and reallocation</a></em>.</p>\n<p>If it is important to know the exact allocated capacity of a <code>Vec</code>,\nalways use the <a href=\"alloc/vec/struct.Vec.html#method.capacity\" title=\"method alloc::vec::Vec::capacity\"><code>capacity</code></a> method after construction.</p>\n<p>For <code>Vec&lt;T, A&gt;</code> where <code>T</code> is a zero-sized type, there will be no allocation\nand the capacity will always be <code>usize::MAX</code>.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the new capacity exceeds <code>isize::MAX</code> bytes.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(allocator_api)]\n\n</span><span class=\"kw\">use </span>std::alloc::System;\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = Vec::with_capacity_in(<span class=\"number\">10</span>, System);\n\n<span class=\"comment\">// The vector contains no items, even though it has capacity for more\n</span><span class=\"macro\">assert_eq!</span>(vec.len(), <span class=\"number\">0</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">10</span>);\n\n<span class=\"comment\">// These are all done without reallocating...\n</span><span class=\"kw\">for </span>i <span class=\"kw\">in </span><span class=\"number\">0</span>..<span class=\"number\">10 </span>{\n    vec.push(i);\n}\n<span class=\"macro\">assert_eq!</span>(vec.len(), <span class=\"number\">10</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">10</span>);\n\n<span class=\"comment\">// ...but this may make the vector reallocate\n</span>vec.push(<span class=\"number\">11</span>);\n<span class=\"macro\">assert_eq!</span>(vec.len(), <span class=\"number\">11</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">11</span>);\n\n<span class=\"comment\">// A vector of a zero-sized type will always over-allocate, since no\n// allocation is necessary\n</span><span class=\"kw\">let </span>vec_units = Vec::&lt;(), System&gt;::with_capacity_in(<span class=\"number\">10</span>, System);\n<span class=\"macro\">assert_eq!</span>(vec_units.capacity(), usize::MAX);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(allocator_api)%5D%0A%0Afn+main()+%7B%0Ause+std::alloc::System;%0A%0Alet+mut+vec+=+Vec::with_capacity_in(10,+System);%0A%0A//+The+vector+contains+no+items,+even+though+it+has+capacity+for+more%0Aassert_eq!(vec.len(),+0);%0Aassert!(vec.capacity()+%3E=+10);%0A%0A//+These+are+all+done+without+reallocating...%0Afor+i+in+0..10+%7B%0A++++vec.push(i);%0A%7D%0Aassert_eq!(vec.len(),+10);%0Aassert!(vec.capacity()+%3E=+10);%0A%0A//+...but+this+may+make+the+vector+reallocate%0Avec.push(11);%0Aassert_eq!(vec.len(),+11);%0Aassert!(vec.capacity()+%3E=+11);%0A%0A//+A+vector+of+a+zero-sized+type+will+always+over-allocate,+since+no%0A//+allocation+is+necessary%0Alet+vec_units+=+Vec::%3C(),+System%3E::with_capacity_in(10,+System);%0Aassert_eq!(vec_units.capacity(),+usize::MAX);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#693\">source</a><a href=\"#impl-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_raw_parts_in\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#804\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"alloc/vec/struct.Vec.html#tymethod.from_raw_parts_in\" class=\"fn\">from_raw_parts_in</a>(\n    ptr: <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>,\n    length: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>,\n    capacity: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>,\n    alloc: A\n) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>allocator_api</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/32838\">#32838</a>)</span></div></span></summary><div class=\"docblock\"><p>Creates a <code>Vec&lt;T, A&gt;</code> directly from a pointer, a capacity, a length,\nand an allocator.</p>\n<h5 id=\"safety\"><a href=\"#safety\">Safety</a></h5>\n<p>This is highly unsafe, due to the number of invariants that aren’t\nchecked:</p>\n<ul>\n<li><code>ptr</code> must be <a href=\"std/alloc/trait.Allocator.html#currently-allocated-memory\" title=\"trait std::alloc::Allocator\"><em>currently allocated</em></a> via the given allocator <code>alloc</code>.</li>\n<li><code>T</code> needs to have the same alignment as what <code>ptr</code> was allocated with.\n(<code>T</code> having a less strict alignment is not sufficient, the alignment really\nneeds to be equal to satisfy the <a href=\"std/alloc/trait.GlobalAlloc.html#tymethod.dealloc\" title=\"method std::alloc::GlobalAlloc::dealloc\"><code>dealloc</code></a> requirement that memory must be\nallocated and deallocated with the same layout.)</li>\n<li>The size of <code>T</code> times the <code>capacity</code> (ie. the allocated size in bytes) needs\nto be the same size as the pointer was allocated with. (Because similar to\nalignment, <a href=\"std/alloc/trait.GlobalAlloc.html#tymethod.dealloc\" title=\"method std::alloc::GlobalAlloc::dealloc\"><code>dealloc</code></a> must be called with the same layout <code>size</code>.)</li>\n<li><code>length</code> needs to be less than or equal to <code>capacity</code>.</li>\n<li>The first <code>length</code> values must be properly initialized values of type <code>T</code>.</li>\n<li><code>capacity</code> needs to <a href=\"std/alloc/trait.Allocator.html#memory-fitting\" title=\"trait std::alloc::Allocator\"><em>fit</em></a> the layout size that the pointer was allocated with.</li>\n<li>The allocated size in bytes must be no larger than <code>isize::MAX</code>.\nSee the safety documentation of <a href=\"std/primitive.pointer.html#method.offset\" title=\"method pointer::offset\"><code>pointer::offset</code></a>.</li>\n</ul>\n<p>These requirements are always upheld by any <code>ptr</code> that has been allocated\nvia <code>Vec&lt;T, A&gt;</code>. Other allocation sources are allowed if the invariants are\nupheld.</p>\n<p>Violating these may cause problems like corrupting the allocator’s\ninternal data structures. For example it is <strong>not</strong> safe\nto build a <code>Vec&lt;u8&gt;</code> from a pointer to a C <code>char</code> array with length <code>size_t</code>.\nIt’s also not safe to build one from a <code>Vec&lt;u16&gt;</code> and its length, because\nthe allocator cares about the alignment, and these two types have different\nalignments. The buffer was allocated with alignment 2 (for <code>u16</code>), but after\nturning it into a <code>Vec&lt;u8&gt;</code> it’ll be deallocated with alignment 1.</p>\n<p>The ownership of <code>ptr</code> is effectively transferred to the\n<code>Vec&lt;T&gt;</code> which may then deallocate, reallocate or change the\ncontents of memory pointed to by the pointer at will. Ensure\nthat nothing else uses the pointer after calling this\nfunction.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(allocator_api)]\n\n</span><span class=\"kw\">use </span>std::alloc::System;\n\n<span class=\"kw\">use </span>std::ptr;\n<span class=\"kw\">use </span>std::mem;\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = Vec::with_capacity_in(<span class=\"number\">3</span>, System);\nv.push(<span class=\"number\">1</span>);\nv.push(<span class=\"number\">2</span>);\nv.push(<span class=\"number\">3</span>);\n\n<span class=\"comment\">// Prevent running `v`&#39;s destructor so we are in complete control\n// of the allocation.\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = mem::ManuallyDrop::new(v);\n\n<span class=\"comment\">// Pull out the various important pieces of information about `v`\n</span><span class=\"kw\">let </span>p = v.as_mut_ptr();\n<span class=\"kw\">let </span>len = v.len();\n<span class=\"kw\">let </span>cap = v.capacity();\n<span class=\"kw\">let </span>alloc = v.allocator();\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"comment\">// Overwrite memory with 4, 5, 6\n    </span><span class=\"kw\">for </span>i <span class=\"kw\">in </span><span class=\"number\">0</span>..len {\n        ptr::write(p.add(i), <span class=\"number\">4 </span>+ i);\n    }\n\n    <span class=\"comment\">// Put everything back together into a Vec\n    </span><span class=\"kw\">let </span>rebuilt = Vec::from_raw_parts_in(p, len, cap, alloc.clone());\n    <span class=\"macro\">assert_eq!</span>(rebuilt, [<span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>]);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(allocator_api)%5D%0A%0Afn+main()+%7B%0Ause+std::alloc::System;%0A%0Ause+std::ptr;%0Ause+std::mem;%0A%0Alet+mut+v+=+Vec::with_capacity_in(3,+System);%0Av.push(1);%0Av.push(2);%0Av.push(3);%0A%0A//+Prevent+running+%60v%60's+destructor+so+we+are+in+complete+control%0A//+of+the+allocation.%0Alet+mut+v+=+mem::ManuallyDrop::new(v);%0A%0A//+Pull+out+the+various+important+pieces+of+information+about+%60v%60%0Alet+p+=+v.as_mut_ptr();%0Alet+len+=+v.len();%0Alet+cap+=+v.capacity();%0Alet+alloc+=+v.allocator();%0A%0Aunsafe+%7B%0A++++//+Overwrite+memory+with+4,+5,+6%0A++++for+i+in+0..len+%7B%0A++++++++ptr::write(p.add(i),+4+%2B+i);%0A++++%7D%0A%0A++++//+Put+everything+back+together+into+a+Vec%0A++++let+rebuilt+=+Vec::from_raw_parts_in(p,+len,+cap,+alloc.clone());%0A++++assert_eq!(rebuilt,+%5B4,+5,+6%5D);%0A%7D%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n<p>Using memory that was allocated elsewhere:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(allocator_api)]\n\n</span><span class=\"kw\">use </span>std::alloc::{AllocError, Allocator, Global, Layout};\n\n<span class=\"kw\">fn </span>main() {\n    <span class=\"kw\">let </span>layout = Layout::array::&lt;u32&gt;(<span class=\"number\">16</span>).expect(<span class=\"string\">&quot;overflow cannot happen&quot;</span>);\n\n    <span class=\"kw\">let </span>vec = <span class=\"kw\">unsafe </span>{\n        <span class=\"kw\">let </span>mem = <span class=\"kw\">match </span>Global.allocate(layout) {\n            <span class=\"prelude-val\">Ok</span>(mem) =&gt; mem.cast::&lt;u32&gt;().as_ptr(),\n            <span class=\"prelude-val\">Err</span>(AllocError) =&gt; <span class=\"kw\">return</span>,\n        };\n\n        mem.write(<span class=\"number\">1_000_000</span>);\n\n        Vec::from_raw_parts_in(mem, <span class=\"number\">1</span>, <span class=\"number\">16</span>, Global)\n    };\n\n    <span class=\"macro\">assert_eq!</span>(vec, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1_000_000</span>]);\n    <span class=\"macro\">assert_eq!</span>(vec.capacity(), <span class=\"number\">16</span>);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(allocator_api)%5D%0A%0Ause+std::alloc::%7BAllocError,+Allocator,+Global,+Layout%7D;%0A%0Afn+main()+%7B%0A++++let+layout+=+Layout::array::%3Cu32%3E(16).expect(%22overflow+cannot+happen%22);%0A%0A++++let+vec+=+unsafe+%7B%0A++++++++let+mem+=+match+Global.allocate(layout)+%7B%0A++++++++++++Ok(mem)+=%3E+mem.cast::%3Cu32%3E().as_ptr(),%0A++++++++++++Err(AllocError)+=%3E+return,%0A++++++++%7D;%0A%0A++++++++mem.write(1_000_000);%0A%0A++++++++Vec::from_raw_parts_in(mem,+1,+16,+Global)%0A++++%7D;%0A%0A++++assert_eq!(vec,+%26%5B1_000_000%5D);%0A++++assert_eq!(vec.capacity(),+16);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_raw_parts\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#841\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.into_raw_parts\" class=\"fn\">into_raw_parts</a>(self) -&gt; (<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>, <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>vec_into_raw_parts</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/65816\">#65816</a>)</span></div></span></summary><div class=\"docblock\"><p>Decomposes a <code>Vec&lt;T&gt;</code> into its raw components.</p>\n<p>Returns the raw pointer to the underlying data, the length of\nthe vector (in elements), and the allocated capacity of the\ndata (in elements). These are the same arguments in the same\norder as the arguments to <a href=\"alloc/vec/struct.Vec.html#method.from_raw_parts\" title=\"associated function alloc::vec::Vec::from_raw_parts\"><code>from_raw_parts</code></a>.</p>\n<p>After calling this function, the caller is responsible for the\nmemory previously managed by the <code>Vec</code>. The only way to do\nthis is to convert the raw pointer, length, and capacity back\ninto a <code>Vec</code> with the <a href=\"alloc/vec/struct.Vec.html#method.from_raw_parts\" title=\"associated function alloc::vec::Vec::from_raw_parts\"><code>from_raw_parts</code></a> function, allowing\nthe destructor to perform the cleanup.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(vec_into_raw_parts)]\n</span><span class=\"kw\">let </span>v: Vec&lt;i32&gt; = <span class=\"macro\">vec!</span>[-<span class=\"number\">1</span>, <span class=\"number\">0</span>, <span class=\"number\">1</span>];\n\n<span class=\"kw\">let </span>(ptr, len, cap) = v.into_raw_parts();\n\n<span class=\"kw\">let </span>rebuilt = <span class=\"kw\">unsafe </span>{\n    <span class=\"comment\">// We can now make changes to the components, such as\n    // transmuting the raw pointer to a compatible type.\n    </span><span class=\"kw\">let </span>ptr = ptr <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u32;\n\n    Vec::from_raw_parts(ptr, len, cap)\n};\n<span class=\"macro\">assert_eq!</span>(rebuilt, [<span class=\"number\">4294967295</span>, <span class=\"number\">0</span>, <span class=\"number\">1</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(vec_into_raw_parts)%5D%0Afn+main()+%7B%0Alet+v:+Vec%3Ci32%3E+=+vec!%5B-1,+0,+1%5D;%0A%0Alet+(ptr,+len,+cap)+=+v.into_raw_parts();%0A%0Alet+rebuilt+=+unsafe+%7B%0A++++//+We+can+now+make+changes+to+the+components,+such+as%0A++++//+transmuting+the+raw+pointer+to+a+compatible+type.%0A++++let+ptr+=+ptr+as+*mut+u32;%0A%0A++++Vec::from_raw_parts(ptr,+len,+cap)%0A%7D;%0Aassert_eq!(rebuilt,+%5B4294967295,+0,+1%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_raw_parts_with_alloc\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#885\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.into_raw_parts_with_alloc\" class=\"fn\">into_raw_parts_with_alloc</a>(self) -&gt; (<a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a>, <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, A)</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>allocator_api</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/32838\">#32838</a>)</span></div></span></summary><div class=\"docblock\"><p>Decomposes a <code>Vec&lt;T&gt;</code> into its raw components.</p>\n<p>Returns the raw pointer to the underlying data, the length of the vector (in elements),\nthe allocated capacity of the data (in elements), and the allocator. These are the same\narguments in the same order as the arguments to <a href=\"alloc/vec/struct.Vec.html#method.from_raw_parts_in\" title=\"associated function alloc::vec::Vec::from_raw_parts_in\"><code>from_raw_parts_in</code></a>.</p>\n<p>After calling this function, the caller is responsible for the\nmemory previously managed by the <code>Vec</code>. The only way to do\nthis is to convert the raw pointer, length, and capacity back\ninto a <code>Vec</code> with the <a href=\"alloc/vec/struct.Vec.html#method.from_raw_parts_in\" title=\"associated function alloc::vec::Vec::from_raw_parts_in\"><code>from_raw_parts_in</code></a> function, allowing\nthe destructor to perform the cleanup.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(allocator_api, vec_into_raw_parts)]\n\n</span><span class=\"kw\">use </span>std::alloc::System;\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v: Vec&lt;i32, System&gt; = Vec::new_in(System);\nv.push(-<span class=\"number\">1</span>);\nv.push(<span class=\"number\">0</span>);\nv.push(<span class=\"number\">1</span>);\n\n<span class=\"kw\">let </span>(ptr, len, cap, alloc) = v.into_raw_parts_with_alloc();\n\n<span class=\"kw\">let </span>rebuilt = <span class=\"kw\">unsafe </span>{\n    <span class=\"comment\">// We can now make changes to the components, such as\n    // transmuting the raw pointer to a compatible type.\n    </span><span class=\"kw\">let </span>ptr = ptr <span class=\"kw\">as </span><span class=\"kw-2\">*mut </span>u32;\n\n    Vec::from_raw_parts_in(ptr, len, cap, alloc)\n};\n<span class=\"macro\">assert_eq!</span>(rebuilt, [<span class=\"number\">4294967295</span>, <span class=\"number\">0</span>, <span class=\"number\">1</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(allocator_api,+vec_into_raw_parts)%5D%0A%0Afn+main()+%7B%0Ause+std::alloc::System;%0A%0Alet+mut+v:+Vec%3Ci32,+System%3E+=+Vec::new_in(System);%0Av.push(-1);%0Av.push(0);%0Av.push(1);%0A%0Alet+(ptr,+len,+cap,+alloc)+=+v.into_raw_parts_with_alloc();%0A%0Alet+rebuilt+=+unsafe+%7B%0A++++//+We+can+now+make+changes+to+the+components,+such+as%0A++++//+transmuting+the+raw+pointer+to+a+compatible+type.%0A++++let+ptr+=+ptr+as+*mut+u32;%0A%0A++++Vec::from_raw_parts_in(ptr,+len,+cap,+alloc)%0A%7D;%0Aassert_eq!(rebuilt,+%5B4294967295,+0,+1%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.capacity\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#906\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.capacity\" class=\"fn\">capacity</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section></summary><div class=\"docblock\"><p>Returns the total number of elements the vector can hold without\nreallocating.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec: Vec&lt;i32&gt; = Vec::with_capacity(<span class=\"number\">10</span>);\nvec.push(<span class=\"number\">42</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">10</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec:+Vec%3Ci32%3E+=+Vec::with_capacity(10);%0Avec.push(42);%0Aassert!(vec.capacity()+%3E=+10);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#910\">source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.reserve\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#930\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.reserve\" class=\"fn\">reserve</a>(&amp;mut self, additional: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Reserves capacity for at least <code>additional</code> more elements to be inserted\nin the given <code>Vec&lt;T&gt;</code>. The collection may reserve more space to\nspeculatively avoid frequent reallocations. After calling <code>reserve</code>,\ncapacity will be greater than or equal to <code>self.len() + additional</code>.\nDoes nothing if capacity is already sufficient.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the new capacity exceeds <code>isize::MAX</code> bytes.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>];\nvec.reserve(<span class=\"number\">10</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">11</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1%5D;%0Avec.reserve(10);%0Aassert!(vec.capacity()+%3E=+11);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reserve_exact\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#960\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.reserve_exact\" class=\"fn\">reserve_exact</a>(&amp;mut self, additional: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Reserves the minimum capacity for at least <code>additional</code> more elements to\nbe inserted in the given <code>Vec&lt;T&gt;</code>. Unlike <a href=\"alloc/vec/struct.Vec.html#method.reserve\" title=\"method alloc::vec::Vec::reserve\"><code>reserve</code></a>, this will not\ndeliberately over-allocate to speculatively avoid frequent allocations.\nAfter calling <code>reserve_exact</code>, capacity will be greater than or equal to\n<code>self.len() + additional</code>. Does nothing if the capacity is already\nsufficient.</p>\n<p>Note that the allocator may give the collection more space than it\nrequests. Therefore, capacity can not be relied upon to be precisely\nminimal. Prefer <a href=\"alloc/vec/struct.Vec.html#method.reserve\" title=\"method alloc::vec::Vec::reserve\"><code>reserve</code></a> if future insertions are expected.</p>\n<h5 id=\"panics-1\"><a href=\"#panics-1\">Panics</a></h5>\n<p>Panics if the new capacity exceeds <code>isize::MAX</code> bytes.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>];\nvec.reserve_exact(<span class=\"number\">10</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">11</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1%5D;%0Avec.reserve_exact(10);%0Aassert!(vec.capacity()+%3E=+11);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_reserve\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.57.0\">1.57.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#997\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.try_reserve\" class=\"fn\">try_reserve</a>(&amp;mut self, additional: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"primitive.unit.html\">()</a>, <a class=\"struct\" href=\"std/collections/struct.TryReserveError.html\" title=\"struct std::collections::TryReserveError\">TryReserveError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Tries to reserve capacity for at least <code>additional</code> more elements to be inserted\nin the given <code>Vec&lt;T&gt;</code>. The collection may reserve more space to speculatively avoid\nfrequent reallocations. After calling <code>try_reserve</code>, capacity will be\ngreater than or equal to <code>self.len() + additional</code> if it returns\n<code>Ok(())</code>. Does nothing if capacity is already sufficient. This method\npreserves the contents even if an error occurs.</p>\n<h5 id=\"errors\"><a href=\"#errors\">Errors</a></h5>\n<p>If the capacity overflows, or the allocator reports a failure, then an error\nis returned.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::collections::TryReserveError;\n\n<span class=\"kw\">fn </span>process_data(data: <span class=\"kw-2\">&amp;</span>[u32]) -&gt; <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, TryReserveError&gt; {\n    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>output = Vec::new();\n\n    <span class=\"comment\">// Pre-reserve the memory, exiting if we can&#39;t\n    </span>output.try_reserve(data.len())<span class=\"question-mark\">?</span>;\n\n    <span class=\"comment\">// Now we know this can&#39;t OOM in the middle of our complex work\n    </span>output.extend(data.iter().map(|<span class=\"kw-2\">&amp;</span>val| {\n        val * <span class=\"number\">2 </span>+ <span class=\"number\">5 </span><span class=\"comment\">// very complicated\n    </span>}));\n\n    <span class=\"prelude-val\">Ok</span>(output)\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::collections::TryReserveError;%0A%0Afn+process_data(data:+%26%5Bu32%5D)+-%3E+Result%3CVec%3Cu32%3E,+TryReserveError%3E+%7B%0A++++let+mut+output+=+Vec::new();%0A%0A++++//+Pre-reserve+the+memory,+exiting+if+we+can't%0A++++output.try_reserve(data.len())?;%0A%0A++++//+Now+we+know+this+can't+OOM+in+the+middle+of+our+complex+work%0A++++output.extend(data.iter().map(%7C%26val%7C+%7B%0A++++++++val+*+2+%2B+5+//+very+complicated%0A++++%7D));%0A%0A++++Ok(output)%0A%7D%0Aprocess_data(%26%5B1,+2,+3%5D).expect(%22why+is+the+test+harness+OOMing+on+12+bytes?%22);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_reserve_exact\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.57.0\">1.57.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#1040\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.try_reserve_exact\" class=\"fn\">try_reserve_exact</a>(\n    &amp;mut self,\n    additional: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>\n) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"primitive.unit.html\">()</a>, <a class=\"struct\" href=\"std/collections/struct.TryReserveError.html\" title=\"struct std::collections::TryReserveError\">TryReserveError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Tries to reserve the minimum capacity for at least <code>additional</code>\nelements to be inserted in the given <code>Vec&lt;T&gt;</code>. Unlike <a href=\"alloc/vec/struct.Vec.html#method.try_reserve\" title=\"method alloc::vec::Vec::try_reserve\"><code>try_reserve</code></a>,\nthis will not deliberately over-allocate to speculatively avoid frequent\nallocations. After calling <code>try_reserve_exact</code>, capacity will be greater\nthan or equal to <code>self.len() + additional</code> if it returns <code>Ok(())</code>.\nDoes nothing if the capacity is already sufficient.</p>\n<p>Note that the allocator may give the collection more space than it\nrequests. Therefore, capacity can not be relied upon to be precisely\nminimal. Prefer <a href=\"alloc/vec/struct.Vec.html#method.try_reserve\" title=\"method alloc::vec::Vec::try_reserve\"><code>try_reserve</code></a> if future insertions are expected.</p>\n<h5 id=\"errors-1\"><a href=\"#errors-1\">Errors</a></h5>\n<p>If the capacity overflows, or the allocator reports a failure, then an error\nis returned.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::collections::TryReserveError;\n\n<span class=\"kw\">fn </span>process_data(data: <span class=\"kw-2\">&amp;</span>[u32]) -&gt; <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;u32&gt;, TryReserveError&gt; {\n    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>output = Vec::new();\n\n    <span class=\"comment\">// Pre-reserve the memory, exiting if we can&#39;t\n    </span>output.try_reserve_exact(data.len())<span class=\"question-mark\">?</span>;\n\n    <span class=\"comment\">// Now we know this can&#39;t OOM in the middle of our complex work\n    </span>output.extend(data.iter().map(|<span class=\"kw-2\">&amp;</span>val| {\n        val * <span class=\"number\">2 </span>+ <span class=\"number\">5 </span><span class=\"comment\">// very complicated\n    </span>}));\n\n    <span class=\"prelude-val\">Ok</span>(output)\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::collections::TryReserveError;%0A%0Afn+process_data(data:+%26%5Bu32%5D)+-%3E+Result%3CVec%3Cu32%3E,+TryReserveError%3E+%7B%0A++++let+mut+output+=+Vec::new();%0A%0A++++//+Pre-reserve+the+memory,+exiting+if+we+can't%0A++++output.try_reserve_exact(data.len())?;%0A%0A++++//+Now+we+know+this+can't+OOM+in+the+middle+of+our+complex+work%0A++++output.extend(data.iter().map(%7C%26val%7C+%7B%0A++++++++val+*+2+%2B+5+//+very+complicated%0A++++%7D));%0A%0A++++Ok(output)%0A%7D%0Aprocess_data(%26%5B1,+2,+3%5D).expect(%22why+is+the+test+harness+OOMing+on+12+bytes?%22);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shrink_to_fit\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1060\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.shrink_to_fit\" class=\"fn\">shrink_to_fit</a>(&amp;mut self)</h4></section></summary><div class=\"docblock\"><p>Shrinks the capacity of the vector as much as possible.</p>\n<p>It will drop down as close as possible to the length but the allocator\nmay still inform the vector that there is space for a few more elements.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = Vec::with_capacity(<span class=\"number\">10</span>);\nvec.extend([<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">10</span>);\nvec.shrink_to_fit();\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+Vec::with_capacity(10);%0Avec.extend(%5B1,+2,+3%5D);%0Aassert!(vec.capacity()+%3E=+10);%0Avec.shrink_to_fit();%0Aassert!(vec.capacity()+%3E=+3);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.shrink_to\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.56.0\">1.56.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#1089\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.shrink_to\" class=\"fn\">shrink_to</a>(&amp;mut self, min_capacity: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Shrinks the capacity of the vector with a lower bound.</p>\n<p>The capacity will remain at least as large as both the length\nand the supplied value.</p>\n<p>If the current capacity is less than the lower limit, this is a no-op.</p>\n<h5 id=\"examples-5\"><a href=\"#examples-5\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = Vec::with_capacity(<span class=\"number\">10</span>);\nvec.extend([<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">10</span>);\nvec.shrink_to(<span class=\"number\">4</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">4</span>);\nvec.shrink_to(<span class=\"number\">0</span>);\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+Vec::with_capacity(10);%0Avec.extend(%5B1,+2,+3%5D);%0Aassert!(vec.capacity()+%3E=+10);%0Avec.shrink_to(4);%0Aassert!(vec.capacity()+%3E=+4);%0Avec.shrink_to(0);%0Aassert!(vec.capacity()+%3E=+3);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_boxed_slice\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1122\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.into_boxed_slice\" class=\"fn\">into_boxed_slice</a>(self) -&gt; <a class=\"struct\" href=\"std/boxed/struct.Box.html\" title=\"struct std::boxed::Box\">Box</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>, A&gt;</h4></section></summary><div class=\"docblock\"><p>Converts the vector into <a href=\"std/boxed/struct.Box.html\" title=\"struct std::boxed::Box\"><code>Box&lt;[T]&gt;</code></a>.</p>\n<p>If the vector has excess capacity, its items will be moved into a\nnewly-allocated buffer with exactly the right capacity.</p>\n<h5 id=\"examples-6\"><a href=\"#examples-6\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n\n<span class=\"kw\">let </span>slice = v.into_boxed_slice();</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+v+=+vec!%5B1,+2,+3%5D;%0A%0Alet+slice+=+v.into_boxed_slice();%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Any excess capacity is removed:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = Vec::with_capacity(<span class=\"number\">10</span>);\nvec.extend([<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n\n<span class=\"macro\">assert!</span>(vec.capacity() &gt;= <span class=\"number\">10</span>);\n<span class=\"kw\">let </span>slice = vec.into_boxed_slice();\n<span class=\"macro\">assert_eq!</span>(slice.into_vec().capacity(), <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+Vec::with_capacity(10);%0Avec.extend(%5B1,+2,+3%5D);%0A%0Aassert!(vec.capacity()+%3E=+10);%0Alet+slice+=+vec.into_boxed_slice();%0Aassert_eq!(slice.into_vec().capacity(),+3);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1180\">source</a><a href=\"#impl-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.truncate\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1224\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.truncate\" class=\"fn\">truncate</a>(&amp;mut self, len: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Shortens the vector, keeping the first <code>len</code> elements and dropping\nthe rest.</p>\n<p>If <code>len</code> is greater or equal to the vector’s current length, this has\nno effect.</p>\n<p>The <a href=\"alloc/vec/struct.Vec.html#method.drain\" title=\"method alloc::vec::Vec::drain\"><code>drain</code></a> method can emulate <code>truncate</code>, but causes the excess\nelements to be returned instead of dropped.</p>\n<p>Note that this method has no effect on the allocated capacity\nof the vector.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>Truncating a five element vector to two elements:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>];\nvec.truncate(<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3,+4,+5%5D;%0Avec.truncate(2);%0Aassert_eq!(vec,+%5B1,+2%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n<p>No truncation occurs when <code>len</code> is greater than the vector’s current\nlength:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\nvec.truncate(<span class=\"number\">8</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3%5D;%0Avec.truncate(8);%0Aassert_eq!(vec,+%5B1,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Truncating when <code>len == 0</code> is equivalent to calling the <a href=\"alloc/vec/struct.Vec.html#method.clear\" title=\"method alloc::vec::Vec::clear\"><code>clear</code></a>\nmethod.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\nvec.truncate(<span class=\"number\">0</span>);\n<span class=\"macro\">assert_eq!</span>(vec, []);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3%5D;%0Avec.truncate(0);%0Aassert_eq!(vec,+%5B%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_slice\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.7.0\">1.7.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#1259\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.as_slice\" class=\"fn\">as_slice</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class=\"docblock\"><p>Extracts a slice containing the entire vector.</p>\n<p>Equivalent to <code>&amp;s[..]</code>.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::io::{<span class=\"self\">self</span>, Write};\n<span class=\"kw\">let </span>buffer = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">5</span>, <span class=\"number\">8</span>];\nio::sink().write(buffer.as_slice()).unwrap();</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::io::%7Bself,+Write%7D;%0Alet+buffer+=+vec!%5B1,+2,+3,+5,+8%5D;%0Aio::sink().write(buffer.as_slice()).unwrap();%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut_slice\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.7.0\">1.7.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#1276\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.as_mut_slice\" class=\"fn\">as_mut_slice</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class=\"docblock\"><p>Extracts a mutable slice of the entire vector.</p>\n<p>Equivalent to <code>&amp;mut s[..]</code>.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::io::{<span class=\"self\">self</span>, Read};\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>buffer = <span class=\"macro\">vec!</span>[<span class=\"number\">0</span>; <span class=\"number\">3</span>];\nio::repeat(<span class=\"number\">0b101</span>).read_exact(buffer.as_mut_slice()).unwrap();</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::io::%7Bself,+Read%7D;%0Alet+mut+buffer+=+vec!%5B0;+3%5D;%0Aio::repeat(0b101).read_exact(buffer.as_mut_slice()).unwrap();%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ptr\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.37.0\">1.37.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#1334\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.as_ptr\" class=\"fn\">as_ptr</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*const T</a></h4></section></summary><div class=\"docblock\"><p>Returns a raw pointer to the vector’s buffer, or a dangling raw pointer\nvalid for zero sized reads if the vector didn’t allocate.</p>\n<p>The caller must ensure that the vector outlives the pointer this\nfunction returns, or else it will end up pointing to garbage.\nModifying the vector may cause its buffer to be reallocated,\nwhich would also make any pointers to it invalid.</p>\n<p>The caller must also ensure that the memory the pointer (non-transitively) points to\nis never written to (except inside an <code>UnsafeCell</code>) using this pointer or any pointer\nderived from it. If you need to mutate the contents of the slice, use <a href=\"alloc/vec/struct.Vec.html#method.as_mut_ptr\" title=\"method alloc::vec::Vec::as_mut_ptr\"><code>as_mut_ptr</code></a>.</p>\n<p>This method guarantees that for the purpose of the aliasing model, this method\ndoes not materialize a reference to the underlying slice, and thus the returned pointer\nwill remain valid when mixed with other calls to <a href=\"alloc/vec/struct.Vec.html#method.as_ptr\" title=\"method alloc::vec::Vec::as_ptr\"><code>as_ptr</code></a> and <a href=\"alloc/vec/struct.Vec.html#method.as_mut_ptr\" title=\"method alloc::vec::Vec::as_mut_ptr\"><code>as_mut_ptr</code></a>.\nNote that calling other methods that materialize mutable references to the slice,\nor mutable references to specific elements you are planning on accessing through this pointer,\nas well as writing to those elements, may still invalidate this pointer.\nSee the second example below for how this guarantee can be used.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">4</span>];\n<span class=\"kw\">let </span>x_ptr = x.as_ptr();\n\n<span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">for </span>i <span class=\"kw\">in </span><span class=\"number\">0</span>..x.len() {\n        <span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">*</span>x_ptr.add(i), <span class=\"number\">1 </span>&lt;&lt; i);\n    }\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x+=+vec!%5B1,+2,+4%5D;%0Alet+x_ptr+=+x.as_ptr();%0A%0Aunsafe+%7B%0A++++for+i+in+0..x.len()+%7B%0A++++++++assert_eq!(*x_ptr.add(i),+1+%3C%3C+i);%0A++++%7D%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Due to the aliasing guarantee, the following code is legal:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>];\n    <span class=\"kw\">let </span>ptr1 = v.as_ptr();\n    <span class=\"kw\">let _ </span>= ptr1.read();\n    <span class=\"kw\">let </span>ptr2 = v.as_mut_ptr().offset(<span class=\"number\">2</span>);\n    ptr2.write(<span class=\"number\">2</span>);\n    <span class=\"comment\">// Notably, the write to `ptr2` did *not* invalidate `ptr1`\n    // because it mutated a different element:\n    </span><span class=\"kw\">let _ </span>= ptr1.read();\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aunsafe+%7B%0A++++let+mut+v+=+vec!%5B0,+1,+2%5D;%0A++++let+ptr1+=+v.as_ptr();%0A++++let+_+=+ptr1.read();%0A++++let+ptr2+=+v.as_mut_ptr().offset(2);%0A++++ptr2.write(2);%0A++++//+Notably,+the+write+to+%60ptr2%60+did+*not*+invalidate+%60ptr1%60%0A++++//+because+it+mutated+a+different+element:%0A++++let+_+=+ptr1.read();%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut_ptr\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.37.0\">1.37.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#1394\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.as_mut_ptr\" class=\"fn\">as_mut_ptr</a>(&amp;mut self) -&gt; <a class=\"primitive\" href=\"primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Returns an unsafe mutable pointer to the vector’s buffer, or a dangling\nraw pointer valid for zero sized reads if the vector didn’t allocate.</p>\n<p>The caller must ensure that the vector outlives the pointer this\nfunction returns, or else it will end up pointing to garbage.\nModifying the vector may cause its buffer to be reallocated,\nwhich would also make any pointers to it invalid.</p>\n<p>This method guarantees that for the purpose of the aliasing model, this method\ndoes not materialize a reference to the underlying slice, and thus the returned pointer\nwill remain valid when mixed with other calls to <a href=\"alloc/vec/struct.Vec.html#method.as_ptr\" title=\"method alloc::vec::Vec::as_ptr\"><code>as_ptr</code></a> and <a href=\"alloc/vec/struct.Vec.html#method.as_mut_ptr\" title=\"method alloc::vec::Vec::as_mut_ptr\"><code>as_mut_ptr</code></a>.\nNote that calling other methods that materialize references to the slice,\nor references to specific elements you are planning on accessing through this pointer,\nmay still invalidate this pointer.\nSee the second example below for how this guarantee can be used.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"comment\">// Allocate vector big enough for 4 elements.\n</span><span class=\"kw\">let </span>size = <span class=\"number\">4</span>;\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>x: Vec&lt;i32&gt; = Vec::with_capacity(size);\n<span class=\"kw\">let </span>x_ptr = x.as_mut_ptr();\n\n<span class=\"comment\">// Initialize elements via raw pointer writes, then set length.\n</span><span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">for </span>i <span class=\"kw\">in </span><span class=\"number\">0</span>..size {\n        <span class=\"kw-2\">*</span>x_ptr.add(i) = i <span class=\"kw\">as </span>i32;\n    }\n    x.set_len(size);\n}\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;*</span>x, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A//+Allocate+vector+big+enough+for+4+elements.%0Afn+main()+%7B%0Alet+size+=+4;%0Alet+mut+x:+Vec%3Ci32%3E+=+Vec::with_capacity(size);%0Alet+x_ptr+=+x.as_mut_ptr();%0A%0A//+Initialize+elements+via+raw+pointer+writes,+then+set+length.%0Aunsafe+%7B%0A++++for+i+in+0..size+%7B%0A++++++++*x_ptr.add(i)+=+i+as+i32;%0A++++%7D%0A++++x.set_len(size);%0A%7D%0Aassert_eq!(%26*x,+%26%5B0,+1,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Due to the aliasing guarantee, the following code is legal:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">0</span>];\n    <span class=\"kw\">let </span>ptr1 = v.as_mut_ptr();\n    ptr1.write(<span class=\"number\">1</span>);\n    <span class=\"kw\">let </span>ptr2 = v.as_mut_ptr();\n    ptr2.write(<span class=\"number\">2</span>);\n    <span class=\"comment\">// Notably, the write to `ptr2` did *not* invalidate `ptr1`:\n    </span>ptr1.write(<span class=\"number\">3</span>);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aunsafe+%7B%0A++++let+mut+v+=+vec!%5B0%5D;%0A++++let+ptr1+=+v.as_mut_ptr();%0A++++ptr1.write(1);%0A++++let+ptr2+=+v.as_mut_ptr();%0A++++ptr2.write(2);%0A++++//+Notably,+the+write+to+%60ptr2%60+did+*not*+invalidate+%60ptr1%60:%0A++++ptr1.write(3);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.allocator\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1403\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.allocator\" class=\"fn\">allocator</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.reference.html\">&amp;A</a></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>allocator_api</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/32838\">#32838</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns a reference to the underlying allocator.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.set_len\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1487\">source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"alloc/vec/struct.Vec.html#tymethod.set_len\" class=\"fn\">set_len</a>(&amp;mut self, new_len: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Forces the length of the vector to <code>new_len</code>.</p>\n<p>This is a low-level operation that maintains none of the normal\ninvariants of the type. Normally changing the length of a vector\nis done using one of the safe operations instead, such as\n<a href=\"alloc/vec/struct.Vec.html#method.truncate\" title=\"method alloc::vec::Vec::truncate\"><code>truncate</code></a>, <a href=\"alloc/vec/struct.Vec.html#method.resize\" title=\"method alloc::vec::Vec::resize\"><code>resize</code></a>, <a href=\"std/iter/trait.Extend.html#tymethod.extend\" title=\"method std::iter::Extend::extend\"><code>extend</code></a>, or <a href=\"alloc/vec/struct.Vec.html#method.clear\" title=\"method alloc::vec::Vec::clear\"><code>clear</code></a>.</p>\n<h5 id=\"safety\"><a href=\"#safety\">Safety</a></h5>\n<ul>\n<li><code>new_len</code> must be less than or equal to <a href=\"alloc/vec/struct.Vec.html#method.capacity\" title=\"method alloc::vec::Vec::capacity\"><code>capacity()</code></a>.</li>\n<li>The elements at <code>old_len..new_len</code> must be initialized.</li>\n</ul>\n<h5 id=\"examples-5\"><a href=\"#examples-5\">Examples</a></h5>\n<p>This method can be useful for situations in which the vector\nis serving as a buffer for other code, particularly over FFI:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">pub fn </span>get_dictionary(<span class=\"kw-2\">&amp;</span><span class=\"self\">self</span>) -&gt; <span class=\"prelude-ty\">Option</span>&lt;Vec&lt;u8&gt;&gt; {\n    <span class=\"comment\">// Per the FFI method&#39;s docs, &quot;32768 bytes is always enough&quot;.\n    </span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>dict = Vec::with_capacity(<span class=\"number\">32_768</span>);\n    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>dict_length = <span class=\"number\">0</span>;\n    <span class=\"comment\">// SAFETY: When `deflateGetDictionary` returns `Z_OK`, it holds that:\n    // 1. `dict_length` elements were initialized.\n    // 2. `dict_length` &lt;= the capacity (32_768)\n    // which makes `set_len` safe to call.\n    </span><span class=\"kw\">unsafe </span>{\n        <span class=\"comment\">// Make the FFI call...\n        </span><span class=\"kw\">let </span>r = deflateGetDictionary(<span class=\"self\">self</span>.strm, dict.as_mut_ptr(), <span class=\"kw-2\">&amp;mut </span>dict_length);\n        <span class=\"kw\">if </span>r == Z_OK {\n            <span class=\"comment\">// ...and update the length to what was initialized.\n            </span>dict.set_len(dict_length);\n            <span class=\"prelude-val\">Some</span>(dict)\n        } <span class=\"kw\">else </span>{\n            <span class=\"prelude-val\">None\n        </span>}\n    }\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Ballow(dead_code)%5D%0A//+This+is+just+a+minimal+skeleton+for+the+doc+example;%0A//+don't+use+this+as+a+starting+point+for+a+real+library.%0Afn+main()+%7B%0Apub+struct+StreamWrapper+%7B+strm:+*mut+std::ffi::c_void+%7D%0Aconst+Z_OK:+i32+=+0;%0Aextern+%22C%22+%7B%0A++++fn+deflateGetDictionary(%0A++++++++strm:+*mut+std::ffi::c_void,%0A++++++++dictionary:+*mut+u8,%0A++++++++dictLength:+*mut+usize,%0A++++)+-%3E+i32;%0A%7D%0Aimpl+StreamWrapper+%7B%0Apub+fn+get_dictionary(%26self)+-%3E+Option%3CVec%3Cu8%3E%3E+%7B%0A++++//+Per+the+FFI+method's+docs,+%2232768+bytes+is+always+enough%22.%0A++++let+mut+dict+=+Vec::with_capacity(32_768);%0A++++let+mut+dict_length+=+0;%0A++++//+SAFETY:+When+%60deflateGetDictionary%60+returns+%60Z_OK%60,+it+holds+that:%0A++++//+1.+%60dict_length%60+elements+were+initialized.%0A++++//+2.+%60dict_length%60+%3C=+the+capacity+(32_768)%0A++++//+which+makes+%60set_len%60+safe+to+call.%0A++++unsafe+%7B%0A++++++++//+Make+the+FFI+call...%0A++++++++let+r+=+deflateGetDictionary(self.strm,+dict.as_mut_ptr(),+%26mut+dict_length);%0A++++++++if+r+==+Z_OK+%7B%0A++++++++++++//+...and+update+the+length+to+what+was+initialized.%0A++++++++++++dict.set_len(dict_length);%0A++++++++++++Some(dict)%0A++++++++%7D+else+%7B%0A++++++++++++None%0A++++++++%7D%0A++++%7D%0A%7D%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n<p>While the following example is sound, there is a memory leak since\nthe inner vectors were not freed prior to the <code>set_len</code> call:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>],\n                   <span class=\"macro\">vec!</span>[<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">0</span>],\n                   <span class=\"macro\">vec!</span>[<span class=\"number\">0</span>, <span class=\"number\">0</span>, <span class=\"number\">1</span>]];\n<span class=\"comment\">// SAFETY:\n// 1. `old_len..0` is empty so no elements need to be initialized.\n// 2. `0 &lt;= capacity` always holds whatever `capacity` is.\n</span><span class=\"kw\">unsafe </span>{\n    vec.set_len(<span class=\"number\">0</span>);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5Bvec!%5B1,+0,+0%5D,%0A+++++++++++++++++++vec!%5B0,+1,+0%5D,%0A+++++++++++++++++++vec!%5B0,+0,+1%5D%5D;%0A//+SAFETY:%0A//+1.+%60old_len..0%60+is+empty+so+no+elements+need+to+be+initialized.%0A//+2.+%600+%3C=+capacity%60+always+holds+whatever+%60capacity%60+is.%0Aunsafe+%7B%0A++++vec.set_len(0);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Normally, here, one would use <a href=\"alloc/vec/struct.Vec.html#method.clear\" title=\"method alloc::vec::Vec::clear\"><code>clear</code></a> instead to correctly drop\nthe contents and thus not leak memory.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.swap_remove\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1519\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.swap_remove\" class=\"fn\">swap_remove</a>(&amp;mut self, index: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Removes an element from the vector and returns it.</p>\n<p>The removed element is replaced by the last element of the vector.</p>\n<p>This does not preserve ordering, but is <em>O</em>(1).\nIf you need to preserve the element order, use <a href=\"alloc/vec/struct.Vec.html#method.remove\" title=\"method alloc::vec::Vec::remove\"><code>remove</code></a> instead.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if <code>index</code> is out of bounds.</p>\n<h5 id=\"examples-6\"><a href=\"#examples-6\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">vec!</span>[<span class=\"string\">&quot;foo&quot;</span>, <span class=\"string\">&quot;bar&quot;</span>, <span class=\"string\">&quot;baz&quot;</span>, <span class=\"string\">&quot;qux&quot;</span>];\n\n<span class=\"macro\">assert_eq!</span>(v.swap_remove(<span class=\"number\">1</span>), <span class=\"string\">&quot;bar&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"string\">&quot;foo&quot;</span>, <span class=\"string\">&quot;qux&quot;</span>, <span class=\"string\">&quot;baz&quot;</span>]);\n\n<span class=\"macro\">assert_eq!</span>(v.swap_remove(<span class=\"number\">0</span>), <span class=\"string\">&quot;foo&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"string\">&quot;baz&quot;</span>, <span class=\"string\">&quot;qux&quot;</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+v+=+vec!%5B%22foo%22,+%22bar%22,+%22baz%22,+%22qux%22%5D;%0A%0Aassert_eq!(v.swap_remove(1),+%22bar%22);%0Aassert_eq!(v,+%5B%22foo%22,+%22qux%22,+%22baz%22%5D);%0A%0Aassert_eq!(v.swap_remove(0),+%22foo%22);%0Aassert_eq!(v,+%5B%22baz%22,+%22qux%22%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1543\">source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.insert\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1562\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.insert\" class=\"fn\">insert</a>(&amp;mut self, index: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, element: T)</h4></section></summary><div class=\"docblock\"><p>Inserts an element at position <code>index</code> within the vector, shifting all\nelements after it to the right.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if <code>index &gt; len</code>.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\nvec.insert(<span class=\"number\">1</span>, <span class=\"number\">4</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">4</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\nvec.insert(<span class=\"number\">4</span>, <span class=\"number\">5</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">4</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">5</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3%5D;%0Avec.insert(1,+4);%0Aassert_eq!(vec,+%5B1,+4,+2,+3%5D);%0Avec.insert(4,+5);%0Aassert_eq!(vec,+%5B1,+4,+2,+3,+5%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1643\">source</a><a href=\"#impl-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.remove\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1669\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.remove\" class=\"fn\">remove</a>(&amp;mut self, index: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Removes and returns the element at position <code>index</code> within the vector,\nshifting all elements after it to the left.</p>\n<p>Note: Because this shifts over the remaining elements, it has a\nworst-case performance of <em>O</em>(<em>n</em>). If you don’t need the order of elements\nto be preserved, use <a href=\"alloc/vec/struct.Vec.html#method.swap_remove\" title=\"method alloc::vec::Vec::swap_remove\"><code>swap_remove</code></a> instead. If you’d like to remove\nelements from the beginning of the <code>Vec</code>, consider using\n<a href=\"std/collections/struct.VecDeque.html#method.pop_front\" title=\"method std::collections::VecDeque::pop_front\"><code>VecDeque::pop_front</code></a> instead.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if <code>index</code> is out of bounds.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"macro\">assert_eq!</span>(v.remove(<span class=\"number\">1</span>), <span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"number\">1</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+v+=+vec!%5B1,+2,+3%5D;%0Aassert_eq!(v.remove(1),+2);%0Aassert_eq!(v,+%5B1,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.retain\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1724-1726\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.retain\" class=\"fn\">retain</a>&lt;F&gt;(&amp;mut self, f: F)<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnMut.html\" title=\"trait std::ops::FnMut\">FnMut</a>(<a class=\"primitive\" href=\"primitive.reference.html\">&amp;T</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a>,</span></h4></section></summary><div class=\"docblock\"><p>Retains only the elements specified by the predicate.</p>\n<p>In other words, remove all elements <code>e</code> for which <code>f(&amp;e)</code> returns <code>false</code>.\nThis method operates in place, visiting each element exactly once in the\noriginal order, and preserves the order of the retained elements.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>];\nvec.retain(|<span class=\"kw-2\">&amp;</span>x| x % <span class=\"number\">2 </span>== <span class=\"number\">0</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">2</span>, <span class=\"number\">4</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3,+4%5D;%0Avec.retain(%7C%26x%7C+x+%25+2+==+0);%0Aassert_eq!(vec,+%5B2,+4%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n<p>Because the elements are visited exactly once in the original order,\nexternal state may be used to decide which elements to keep.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>];\n<span class=\"kw\">let </span>keep = [<span class=\"bool-val\">false</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">true</span>, <span class=\"bool-val\">false</span>, <span class=\"bool-val\">true</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>iter = keep.iter();\nvec.retain(|<span class=\"kw\">_</span>| <span class=\"kw-2\">*</span>iter.next().unwrap());\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">5</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3,+4,+5%5D;%0Alet+keep+=+%5Bfalse,+true,+true,+false,+true%5D;%0Alet+mut+iter+=+keep.iter();%0Avec.retain(%7C_%7C+*iter.next().unwrap());%0Aassert_eq!(vec,+%5B2,+3,+5%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.retain_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.61.0\">1.61.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#1750-1752\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.retain_mut\" class=\"fn\">retain_mut</a>&lt;F&gt;(&amp;mut self, f: F)<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnMut.html\" title=\"trait std::ops::FnMut\">FnMut</a>(<a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut T</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a>,</span></h4></section></summary><div class=\"docblock\"><p>Retains only the elements specified by the predicate, passing a mutable reference to it.</p>\n<p>In other words, remove all elements <code>e</code> such that <code>f(&amp;mut e)</code> returns <code>false</code>.\nThis method operates in place, visiting each element exactly once in the\noriginal order, and preserves the order of the retained elements.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>];\nvec.retain_mut(|x| <span class=\"kw\">if </span><span class=\"kw-2\">*</span>x &lt;= <span class=\"number\">3 </span>{\n    <span class=\"kw-2\">*</span>x += <span class=\"number\">1</span>;\n    <span class=\"bool-val\">true\n</span>} <span class=\"kw\">else </span>{\n    <span class=\"bool-val\">false\n</span>});\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3,+4%5D;%0Avec.retain_mut(%7Cx%7C+if+*x+%3C=+3+%7B%0A++++*x+%2B=+1;%0A++++true%0A%7D+else+%7B%0A++++false%0A%7D);%0Aassert_eq!(vec,+%5B2,+3,+4%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.dedup_by_key\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#1859-1862\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.dedup_by_key\" class=\"fn\">dedup_by_key</a>&lt;F, K&gt;(&amp;mut self, key: F)<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnMut.html\" title=\"trait std::ops::FnMut\">FnMut</a>(<a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut T</a>) -&gt; K,\n    K: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>,</span></h4></section></summary><div class=\"docblock\"><p>Removes all but the first of consecutive elements in the vector that resolve to the same\nkey.</p>\n<p>If the vector is sorted, this removes all duplicates.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">10</span>, <span class=\"number\">20</span>, <span class=\"number\">21</span>, <span class=\"number\">30</span>, <span class=\"number\">20</span>];\n\nvec.dedup_by_key(|i| <span class=\"kw-2\">*</span>i / <span class=\"number\">10</span>);\n\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">10</span>, <span class=\"number\">20</span>, <span class=\"number\">30</span>, <span class=\"number\">20</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B10,+20,+21,+30,+20%5D;%0A%0Avec.dedup_by_key(%7Ci%7C+*i+/+10);%0A%0Aassert_eq!(vec,+%5B10,+20,+30,+20%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.dedup_by\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.16.0\">1.16.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#1886-1888\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.dedup_by\" class=\"fn\">dedup_by</a>&lt;F&gt;(&amp;mut self, same_bucket: F)<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnMut.html\" title=\"trait std::ops::FnMut\">FnMut</a>(<a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut T</a>, <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut T</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a>,</span></h4></section></summary><div class=\"docblock\"><p>Removes all but the first of consecutive elements in the vector satisfying a given equality\nrelation.</p>\n<p>The <code>same_bucket</code> function is passed references to two elements from the vector and\nmust determine if the elements compare equal. The elements are passed in opposite order\nfrom their order in the slice, so if <code>same_bucket(a, b)</code> returns <code>true</code>, <code>a</code> is removed.</p>\n<p>If the vector is sorted, this removes all duplicates.</p>\n<h5 id=\"examples-4\"><a href=\"#examples-4\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"string\">&quot;foo&quot;</span>, <span class=\"string\">&quot;bar&quot;</span>, <span class=\"string\">&quot;Bar&quot;</span>, <span class=\"string\">&quot;baz&quot;</span>, <span class=\"string\">&quot;bar&quot;</span>];\n\nvec.dedup_by(|a, b| a.eq_ignore_ascii_case(b));\n\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"string\">&quot;foo&quot;</span>, <span class=\"string\">&quot;bar&quot;</span>, <span class=\"string\">&quot;baz&quot;</span>, <span class=\"string\">&quot;bar&quot;</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B%22foo%22,+%22bar%22,+%22Bar%22,+%22baz%22,+%22bar%22%5D;%0A%0Avec.dedup_by(%7Ca,+b%7C+a.eq_ignore_ascii_case(b));%0A%0Aassert_eq!(vec,+%5B%22foo%22,+%22bar%22,+%22baz%22,+%22bar%22%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1981\">source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.push\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#1998\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.push\" class=\"fn\">push</a>(&amp;mut self, value: T)</h4></section></summary><div class=\"docblock\"><p>Appends an element to the back of a collection.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the new capacity exceeds <code>isize::MAX</code> bytes.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>];\nvec.push(<span class=\"number\">3</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2%5D;%0Avec.push(3);%0Aassert_eq!(vec,+%5B1,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2033\">source</a><a href=\"#impl-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.push_within_capacity\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2067\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.push_within_capacity\" class=\"fn\">push_within_capacity</a>(&amp;mut self, value: T) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"primitive.unit.html\">()</a>, T&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>vec_push_within_capacity</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/100486\">#100486</a>)</span></div></span></summary><div class=\"docblock\"><p>Appends an element if there is sufficient spare capacity, otherwise an error is returned\nwith the element.</p>\n<p>Unlike <a href=\"alloc/vec/struct.Vec.html#method.push\" title=\"method alloc::vec::Vec::push\"><code>push</code></a> this method will not reallocate when there’s insufficient capacity.\nThe caller should use <a href=\"alloc/vec/struct.Vec.html#method.reserve\" title=\"method alloc::vec::Vec::reserve\"><code>reserve</code></a> or <a href=\"alloc/vec/struct.Vec.html#method.try_reserve\" title=\"method alloc::vec::Vec::try_reserve\"><code>try_reserve</code></a> to ensure that there is enough capacity.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>A manual, panic-free alternative to <a href=\"std/iter/trait.FromIterator.html\" title=\"trait std::iter::FromIterator\"><code>FromIterator</code></a>:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(vec_push_within_capacity)]\n\n</span><span class=\"kw\">use </span>std::collections::TryReserveError;\n<span class=\"kw\">fn </span>from_iter_fallible&lt;T&gt;(iter: <span class=\"kw\">impl </span>Iterator&lt;Item=T&gt;) -&gt; <span class=\"prelude-ty\">Result</span>&lt;Vec&lt;T&gt;, TryReserveError&gt; {\n    <span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = Vec::new();\n    <span class=\"kw\">for </span>value <span class=\"kw\">in </span>iter {\n        <span class=\"kw\">if let </span><span class=\"prelude-val\">Err</span>(value) = vec.push_within_capacity(value) {\n            vec.try_reserve(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>;\n            <span class=\"comment\">// this cannot fail, the previous line either returned or added at least 1 free slot\n            </span><span class=\"kw\">let _ </span>= vec.push_within_capacity(value);\n        }\n    }\n    <span class=\"prelude-val\">Ok</span>(vec)\n}\n<span class=\"macro\">assert_eq!</span>(from_iter_fallible(<span class=\"number\">0</span>..<span class=\"number\">100</span>), <span class=\"prelude-val\">Ok</span>(Vec::from_iter(<span class=\"number\">0</span>..<span class=\"number\">100</span>)));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(vec_push_within_capacity)%5D%0A%0Afn+main()+%7B%0Ause+std::collections::TryReserveError;%0Afn+from_iter_fallible%3CT%3E(iter:+impl+Iterator%3CItem=T%3E)+-%3E+Result%3CVec%3CT%3E,+TryReserveError%3E+%7B%0A++++let+mut+vec+=+Vec::new();%0A++++for+value+in+iter+%7B%0A++++++++if+let+Err(value)+=+vec.push_within_capacity(value)+%7B%0A++++++++++++vec.try_reserve(1)?;%0A++++++++++++//+this+cannot+fail,+the+previous+line+either+returned+or+added+at+least+1+free+slot%0A++++++++++++let+_+=+vec.push_within_capacity(value);%0A++++++++%7D%0A++++%7D%0A++++Ok(vec)%0A%7D%0Aassert_eq!(from_iter_fallible(0..100),+Ok(Vec::from_iter(0..100)));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.pop\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2096\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.pop\" class=\"fn\">pop</a>(&amp;mut self) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Removes the last element from a vector and returns it, or <a href=\"std/option/enum.Option.html#variant.None\" title=\"variant std::option::Option::None\"><code>None</code></a> if it\nis empty.</p>\n<p>If you’d like to pop the first element, consider using\n<a href=\"std/collections/struct.VecDeque.html#method.pop_front\" title=\"method std::collections::VecDeque::pop_front\"><code>VecDeque::pop_front</code></a> instead.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"macro\">assert_eq!</span>(vec.pop(), <span class=\"prelude-val\">Some</span>(<span class=\"number\">3</span>));\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3%5D;%0Aassert_eq!(vec.pop(),+Some(3));%0Aassert_eq!(vec,+%5B1,+2%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2108\">source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.append\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.4.0\">1.4.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#2127\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.append\" class=\"fn\">append</a>(&amp;mut self, other: &amp;mut <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;)</h4></section></summary><div class=\"docblock\"><p>Moves all the elements of <code>other</code> into <code>self</code>, leaving <code>other</code> empty.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the new capacity exceeds <code>isize::MAX</code> bytes.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec2 = <span class=\"macro\">vec!</span>[<span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>];\nvec.append(<span class=\"kw-2\">&amp;mut </span>vec2);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>]);\n<span class=\"macro\">assert_eq!</span>(vec2, []);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3%5D;%0Alet+mut+vec2+=+vec!%5B4,+5,+6%5D;%0Avec.append(%26mut+vec2);%0Aassert_eq!(vec,+%5B1,+2,+3,+4,+5,+6%5D);%0Aassert_eq!(vec2,+%5B%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2170\">source</a><a href=\"#impl-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.drain\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.6.0\">1.6.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#2202-2204\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.drain\" class=\"fn\">drain</a>&lt;R&gt;(&amp;mut self, range: R) -&gt; <a class=\"struct\" href=\"std/vec/struct.Drain.html\" title=\"struct std::vec::Drain\">Drain</a>&lt;'_, T, A, FH&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"Drain&lt;&#39;_, T, A, FH&gt;\">ⓘ</a><span class=\"where fmt-newline\">where\n    R: <a class=\"trait\" href=\"std/ops/trait.RangeBounds.html\" title=\"trait std::ops::RangeBounds\">RangeBounds</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Removes the specified range from the vector in bulk, returning all\nremoved elements as an iterator. If the iterator is dropped before\nbeing fully consumed, it drops the remaining removed elements.</p>\n<p>The returned iterator keeps a mutable borrow on the vector to optimize\nits implementation.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the starting point is greater than the end point or if\nthe end point is greater than the length of the vector.</p>\n<h5 id=\"leaking\"><a href=\"#leaking\">Leaking</a></h5>\n<p>If the returned iterator goes out of scope without being dropped (due to\n<a href=\"std/mem/fn.forget.html\" title=\"fn std::mem::forget\"><code>mem::forget</code></a>, for example), the vector may have lost and leaked\nelements arbitrarily, including elements outside the range.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>u: Vec&lt;<span class=\"kw\">_</span>&gt; = v.drain(<span class=\"number\">1</span>..).collect();\n<span class=\"macro\">assert_eq!</span>(v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>]);\n<span class=\"macro\">assert_eq!</span>(u, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n\n<span class=\"comment\">// A full range clears the vector, like `clear()` does\n</span>v.drain(..);\n<span class=\"macro\">assert_eq!</span>(v, <span class=\"kw-2\">&amp;</span>[]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+v+=+vec!%5B1,+2,+3%5D;%0Alet+u:+Vec%3C_%3E+=+v.drain(1..).collect();%0Aassert_eq!(v,+%26%5B1%5D);%0Aassert_eq!(u,+%26%5B2,+3%5D);%0A%0A//+A+full+range+clears+the+vector,+like+%60clear()%60+does%0Av.drain(..);%0Aassert_eq!(v,+%26%5B%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clear\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2248\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.clear\" class=\"fn\">clear</a>(&amp;mut self)</h4></section></summary><div class=\"docblock\"><p>Clears the vector, removing all values.</p>\n<p>Note that this method has no effect on the allocated capacity\nof the vector.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n\nv.clear();\n\n<span class=\"macro\">assert!</span>(v.is_empty());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+v+=+vec!%5B1,+2,+3%5D;%0A%0Av.clear();%0A%0Aassert!(v.is_empty());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.len\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2274\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.len\" class=\"fn\">len</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.usize.html\">usize</a></h4></section></summary><div class=\"docblock\"><p>Returns the number of elements in the vector, also referred to\nas its ‘length’.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>a = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"macro\">assert_eq!</span>(a.len(), <span class=\"number\">3</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+a+=+vec!%5B1,+2,+3%5D;%0Aassert_eq!(a.len(),+3);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_empty\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2290\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.is_empty\" class=\"fn\">is_empty</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the vector contains no elements.</p>\n<h5 id=\"examples-3\"><a href=\"#examples-3\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = Vec::new();\n<span class=\"macro\">assert!</span>(v.is_empty());\n\nv.push(<span class=\"number\">1</span>);\n<span class=\"macro\">assert!</span>(!v.is_empty());</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+v+=+Vec::new();%0Aassert!(v.is_empty());%0A%0Av.push(1);%0Aassert!(!v.is_empty());%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2294\">source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.split_off\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.4.0\">1.4.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#2317-2319\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.split_off\" class=\"fn\">split_off</a>(&amp;mut self, at: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,</span></h4></section></summary><div class=\"docblock\"><p>Splits the collection into two at the given index.</p>\n<p>Returns a newly allocated vector containing the elements in the range\n<code>[at, len)</code>. After the call, the original vector will be left containing\nthe elements <code>[0, at)</code> with its previous capacity unchanged.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if <code>at &gt; len</code>.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>vec2 = vec.split_off(<span class=\"number\">1</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>]);\n<span class=\"macro\">assert_eq!</span>(vec2, [<span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3%5D;%0Alet+vec2+=+vec.split_off(1);%0Aassert_eq!(vec,+%5B1%5D);%0Aassert_eq!(vec2,+%5B2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.resize_with\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.33.0\">1.33.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#2381-2383\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.resize_with\" class=\"fn\">resize_with</a>&lt;F&gt;(&amp;mut self, new_len: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, f: F)<span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnMut.html\" title=\"trait std::ops::FnMut\">FnMut</a>() -&gt; T,</span></h4></section></summary><div class=\"docblock\"><p>Resizes the <code>Vec</code> in-place so that <code>len</code> is equal to <code>new_len</code>.</p>\n<p>If <code>new_len</code> is greater than <code>len</code>, the <code>Vec</code> is extended by the\ndifference, with each additional slot filled with the result of\ncalling the closure <code>f</code>. The return values from <code>f</code> will end up\nin the <code>Vec</code> in the order they have been generated.</p>\n<p>If <code>new_len</code> is less than <code>len</code>, the <code>Vec</code> is simply truncated.</p>\n<p>This method uses a closure to create new values on every push. If\nyou’d rather <a href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\"><code>Clone</code></a> a given value, use <a href=\"alloc/vec/struct.Vec.html#method.resize\" title=\"method alloc::vec::Vec::resize\"><code>Vec::resize</code></a>. If you\nwant to use the <a href=\"std/default/trait.Default.html\" title=\"trait std::default::Default\"><code>Default</code></a> trait to generate values, you can\npass <a href=\"std/default/trait.Default.html#tymethod.default\" title=\"associated function std::default::Default::default\"><code>Default::default</code></a> as the second argument.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\nvec.resize_with(<span class=\"number\">5</span>, Default::default);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">0</span>, <span class=\"number\">0</span>]);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>p = <span class=\"number\">1</span>;\nvec.resize_with(<span class=\"number\">4</span>, || { p <span class=\"kw-2\">*</span>= <span class=\"number\">2</span>; p });\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">2</span>, <span class=\"number\">4</span>, <span class=\"number\">8</span>, <span class=\"number\">16</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+3%5D;%0Avec.resize_with(5,+Default::default);%0Aassert_eq!(vec,+%5B1,+2,+3,+0,+0%5D);%0A%0Alet+mut+vec+=+vec!%5B%5D;%0Alet+mut+p+=+1;%0Avec.resize_with(4,+%7C%7C+%7B+p+*=+2;+p+%7D);%0Aassert_eq!(vec,+%5B2,+4,+8,+16%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2449\">source</a><a href=\"#impl-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.leak\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.47.0\">1.47.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#2475-2477\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.leak\" class=\"fn\">leak</a>&lt;'a&gt;(self) -&gt; &amp;'a mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a><span class=\"where fmt-newline\">where\n    A: 'a,</span></h4></section></summary><div class=\"docblock\"><p>Consumes and leaks the <code>Vec</code>, returning a mutable reference to the contents,\n<code>&amp;'a mut [T]</code>. Note that the type <code>T</code> must outlive the chosen lifetime\n<code>'a</code>. If the type has only static references, or none at all, then this\nmay be chosen to be <code>'static</code>.</p>\n<p>As of Rust 1.57, this method does not reallocate or shrink the <code>Vec</code>,\nso the leaked allocation may include unused capacity that is not part\nof the returned slice.</p>\n<p>This function is mainly useful for data that lives for the remainder of\nthe program’s life. Dropping the returned reference will cause a memory\nleak.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>Simple usage:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"kw\">let </span>static_ref: <span class=\"kw-2\">&amp;</span><span class=\"lifetime\">&#39;static </span><span class=\"kw-2\">mut </span>[usize] = x.leak();\nstatic_ref[<span class=\"number\">0</span>] += <span class=\"number\">1</span>;\n<span class=\"macro\">assert_eq!</span>(static_ref, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">2</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+x+=+vec!%5B1,+2,+3%5D;%0Alet+static_ref:+%26'static+mut+%5Busize%5D+=+x.leak();%0Astatic_ref%5B0%5D+%2B=+1;%0Aassert_eq!(static_ref,+%26%5B2,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.spare_capacity_mut\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.60.0\">1.60.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#2513\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.spare_capacity_mut\" class=\"fn\">spare_capacity_mut</a>(&amp;mut self) -&gt; &amp;mut [<a class=\"union\" href=\"std/mem/union.MaybeUninit.html\" title=\"union std::mem::MaybeUninit\">MaybeUninit</a>&lt;T&gt;]</h4></section></summary><div class=\"docblock\"><p>Returns the remaining spare capacity of the vector as a slice of\n<code>MaybeUninit&lt;T&gt;</code>.</p>\n<p>The returned slice can be used to fill the vector with data (e.g. by\nreading from a file) before marking the data as initialized using the\n<a href=\"alloc/vec/struct.Vec.html#method.set_len\" title=\"method alloc::vec::Vec::set_len\"><code>set_len</code></a> method.</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"comment\">// Allocate vector big enough for 10 elements.\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = Vec::with_capacity(<span class=\"number\">10</span>);\n\n<span class=\"comment\">// Fill in the first 3 elements.\n</span><span class=\"kw\">let </span>uninit = v.spare_capacity_mut();\nuninit[<span class=\"number\">0</span>].write(<span class=\"number\">0</span>);\nuninit[<span class=\"number\">1</span>].write(<span class=\"number\">1</span>);\nuninit[<span class=\"number\">2</span>].write(<span class=\"number\">2</span>);\n\n<span class=\"comment\">// Mark the first 3 elements of the vector as being initialized.\n</span><span class=\"kw\">unsafe </span>{\n    v.set_len(<span class=\"number\">3</span>);\n}\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A//+Allocate+vector+big+enough+for+10+elements.%0Afn+main()+%7B%0Alet+mut+v+=+Vec::with_capacity(10);%0A%0A//+Fill+in+the+first+3+elements.%0Alet+uninit+=+v.spare_capacity_mut();%0Auninit%5B0%5D.write(0);%0Auninit%5B1%5D.write(1);%0Auninit%5B2%5D.write(2);%0A%0A//+Mark+the+first+3+elements+of+the+vector+as+being+initialized.%0Aunsafe+%7B%0A++++v.set_len(3);%0A%7D%0A%0Aassert_eq!(%26v,+%26%5B0,+1,+2%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.split_at_spare_mut\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2578\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.split_at_spare_mut\" class=\"fn\">split_at_spare_mut</a>(&amp;mut self) -&gt; (&amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>, &amp;mut [<a class=\"union\" href=\"std/mem/union.MaybeUninit.html\" title=\"union std::mem::MaybeUninit\">MaybeUninit</a>&lt;T&gt;])</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>vec_split_at_spare</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/81944\">#81944</a>)</span></div></span></summary><div class=\"docblock\"><p>Returns vector content as a slice of <code>T</code>, along with the remaining spare\ncapacity of the vector as a slice of <code>MaybeUninit&lt;T&gt;</code>.</p>\n<p>The returned spare capacity slice can be used to fill the vector with data\n(e.g. by reading from a file) before marking the data as initialized using\nthe <a href=\"alloc/vec/struct.Vec.html#method.set_len\" title=\"method alloc::vec::Vec::set_len\"><code>set_len</code></a> method.</p>\n<p>Note that this is a low-level API, which should be used with care for\noptimization purposes. If you need to append data to a <code>Vec</code>\nyou can use <a href=\"alloc/vec/struct.Vec.html#method.push\" title=\"method alloc::vec::Vec::push\"><code>push</code></a>, <a href=\"alloc/vec/struct.Vec.html#method.extend\" title=\"method alloc::vec::Vec::extend\"><code>extend</code></a>, <a href=\"alloc/vec/struct.Vec.html#method.extend_from_slice\" title=\"method alloc::vec::Vec::extend_from_slice\"><code>extend_from_slice</code></a>,\n<a href=\"alloc/vec/struct.Vec.html#method.extend_from_within\" title=\"method alloc::vec::Vec::extend_from_within\"><code>extend_from_within</code></a>, <a href=\"alloc/vec/struct.Vec.html#method.insert\" title=\"method alloc::vec::Vec::insert\"><code>insert</code></a>, <a href=\"alloc/vec/struct.Vec.html#method.append\" title=\"method alloc::vec::Vec::append\"><code>append</code></a>, <a href=\"alloc/vec/struct.Vec.html#method.resize\" title=\"method alloc::vec::Vec::resize\"><code>resize</code></a> or\n<a href=\"alloc/vec/struct.Vec.html#method.resize_with\" title=\"method alloc::vec::Vec::resize_with\"><code>resize_with</code></a>, depending on your exact needs.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(vec_split_at_spare)]\n\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>];\n\n<span class=\"comment\">// Reserve additional space big enough for 10 elements.\n</span>v.reserve(<span class=\"number\">10</span>);\n\n<span class=\"kw\">let </span>(init, uninit) = v.split_at_spare_mut();\n<span class=\"kw\">let </span>sum = init.iter().copied().sum::&lt;u32&gt;();\n\n<span class=\"comment\">// Fill in the next 4 elements.\n</span>uninit[<span class=\"number\">0</span>].write(sum);\nuninit[<span class=\"number\">1</span>].write(sum * <span class=\"number\">2</span>);\nuninit[<span class=\"number\">2</span>].write(sum * <span class=\"number\">3</span>);\nuninit[<span class=\"number\">3</span>].write(sum * <span class=\"number\">4</span>);\n\n<span class=\"comment\">// Mark the 4 elements of the vector as being initialized.\n</span><span class=\"kw\">unsafe </span>{\n    <span class=\"kw\">let </span>len = v.len();\n    v.set_len(len + <span class=\"number\">4</span>);\n}\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">4</span>, <span class=\"number\">8</span>, <span class=\"number\">12</span>, <span class=\"number\">16</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(vec_split_at_spare)%5D%0A%0Afn+main()+%7B%0Alet+mut+v+=+vec!%5B1,+1,+2%5D;%0A%0A//+Reserve+additional+space+big+enough+for+10+elements.%0Av.reserve(10);%0A%0Alet+(init,+uninit)+=+v.split_at_spare_mut();%0Alet+sum+=+init.iter().copied().sum::%3Cu32%3E();%0A%0A//+Fill+in+the+next+4+elements.%0Auninit%5B0%5D.write(sum);%0Auninit%5B1%5D.write(sum+*+2);%0Auninit%5B2%5D.write(sum+*+3);%0Auninit%5B3%5D.write(sum+*+4);%0A%0A//+Mark+the+4+elements+of+the+vector+as+being+initialized.%0Aunsafe+%7B%0A++++let+len+=+v.len();%0A++++v.set_len(len+%2B+4);%0A%7D%0A%0Aassert_eq!(%26v,+%26%5B1,+1,+2,+4,+8,+12,+16%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2612\">source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.resize\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.5.0\">1.5.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#2638\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.resize\" class=\"fn\">resize</a>(&amp;mut self, new_len: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>, value: T)</h4></section></summary><div class=\"docblock\"><p>Resizes the <code>Vec</code> in-place so that <code>len</code> is equal to <code>new_len</code>.</p>\n<p>If <code>new_len</code> is greater than <code>len</code>, the <code>Vec</code> is extended by the\ndifference, with each additional slot filled with <code>value</code>.\nIf <code>new_len</code> is less than <code>len</code>, the <code>Vec</code> is simply truncated.</p>\n<p>This method requires <code>T</code> to implement <a href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\"><code>Clone</code></a>,\nin order to be able to clone the passed value.\nIf you need more flexibility (or want to rely on <a href=\"std/default/trait.Default.html\" title=\"trait std::default::Default\"><code>Default</code></a> instead of\n<a href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\"><code>Clone</code></a>), use <a href=\"alloc/vec/struct.Vec.html#method.resize_with\" title=\"method alloc::vec::Vec::resize_with\"><code>Vec::resize_with</code></a>.\nIf you only need to resize to a smaller size, use <a href=\"alloc/vec/struct.Vec.html#method.truncate\" title=\"method alloc::vec::Vec::truncate\"><code>Vec::truncate</code></a>.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"string\">&quot;hello&quot;</span>];\nvec.resize(<span class=\"number\">3</span>, <span class=\"string\">&quot;world&quot;</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"string\">&quot;hello&quot;</span>, <span class=\"string\">&quot;world&quot;</span>, <span class=\"string\">&quot;world&quot;</span>]);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>];\nvec.resize(<span class=\"number\">2</span>, <span class=\"number\">0</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B%22hello%22%5D;%0Avec.resize(3,+%22world%22);%0Aassert_eq!(vec,+%5B%22hello%22,+%22world%22,+%22world%22%5D);%0A%0Alet+mut+vec+=+vec!%5B1,+2,+3,+4%5D;%0Avec.resize(2,+0);%0Aassert_eq!(vec,+%5B1,+2%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend_from_slice\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.6.0\">1.6.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#2669\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.extend_from_slice\" class=\"fn\">extend_from_slice</a>(&amp;mut self, other: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>)</h4></section></summary><div class=\"docblock\"><p>Clones and appends all elements in a slice to the <code>Vec</code>.</p>\n<p>Iterates over the slice <code>other</code>, clones each element, and then appends\nit to this <code>Vec</code>. The <code>other</code> slice is traversed in-order.</p>\n<p>Note that this function is same as <a href=\"alloc/vec/struct.Vec.html#method.extend\" title=\"method alloc::vec::Vec::extend\"><code>extend</code></a> except that it is\nspecialized to work with slices instead. If and when Rust gets\nspecialization this function will likely be deprecated (but still\navailable).</p>\n<h5 id=\"examples-1\"><a href=\"#examples-1\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>];\nvec.extend_from_slice(<span class=\"kw-2\">&amp;</span>[<span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1%5D;%0Avec.extend_from_slice(%26%5B2,+3,+4%5D);%0Aassert_eq!(vec,+%5B1,+2,+3,+4%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend_from_within\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.53.0\">1.53.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#2696-2698\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.extend_from_within\" class=\"fn\">extend_from_within</a>&lt;R&gt;(&amp;mut self, src: R)<span class=\"where fmt-newline\">where\n    R: <a class=\"trait\" href=\"std/ops/trait.RangeBounds.html\" title=\"trait std::ops::RangeBounds\">RangeBounds</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Copies elements from <code>src</code> range to the end of the vector.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the starting point is greater than the end point or if\nthe end point is greater than the length of the vector.</p>\n<h5 id=\"examples-2\"><a href=\"#examples-2\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>];\n\nvec.extend_from_within(<span class=\"number\">2</span>..);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);\n\nvec.extend_from_within(..<span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">0</span>, <span class=\"number\">1</span>]);\n\nvec.extend_from_within(<span class=\"number\">4</span>..<span class=\"number\">8</span>);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">4</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B0,+1,+2,+3,+4%5D;%0A%0Avec.extend_from_within(2..);%0Aassert_eq!(vec,+%5B0,+1,+2,+3,+4,+2,+3,+4%5D);%0A%0Avec.extend_from_within(..2);%0Aassert_eq!(vec,+%5B0,+1,+2,+3,+4,+2,+3,+4,+0,+1%5D);%0A%0Avec.extend_from_within(4..8);%0Aassert_eq!(vec,+%5B0,+1,+2,+3,+4,+2,+3,+4,+0,+1,+4,+2,+3,+4%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3C%5BT;+N%5D,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2750\">source</a><a href=\"#impl-Vec%3C%5BT;+N%5D,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;<a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_flattened\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2773\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.into_flattened\" class=\"fn\">into_flattened</a>(self) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;</h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>slice_flatten</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/95629\">#95629</a>)</span></div></span></summary><div class=\"docblock\"><p>Takes a <code>Vec&lt;[T; N]&gt;</code> and flattens it into a <code>Vec&lt;T&gt;</code>.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the length of the resulting vector would overflow a <code>usize</code>.</p>\n<p>This is only possible when flattening a vector of arrays of zero-sized\ntypes, and thus tends to be irrelevant in practice. If\n<code>size_of::&lt;T&gt;() &gt; 0</code>, this will never panic.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(slice_flatten)]\n\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>], [<span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>], [<span class=\"number\">7</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>]];\n<span class=\"macro\">assert_eq!</span>(vec.pop(), <span class=\"prelude-val\">Some</span>([<span class=\"number\">7</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>]));\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>flattened = vec.into_flattened();\n<span class=\"macro\">assert_eq!</span>(flattened.pop(), <span class=\"prelude-val\">Some</span>(<span class=\"number\">6</span>));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(slice_flatten)%5D%0A%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B%5B1,+2,+3%5D,+%5B4,+5,+6%5D,+%5B7,+8,+9%5D%5D;%0Aassert_eq!(vec.pop(),+Some(%5B7,+8,+9%5D));%0A%0Alet+mut+flattened+=+vec.into_flattened();%0Aassert_eq!(flattened.pop(),+Some(6));%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2859\">source</a><a href=\"#impl-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.dedup\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2876\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.dedup\" class=\"fn\">dedup</a>(&amp;mut self)</h4></section></summary><div class=\"docblock\"><p>Removes consecutive repeated elements in the vector according to the\n<a href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\"><code>PartialEq</code></a> trait implementation.</p>\n<p>If the vector is sorted, this removes all duplicates.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>vec = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">2</span>];\n\nvec.dedup();\n\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">2</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+vec+=+vec!%5B1,+2,+2,+3,+2%5D;%0A%0Avec.dedup();%0A%0Aassert_eq!(vec,+%5B1,+2,+3,+2%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3138\">source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.splice\" class=\"method\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3236-3239\">source</a></span><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.splice\" class=\"fn\">splice</a>&lt;R, I&gt;(\n    &amp;mut self,\n    range: R,\n    replace_with: I\n) -&gt; <a class=\"struct\" href=\"std/vec/struct.Splice.html\" title=\"struct std::vec::Splice\">Splice</a>&lt;'_, &lt;I as <a class=\"trait\" href=\"std/iter/trait.IntoIterator.html\" title=\"trait std::iter::IntoIterator\">IntoIterator</a>&gt;::<a class=\"associatedtype\" href=\"std/iter/trait.IntoIterator.html#associatedtype.IntoIter\" title=\"type std::iter::IntoIterator::IntoIter\">IntoIter</a>, A&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"Splice&lt;&#39;_, &lt;I as IntoIterator&gt;::IntoIter, A&gt;\">ⓘ</a><span class=\"where fmt-newline\">where\n    R: <a class=\"trait\" href=\"std/ops/trait.RangeBounds.html\" title=\"trait std::ops::RangeBounds\">RangeBounds</a>&lt;<a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt;,\n    I: <a class=\"trait\" href=\"std/iter/trait.IntoIterator.html\" title=\"trait std::iter::IntoIterator\">IntoIterator</a>&lt;Item = T&gt;,</span></h4></section></summary><div class=\"docblock\"><p>Creates a splicing iterator that replaces the specified range in the vector\nwith the given <code>replace_with</code> iterator and yields the removed items.\n<code>replace_with</code> does not need to be the same length as <code>range</code>.</p>\n<p><code>range</code> is removed even if the iterator is not consumed until the end.</p>\n<p>It is unspecified how many elements are removed from the vector\nif the <code>Splice</code> value is leaked.</p>\n<p>The input iterator <code>replace_with</code> is only consumed when the <code>Splice</code> value is dropped.</p>\n<p>This is optimal if:</p>\n<ul>\n<li>The tail (elements in the vector after <code>range</code>) is empty,</li>\n<li>or <code>replace_with</code> yields fewer or equal elements than <code>range</code>’s length</li>\n<li>or the lower bound of its <code>size_hint()</code> is exact.</li>\n</ul>\n<p>Otherwise, a temporary vector is allocated and the tail is moved twice.</p>\n<h5 id=\"panics\"><a href=\"#panics\">Panics</a></h5>\n<p>Panics if the starting point is greater than the end point or if\nthe end point is greater than the length of the vector.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>];\n<span class=\"kw\">let </span>new = [<span class=\"number\">7</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>];\n<span class=\"kw\">let </span>u: Vec&lt;<span class=\"kw\">_</span>&gt; = v.splice(<span class=\"number\">1</span>..<span class=\"number\">3</span>, new).collect();\n<span class=\"macro\">assert_eq!</span>(v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">7</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>, <span class=\"number\">4</span>]);\n<span class=\"macro\">assert_eq!</span>(u, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+mut+v+=+vec!%5B1,+2,+3,+4%5D;%0Alet+new+=+%5B7,+8,+9%5D;%0Alet+u:+Vec%3C_%3E+=+v.splice(1..3,+new).collect();%0Aassert_eq!(v,+%26%5B1,+7,+8,+9,+4%5D);%0Aassert_eq!(u,+%26%5B2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3309\">source</a><a href=\"#impl-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.extract_if\" class=\"method\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3361-3363\">source</a><h4 class=\"code-header\">pub fn <a href=\"alloc/vec/struct.Vec.html#tymethod.extract_if\" class=\"fn\">extract_if</a>&lt;F&gt;(&amp;mut self, filter: F) -&gt; <a class=\"struct\" href=\"std/vec/struct.ExtractIf.html\" title=\"struct std::vec::ExtractIf\">ExtractIf</a>&lt;'_, T, F, A, FH&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"ExtractIf&lt;&#39;_, T, F, A, FH&gt;\">ⓘ</a><span class=\"where fmt-newline\">where\n    F: <a class=\"trait\" href=\"std/ops/trait.FnMut.html\" title=\"trait std::ops::FnMut\">FnMut</a>(<a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut T</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a>,</span></h4></section><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>extract_if</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/43244\">#43244</a>)</span></div></span></summary><div class=\"docblock\"><p>Creates an iterator which uses a closure to determine if an element should be removed.</p>\n<p>If the closure returns true, then the element is removed and yielded.\nIf the closure returns false, the element will remain in the vector and will not be yielded\nby the iterator.</p>\n<p>If the returned <code>ExtractIf</code> is not exhausted, e.g. because it is dropped without iterating\nor the iteration short-circuits, then the remaining elements will be retained.\nUse <a href=\"alloc/vec/struct.Vec.html#method.retain\" title=\"method alloc::vec::Vec::retain\"><code>retain</code></a> with a negated predicate if you do not need the returned iterator.</p>\n<p>Using this method is equivalent to the following code:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>i = <span class=\"number\">0</span>;\n<span class=\"kw\">while </span>i &lt; vec.len() {\n    <span class=\"kw\">if </span>some_predicate(<span class=\"kw-2\">&amp;mut </span>vec[i]) {\n        <span class=\"kw\">let </span>val = vec.remove(i);\n        <span class=\"comment\">// your code here\n    </span>} <span class=\"kw\">else </span>{\n        i += <span class=\"number\">1</span>;\n    }\n}\n</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+some_predicate+=+%7Cx:+%26mut+i32%7C+%7B+*x+==+2+%7C%7C+*x+==+3+%7C%7C+*x+==+6+%7D;%0Alet+mut+vec+=+vec!%5B1,+2,+3,+4,+5,+6%5D;%0Alet+mut+i+=+0;%0Awhile+i+%3C+vec.len()+%7B%0A++++if+some_predicate(%26mut+vec%5Bi%5D)+%7B%0A++++++++let+val+=+vec.remove(i);%0A++++++++//+your+code+here%0A++++%7D+else+%7B%0A++++++++i+%2B=+1;%0A++++%7D%0A%7D%0A%0Aassert_eq!(vec,+vec!%5B1,+4,+5%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n<p>But <code>extract_if</code> is easier to use. <code>extract_if</code> is also more efficient,\nbecause it can backshift the elements of the array in bulk.</p>\n<p>Note that <code>extract_if</code> also lets you mutate every element in the filter closure,\nregardless of whether you choose to keep or remove it.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<p>Splitting an array into evens and odds, reusing the original allocation:</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"attr\">#![feature(extract_if)]\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>numbers = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>, <span class=\"number\">5</span>, <span class=\"number\">6</span>, <span class=\"number\">8</span>, <span class=\"number\">9</span>, <span class=\"number\">11</span>, <span class=\"number\">13</span>, <span class=\"number\">14</span>, <span class=\"number\">15</span>];\n\n<span class=\"kw\">let </span>evens = numbers.extract_if(|x| <span class=\"kw-2\">*</span>x % <span class=\"number\">2 </span>== <span class=\"number\">0</span>).collect::&lt;Vec&lt;<span class=\"kw\">_</span>&gt;&gt;();\n<span class=\"kw\">let </span>odds = numbers;\n\n<span class=\"macro\">assert_eq!</span>(evens, <span class=\"macro\">vec!</span>[<span class=\"number\">2</span>, <span class=\"number\">4</span>, <span class=\"number\">6</span>, <span class=\"number\">8</span>, <span class=\"number\">14</span>]);\n<span class=\"macro\">assert_eq!</span>(odds, <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">3</span>, <span class=\"number\">5</span>, <span class=\"number\">9</span>, <span class=\"number\">11</span>, <span class=\"number\">13</span>, <span class=\"number\">15</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0A%23!%5Bfeature(extract_if)%5D%0Afn+main()+%7B%0Alet+mut+numbers+=+vec!%5B1,+2,+3,+4,+5,+6,+8,+9,+11,+13,+14,+15%5D;%0A%0Alet+evens+=+numbers.extract_if(%7Cx%7C+*x+%25+2+==+0).collect::%3CVec%3C_%3E%3E();%0Alet+odds+=+numbers;%0A%0Aassert_eq!(evens,+vec!%5B2,+4,+6,+8,+14%5D);%0Aassert_eq!(odds,+vec!%5B1,+3,+5,+9,+11,+13,+15%5D);%0A%7D&amp;version=nightly&amp;edition=2021\">Run</a></div>\n</div></details></div></details>",0,"std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Index%3CI%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3024\">source</a><a href=\"#impl-Index%3CI%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, I, A, FH&gt; <a class=\"trait\" href=\"std/ops/trait.Index.html\" title=\"trait std::ops::Index\">Index</a>&lt;I&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/slice/trait.SliceIndex.html\" title=\"trait std::slice::SliceIndex\">SliceIndex</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt;,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Index.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = &lt;I as <a class=\"trait\" href=\"std/slice/trait.SliceIndex.html\" title=\"trait std::slice::SliceIndex\">SliceIndex</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt;&gt;::<a class=\"associatedtype\" href=\"std/slice/trait.SliceIndex.html#associatedtype.Output\" title=\"type std::slice::SliceIndex::Output\">Output</a></h4></section></summary><div class='docblock'>The returned type after indexing.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.index\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3028\">source</a><a href=\"#method.index\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Index.html#tymethod.index\" class=\"fn\">index</a>(&amp;self, index: I) -&gt; &amp;&lt;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt; as <a class=\"trait\" href=\"std/ops/trait.Index.html\" title=\"trait std::ops::Index\">Index</a>&lt;I&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Index.html#associatedtype.Output\" title=\"type std::ops::Index::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the indexing (<code>container[index]</code>) operation. <a href=\"std/ops/trait.Index.html#tymethod.index\">Read more</a></div></details></div></details>","Index<I>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Deref-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2959\">source</a><a href=\"#impl-Deref-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/ops/trait.Deref.html\" title=\"trait std::ops::Deref\">Deref</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Target\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Target\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/ops/trait.Deref.html#associatedtype.Target\" class=\"associatedtype\">Target</a> = <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>The resulting type after dereferencing.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2963\">source</a><a href=\"#method.deref\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Deref.html#tymethod.deref\" class=\"fn\">deref</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Dereferences the value.</div></details></div></details>","Deref","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Ord-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3421\">source</a><a href=\"#impl-Ord-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/cmp/trait.Ord.html\" title=\"trait std::cmp::Ord\">Ord</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/cmp/trait.Ord.html\" title=\"trait std::cmp::Ord\">Ord</a>,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"docblock\"><p>Implements ordering of vectors, <a href=\"std/cmp/trait.Ord.html#lexicographical-comparison\" title=\"trait std::cmp::Ord\">lexicographically</a>.</p>\n</div><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3423\">source</a><a href=\"#method.cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#tymethod.cmp\" class=\"fn\">cmp</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;) -&gt; <a class=\"enum\" href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\">Ordering</a></h4></section></summary><div class='docblock'>This method returns an <a href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\"><code>Ordering</code></a> between <code>self</code> and <code>other</code>. <a href=\"std/cmp/trait.Ord.html#tymethod.cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.max\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#826-828\">source</a></span><a href=\"#method.max\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.max\" class=\"fn\">max</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the maximum of two values. <a href=\"std/cmp/trait.Ord.html#method.max\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.min\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.21.0\">1.21.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#846-848\">source</a></span><a href=\"#method.min\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.min\" class=\"fn\">min</a>(self, other: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Compares and returns the minimum of two values. <a href=\"std/cmp/trait.Ord.html#method.min\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clamp\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.50.0\">1.50.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#871-874\">source</a></span><a href=\"#method.clamp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.Ord.html#method.clamp\" class=\"fn\">clamp</a>(self, min: Self, max: Self) -&gt; Self<span class=\"where fmt-newline\">where\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a>,</span></h4></section></summary><div class='docblock'>Restrict a value to a certain interval. <a href=\"std/cmp/trait.Ord.html#method.clamp\">Read more</a></div></details></div></details>","Ord","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%26%5BU%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#24\">source</a><a href=\"#impl-PartialEq%3C%26%5BU%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A, FH&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.slice.html\">[U]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#24\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;&amp;<a class=\"primitive\" href=\"primitive.slice.html\">[U]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#24\">source</a><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: &amp;&amp;<a class=\"primitive\" href=\"primitive.slice.html\">[U]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq<&[U]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3CVec%3CU,+A2,+FH2%3E%3E-for-Vec%3CT,+A1,+FH1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#23\">source</a><a href=\"#impl-PartialEq%3CVec%3CU,+A2,+FH2%3E%3E-for-Vec%3CT,+A1,+FH1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A1, A2, FH1, FH2&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;U, A2, FH2&gt;&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A1, FH1&gt;<span class=\"where fmt-newline\">where\n    A1: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    A2: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH1: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,\n    FH2: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#23\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;U, A2, FH2&gt;) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#23\">source</a><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;U, A2, FH2&gt;) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq<Vec<U, A2, FH2>>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%5BU;+N%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#36\">source</a><a href=\"#impl-PartialEq%3C%5BU;+N%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A, FH, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;<a class=\"primitive\" href=\"primitive.array.html\">[U; N]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#36\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.array.html\">[U; N]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#36\">source</a><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.array.html\">[U; N]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq<[U; N]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%5BU%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.48.0\">1.48.0</span> · <a class=\"src\" href=\"src/alloc/vec/partial_eq.rs.html#28\">source</a></span><a href=\"#impl-PartialEq%3C%5BU%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A, FH&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[U]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#28\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[U]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#28\">source</a><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[U]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq<[U]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%26%5BU;+N%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#37\">source</a><a href=\"#impl-PartialEq%3C%26%5BU;+N%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A, FH, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.array.html\">[U; N]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#37\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;&amp;<a class=\"primitive\" href=\"primitive.array.html\">[U; N]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#37\">source</a><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: &amp;&amp;<a class=\"primitive\" href=\"primitive.array.html\">[U; N]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq<&[U; N]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%26mut+%5BU%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#25\">source</a><a href=\"#impl-PartialEq%3C%26mut+%5BU%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A, FH&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;&amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[U]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialEq.html\" title=\"trait std::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#25\">source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;&amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[U]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>self</code> and <code>other</code> values to be equal, and is used\nby <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/partial_eq.rs.html#25\">source</a><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: &amp;&amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[U]</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests for <code>!=</code>. The default implementation is almost always\nsufficient, and should not be overridden without very good reason.</div></details></div></details>","PartialEq<&mut [U]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Hash-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3012\">source</a><a href=\"#impl-Hash-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/hash/trait.Hash.html\" title=\"trait std::hash::Hash\">Hash</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/hash/trait.Hash.html\" title=\"trait std::hash::Hash\">Hash</a>,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"docblock\"><p>The hash of a vector is the same as that of the corresponding slice,\nas required by the <code>core::borrow::Borrow</code> implementation.</p>\n\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::hash::BuildHasher;\n\n<span class=\"kw\">let </span>b = std::collections::hash_map::RandomState::new();\n<span class=\"kw\">let </span>v: Vec&lt;u8&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">0xa8</span>, <span class=\"number\">0x3c</span>, <span class=\"number\">0x09</span>];\n<span class=\"kw\">let </span>s: <span class=\"kw-2\">&amp;</span>[u8] = <span class=\"kw-2\">&amp;</span>[<span class=\"number\">0xa8</span>, <span class=\"number\">0x3c</span>, <span class=\"number\">0x09</span>];\n<span class=\"macro\">assert_eq!</span>(b.hash_one(v), b.hash_one(s));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::hash::BuildHasher;%0A%0Alet+b+=+std::collections::hash_map::RandomState::new();%0Alet+v:+Vec%3Cu8%3E+=+vec!%5B0xa8,+0x3c,+0x09%5D;%0Alet+s:+%26%5Bu8%5D+=+%26%5B0xa8,+0x3c,+0x09%5D;%0Aassert_eq!(b.hash_one(v),+b.hash_one(s));%0A%7D&amp;edition=2021\">Run</a></div>\n</div><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3014\">source</a><a href=\"#method.hash\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/hash/trait.Hash.html#tymethod.hash\" class=\"fn\">hash</a>&lt;H&gt;(&amp;self, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut H</a>)<span class=\"where fmt-newline\">where\n    H: <a class=\"trait\" href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\">Hasher</a>,</span></h4></section></summary><div class='docblock'>Feeds this value into the given <a href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\"><code>Hasher</code></a>. <a href=\"std/hash/trait.Hash.html#tymethod.hash\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.hash_slice\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.3.0\">1.3.0</span> · <a class=\"src\" href=\"src/core/hash/mod.rs.html#242-244\">source</a></span><a href=\"#method.hash_slice\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/hash/trait.Hash.html#method.hash_slice\" class=\"fn\">hash_slice</a>&lt;H&gt;(data: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[Self]</a>, state: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;mut H</a>)<span class=\"where fmt-newline\">where\n    H: <a class=\"trait\" href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\">Hasher</a>,\n    Self: <a class=\"trait\" href=\"std/marker/trait.Sized.html\" title=\"trait std::marker::Sized\">Sized</a>,</span></h4></section></summary><div class='docblock'>Feeds a slice of this type into the given <a href=\"std/hash/trait.Hasher.html\" title=\"trait std::hash::Hasher\"><code>Hasher</code></a>. <a href=\"std/hash/trait.Hash.html#method.hash_slice\">Read more</a></div></details></div></details>","Hash","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Drop-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3429\">source</a><a href=\"#impl-Drop-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/ops/trait.Drop.html\" title=\"trait std::ops::Drop\">Drop</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.drop\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3430\">source</a><a href=\"#method.drop\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.Drop.html#tymethod.drop\" class=\"fn\">drop</a>(&amp;mut self)</h4></section></summary><div class='docblock'>Executes the destructor for this type. <a href=\"std/ops/trait.Drop.html#tymethod.drop\">Read more</a></div></details></div></details>","Drop","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialOrd%3CVec%3CT,+A2,+FH2%3E%3E-for-Vec%3CT,+A1,+FH1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3402-3408\">source</a><a href=\"#impl-PartialOrd%3CVec%3CT,+A2,+FH2%3E%3E-for-Vec%3CT,+A1,+FH1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A1, A2, FH1, FH2&gt; <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a>&lt;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A2, FH2&gt;&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A1, FH1&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/cmp/trait.PartialOrd.html\" title=\"trait std::cmp::PartialOrd\">PartialOrd</a>,\n    A1: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    A2: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH1: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,\n    FH2: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"docblock\"><p>Implements comparison of vectors, <a href=\"std/cmp/trait.Ord.html#lexicographical-comparison\" title=\"trait std::cmp::Ord\">lexicographically</a>.</p>\n</div><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.partial_cmp\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3411\">source</a><a href=\"#method.partial_cmp\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\" class=\"fn\">partial_cmp</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A2, FH2&gt;) -&gt; <a class=\"enum\" href=\"std/option/enum.Option.html\" title=\"enum std::option::Option\">Option</a>&lt;<a class=\"enum\" href=\"std/cmp/enum.Ordering.html\" title=\"enum std::cmp::Ordering\">Ordering</a>&gt;</h4></section></summary><div class='docblock'>This method returns an ordering between <code>self</code> and <code>other</code> values if one exists. <a href=\"std/cmp/trait.PartialOrd.html#tymethod.partial_cmp\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.lt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1122\">source</a><a href=\"#method.lt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.lt\" class=\"fn\">lt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.lt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.le\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1139\">source</a><a href=\"#method.le\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.le\" class=\"fn\">le</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests less than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&lt;=</code>\noperator. <a href=\"std/cmp/trait.PartialOrd.html#method.le\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.gt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1155\">source</a><a href=\"#method.gt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.gt\" class=\"fn\">gt</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;</code> operator. <a href=\"std/cmp/trait.PartialOrd.html#method.gt\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ge\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/core/cmp.rs.html#1172\">source</a><a href=\"#method.ge\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/cmp/trait.PartialOrd.html#method.ge\" class=\"fn\">ge</a>(&amp;self, other: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>This method tests greater than or equal to (for <code>self</code> and <code>other</code>) and is used by the <code>&gt;=</code>\noperator. <a href=\"std/cmp/trait.PartialOrd.html#method.ge\">Read more</a></div></details></div></details>","PartialOrd<Vec<T, A2, FH2>>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AsMut%3CVec%3CT,+A,+FH%3E%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.5.0\">1.5.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3466\">source</a></span><a href=\"#impl-AsMut%3CVec%3CT,+A,+FH%3E%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/convert/trait.AsMut.html\" title=\"trait std::convert::AsMut\">AsMut</a>&lt;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3467\">source</a><a href=\"#method.as_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.AsMut.html#tymethod.as_mut\" class=\"fn\">as_mut</a>(&amp;mut self) -&gt; &amp;mut <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;</h4></section></summary><div class='docblock'>Converts this type into a mutable reference of the (usually inferred) input type.</div></details></div></details>","AsMut<Vec<T, A, FH>>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AsMut%3C%5BT%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.5.0\">1.5.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3480\">source</a></span><a href=\"#impl-AsMut%3C%5BT%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/convert/trait.AsMut.html\" title=\"trait std::convert::AsMut\">AsMut</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3481\">source</a><a href=\"#method.as_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.AsMut.html#tymethod.as_mut\" class=\"fn\">as_mut</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Converts this type into a mutable reference of the (usually inferred) input type.</div></details></div></details>","AsMut<[T]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Extend%3CT%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3121\">source</a><a href=\"#impl-Extend%3CT%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"std/iter/trait.Extend.html\" title=\"trait std::iter::Extend\">Extend</a>&lt;T&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3123\">source</a><a href=\"#method.extend\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Extend.html#tymethod.extend\" class=\"fn\">extend</a>&lt;I&gt;(&amp;mut self, iter: I)<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.IntoIterator.html\" title=\"trait std::iter::IntoIterator\">IntoIterator</a>&lt;Item = T&gt;,</span></h4></section></summary><div class='docblock'>Extends a collection with the contents of an iterator. <a href=\"std/iter/trait.Extend.html#tymethod.extend\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend_one\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3128\">source</a><a href=\"#method.extend_one\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Extend.html#method.extend_one\" class=\"fn\">extend_one</a>(&amp;mut self, item: T)</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>extend_one</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/72631\">#72631</a>)</span></div></span><div class='docblock'>Extends a collection with exactly one element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend_reserve\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3133\">source</a><a href=\"#method.extend_reserve\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Extend.html#method.extend_reserve\" class=\"fn\">extend_reserve</a>(&amp;mut self, additional: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>extend_one</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/72631\">#72631</a>)</span></div></span><div class='docblock'>Reserves capacity in a collection for the given number of additional elements. <a href=\"std/iter/trait.Extend.html#method.extend_reserve\">Read more</a></div></details></div></details>","Extend<T>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Extend%3C%26T%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.2.0\">1.2.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3384\">source</a></span><a href=\"#impl-Extend%3C%26T%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, T, A&gt; <a class=\"trait\" href=\"std/iter/trait.Extend.html\" title=\"trait std::iter::Extend\">Extend</a>&lt;<a class=\"primitive\" href=\"primitive.reference.html\">&amp;'a T</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/marker/trait.Copy.html\" title=\"trait std::marker::Copy\">Copy</a> + 'a,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"docblock\"><p>Extend implementation that copies elements out of references before pushing them onto the Vec.</p>\n<p>This implementation is specialized for slice iterators, where it uses <a href=\"std/primitive.slice.html#method.copy_from_slice\" title=\"method slice::copy_from_slice\"><code>copy_from_slice</code></a> to\nappend the entire slice at once.</p>\n</div><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3385\">source</a><a href=\"#method.extend\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Extend.html#tymethod.extend\" class=\"fn\">extend</a>&lt;I&gt;(&amp;mut self, iter: I)<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.IntoIterator.html\" title=\"trait std::iter::IntoIterator\">IntoIterator</a>&lt;Item = <a class=\"primitive\" href=\"primitive.reference.html\">&amp;'a T</a>&gt;,</span></h4></section></summary><div class='docblock'>Extends a collection with the contents of an iterator. <a href=\"std/iter/trait.Extend.html#tymethod.extend\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend_one\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3390\">source</a><a href=\"#method.extend_one\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Extend.html#method.extend_one\" class=\"fn\">extend_one</a>(&amp;mut self, _: <a class=\"primitive\" href=\"primitive.reference.html\">&amp;'a T</a>)</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>extend_one</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/72631\">#72631</a>)</span></div></span><div class='docblock'>Extends a collection with exactly one element.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend_reserve\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3395\">source</a><a href=\"#method.extend_reserve\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.Extend.html#method.extend_reserve\" class=\"fn\">extend_reserve</a>(&amp;mut self, additional: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>)</h4></section></summary><span class=\"item-info\"><div class=\"stab unstable\"><span class=\"emoji\">🔬</span><span>This is a nightly-only experimental API. (<code>extend_one</code>&nbsp;<a href=\"https://github.com/rust-lang/rust/issues/72631\">#72631</a>)</span></div></span><div class='docblock'>Reserves capacity in a collection for the given number of additional elements. <a href=\"std/iter/trait.Extend.html#method.extend_reserve\">Read more</a></div></details></div></details>","Extend<&'a T>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-DerefMut-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2969\">source</a><a href=\"#impl-DerefMut-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/ops/trait.DerefMut.html\" title=\"trait std::ops::DerefMut\">DerefMut</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2971\">source</a><a href=\"#method.deref_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.DerefMut.html#tymethod.deref_mut\" class=\"fn\">deref_mut</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Mutably dereferences the value.</div></details></div></details>","DerefMut","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Borrow%3C%5BT%5D%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/slice.rs.html#773\">source</a><a href=\"#impl-Borrow%3C%5BT%5D%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"std/borrow/trait.Borrow.html\" title=\"trait std::borrow::Borrow\">Borrow</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/slice.rs.html#774\">source</a><a href=\"#method.borrow\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/borrow/trait.Borrow.html#tymethod.borrow\" class=\"fn\">borrow</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Immutably borrows from an owned value. <a href=\"std/borrow/trait.Borrow.html#tymethod.borrow\">Read more</a></div></details></div></details>","Borrow<[T]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Default-for-Vec%3CT%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3442\">source</a><a href=\"#impl-Default-for-Vec%3CT%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/default/trait.Default.html\" title=\"trait std::default::Default\">Default</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.default\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3446\">source</a><a href=\"#method.default\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/default/trait.Default.html#tymethod.default\" class=\"fn\">default</a>() -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Creates an empty <code>Vec&lt;T&gt;</code>.</p>\n<p>The vector will not allocate until elements are pushed onto it.</p>\n</div></details></div></details>","Default","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AsRef%3CVec%3CT,+A,+FH%3E%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3459\">source</a><a href=\"#impl-AsRef%3CVec%3CT,+A,+FH%3E%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/convert/trait.AsRef.html\" title=\"trait std::convert::AsRef\">AsRef</a>&lt;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ref\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3460\">source</a><a href=\"#method.as_ref\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.AsRef.html#tymethod.as_ref\" class=\"fn\">as_ref</a>(&amp;self) -&gt; &amp;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;</h4></section></summary><div class='docblock'>Converts this type into a shared reference of the (usually inferred) input type.</div></details></div></details>","AsRef<Vec<T, A, FH>>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-AsRef%3C%5BT%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3473\">source</a><a href=\"#impl-AsRef%3C%5BT%5D%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/convert/trait.AsRef.html\" title=\"trait std::convert::AsRef\">AsRef</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ref\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3474\">source</a><a href=\"#method.as_ref\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.AsRef.html#tymethod.as_ref\" class=\"fn\">as_ref</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Converts this type into a shared reference of the (usually inferred) input type.</div></details></div></details>","AsRef<[T]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BorrowMut%3C%5BT%5D%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/slice.rs.html#780\">source</a><a href=\"#impl-BorrowMut%3C%5BT%5D%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"std/borrow/trait.BorrowMut.html\" title=\"trait std::borrow::BorrowMut\">BorrowMut</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/slice.rs.html#781\">source</a><a href=\"#method.borrow_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/borrow/trait.BorrowMut.html#tymethod.borrow_mut\" class=\"fn\">borrow_mut</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Mutably borrows from an owned value. <a href=\"std/borrow/trait.BorrowMut.html#tymethod.borrow_mut\">Read more</a></div></details></div></details>","BorrowMut<[T]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-IndexMut%3CI%3E-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3038\">source</a><a href=\"#impl-IndexMut%3CI%3E-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, I, A, FH&gt; <a class=\"trait\" href=\"std/ops/trait.IndexMut.html\" title=\"trait std::ops::IndexMut\">IndexMut</a>&lt;I&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/slice/trait.SliceIndex.html\" title=\"trait std::slice::SliceIndex\">SliceIndex</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt;,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.index_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3040\">source</a><a href=\"#method.index_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/ops/trait.IndexMut.html#tymethod.index_mut\" class=\"fn\">index_mut</a>(&amp;mut self, index: I) -&gt; &amp;mut &lt;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt; as <a class=\"trait\" href=\"std/ops/trait.Index.html\" title=\"trait std::ops::Index\">Index</a>&lt;I&gt;&gt;::<a class=\"associatedtype\" href=\"std/ops/trait.Index.html#associatedtype.Output\" title=\"type std::ops::Index::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the mutable indexing (<code>container[index]</code>) operation. <a href=\"std/ops/trait.IndexMut.html#tymethod.index_mut\">Read more</a></div></details></div></details>","IndexMut<I>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CCString%3E-for-Vec%3Cu8%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.7.0\">1.7.0</span> · <a class=\"src\" href=\"src/alloc/ffi/c_str.rs.html#726\">source</a></span><a href=\"#impl-From%3CCString%3E-for-Vec%3Cu8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"std/ffi/struct.CString.html\" title=\"struct std::ffi::CString\">CString</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/ffi/c_str.rs.html#731\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(s: <a class=\"struct\" href=\"std/ffi/struct.CString.html\" title=\"struct std::ffi::CString\">CString</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Converts a <a href=\"std/ffi/struct.CString.html\" title=\"struct std::ffi::CString\"><code>CString</code></a> into a <code><a href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;<a href=\"std/primitive.u8.html\" title=\"primitive u8\">u8</a>&gt;</code>.</p>\n<p>The conversion consumes the <a href=\"std/ffi/struct.CString.html\" title=\"struct std::ffi::CString\"><code>CString</code></a>, and removes the terminating NUL byte.</p>\n</div></details></div></details>","From<CString>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CBox%3C%5BT%5D,+A%3E%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.18.0\">1.18.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3604\">source</a></span><a href=\"#impl-From%3CBox%3C%5BT%5D,+A%3E%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"std/boxed/struct.Box.html\" title=\"struct std::boxed::Box\">Box</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>, A&gt;&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3614\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(s: <a class=\"struct\" href=\"std/boxed/struct.Box.html\" title=\"struct std::boxed::Box\">Box</a>&lt;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>, A&gt;) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;</h4></section></summary><div class=\"docblock\"><p>Convert a boxed slice into a vector by transferring ownership of\nthe existing heap allocation.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>b: Box&lt;[i32]&gt; = <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>].into_boxed_slice();\n<span class=\"macro\">assert_eq!</span>(Vec::from(b), <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+b:+Box%3C%5Bi32%5D%3E+=+vec!%5B1,+2,+3%5D.into_boxed_slice();%0Aassert_eq!(Vec::from(b),+vec!%5B1,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<Box<[T], A>>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C%26%5BT%5D%3E-for-Vec%3CT%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3488\">source</a><a href=\"#impl-From%3C%26%5BT%5D%3E-for-Vec%3CT%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3497\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(s: &amp;<a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Allocate a <code>Vec&lt;T&gt;</code> and fill it by cloning <code>s</code>’s items.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(Vec::from(<span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>][..]), <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aassert_eq!(Vec::from(%26%5B1,+2,+3%5D%5B..%5D),+vec!%5B1,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<&[T]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CString%3E-for-Vec%3Cu8%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.14.0\">1.14.0</span> · <a class=\"src\" href=\"src/alloc/string.rs.html#2946\">source</a></span><a href=\"#impl-From%3CString%3E-for-Vec%3Cu8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"std/string/struct.String.html\" title=\"struct std::string::String\">String</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/string.rs.html#2959\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(string: <a class=\"struct\" href=\"std/string/struct.String.html\" title=\"struct std::string::String\">String</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Converts the given <a href=\"std/string/struct.String.html\" title=\"struct std::string::String\"><code>String</code></a> to a vector <a href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\"><code>Vec</code></a> that holds values of type <a href=\"std/primitive.u8.html\" title=\"primitive u8\"><code>u8</code></a>.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>s1 = String::from(<span class=\"string\">&quot;hello world&quot;</span>);\n<span class=\"kw\">let </span>v1 = Vec::from(s1);\n\n<span class=\"kw\">for </span>b <span class=\"kw\">in </span>v1 {\n    <span class=\"macro\">println!</span>(<span class=\"string\">&quot;{b}&quot;</span>);\n}</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+s1+=+String::from(%22hello+world%22);%0Alet+v1+=+Vec::from(s1);%0A%0Afor+b+in+v1+%7B%0A++++println!(%22%7Bb%7D%22);%0A%7D%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<String>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C%26str%3E-for-Vec%3Cu8%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3649\">source</a><a href=\"#impl-From%3C%26str%3E-for-Vec%3Cu8%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.str.html\">str</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3657\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(s: &amp;<a class=\"primitive\" href=\"primitive.str.html\">str</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;<a class=\"primitive\" href=\"primitive.u8.html\">u8</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Allocate a <code>Vec&lt;u8&gt;</code> and fill it with a UTF-8 string.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(Vec::from(<span class=\"string\">&quot;123&quot;</span>), <span class=\"macro\">vec!</span>[<span class=\"string\">b&#39;1&#39;</span>, <span class=\"string\">b&#39;2&#39;</span>, <span class=\"string\">b&#39;3&#39;</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aassert_eq!(Vec::from(%22123%22),+vec!%5Bb'1',+b'2',+b'3'%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<&str>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C%5BT;+N%5D%3E-for-Vec%3CT%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.44.0\">1.44.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3558\">source</a></span><a href=\"#impl-From%3C%5BT;+N%5D%3E-for-Vec%3CT%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3567\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(s: <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Allocate a <code>Vec&lt;T&gt;</code> and move <code>s</code>’s items into it.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(Vec::from([<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]), <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aassert_eq!(Vec::from(%5B1,+2,+3%5D),+vec!%5B1,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<[T; N]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C%26mut+%5BT%5D%3E-for-Vec%3CT%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.19.0\">1.19.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3508\">source</a></span><a href=\"#impl-From%3C%26mut+%5BT%5D%3E-for-Vec%3CT%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;&amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3517\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(s: &amp;mut <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Allocate a <code>Vec&lt;T&gt;</code> and fill it by cloning <code>s</code>’s items.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(Vec::from(<span class=\"kw-2\">&amp;mut </span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>][..]), <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aassert_eq!(Vec::from(%26mut+%5B1,+2,+3%5D%5B..%5D),+vec!%5B1,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<&mut [T]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CBinaryHeap%3CT,+A%3E%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.5.0\">1.5.0</span> · <a class=\"src\" href=\"src/alloc/collections/binary_heap/mod.rs.html#1782\">source</a></span><a href=\"#impl-From%3CBinaryHeap%3CT,+A%3E%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"std/collections/struct.BinaryHeap.html\" title=\"struct std::collections::BinaryHeap\">BinaryHeap</a>&lt;T, A&gt;&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/collections/binary_heap/mod.rs.html#1787\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(heap: <a class=\"struct\" href=\"std/collections/struct.BinaryHeap.html\" title=\"struct std::collections::BinaryHeap\">BinaryHeap</a>&lt;T, A&gt;) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;</h4></section></summary><div class=\"docblock\"><p>Converts a <code>BinaryHeap&lt;T&gt;</code> into a <code>Vec&lt;T&gt;</code>.</p>\n<p>This conversion requires no data movement or allocation, and has\nconstant time complexity.</p>\n</div></details></div></details>","From<BinaryHeap<T, A>>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C%26%5BT;+N%5D%3E-for-Vec%3CT%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.74.0\">1.74.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3528\">source</a></span><a href=\"#impl-From%3C%26%5BT;+N%5D%3E-for-Vec%3CT%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;&amp;<a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3536\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(s: &amp;<a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Allocate a <code>Vec&lt;T&gt;</code> and fill it by cloning <code>s</code>’s items.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(Vec::from(<span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]), <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aassert_eq!(Vec::from(%26%5B1,+2,+3%5D),+vec!%5B1,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<&[T; N]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3C%26mut+%5BT;+N%5D%3E-for-Vec%3CT%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.74.0\">1.74.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3543\">source</a></span><a href=\"#impl-From%3C%26mut+%5BT;+N%5D%3E-for-Vec%3CT%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, const N: <a class=\"primitive\" href=\"primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;&amp;mut <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3551\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(s: &amp;mut <a class=\"primitive\" href=\"primitive.array.html\">[T; N]</a>) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Allocate a <code>Vec&lt;T&gt;</code> and fill it by cloning <code>s</code>’s items.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"macro\">assert_eq!</span>(Vec::from(<span class=\"kw-2\">&amp;mut </span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]), <span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Aassert_eq!(Vec::from(%26mut+%5B1,+2,+3%5D),+vec!%5B1,+2,+3%5D);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<&mut [T; N]>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CCow%3C'a,+%5BT%5D%3E%3E-for-Vec%3CT%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.14.0\">1.14.0</span> · <a class=\"src\" href=\"src/alloc/vec/mod.rs.html#3578-3580\">source</a></span><a href=\"#impl-From%3CCow%3C'a,+%5BT%5D%3E%3E-for-Vec%3CT%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;'a, T&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"enum\" href=\"std/borrow/enum.Cow.html\" title=\"enum std::borrow::Cow\">Cow</a>&lt;'a, <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt;&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>: <a class=\"trait\" href=\"std/borrow/trait.ToOwned.html\" title=\"trait std::borrow::ToOwned\">ToOwned</a>&lt;Owned = <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;&gt;,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3596\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(s: <a class=\"enum\" href=\"std/borrow/enum.Cow.html\" title=\"enum std::borrow::Cow\">Cow</a>&lt;'a, <a class=\"primitive\" href=\"primitive.slice.html\">[T]</a>&gt;) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Convert a clone-on-write slice into a vector.</p>\n<p>If <code>s</code> already owns a <code>Vec&lt;T&gt;</code>, it will be returned directly.\nIf <code>s</code> is borrowing a slice, a new <code>Vec&lt;T&gt;</code> will be allocated and\nfilled by cloning <code>s</code>’s items into it.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>o: Cow&lt;<span class=\"lifetime\">&#39;_</span>, [i32]&gt; = Cow::Owned(<span class=\"macro\">vec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"kw\">let </span>b: Cow&lt;<span class=\"lifetime\">&#39;_</span>, [i32]&gt; = Cow::Borrowed(<span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n<span class=\"macro\">assert_eq!</span>(Vec::from(o), Vec::from(b));</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::borrow::Cow;%0Alet+o:+Cow%3C'_,+%5Bi32%5D%3E+=+Cow::Owned(vec!%5B1,+2,+3%5D);%0Alet+b:+Cow%3C'_,+%5Bi32%5D%3E+=+Cow::Borrowed(%26%5B1,+2,+3%5D);%0Aassert_eq!(Vec::from(o),+Vec::from(b));%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<Cow<'a, [T]>>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CVecDeque%3CT,+A%3E%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.10.0\">1.10.0</span> · <a class=\"src\" href=\"src/alloc/collections/vec_deque/mod.rs.html#2854\">source</a></span><a href=\"#impl-From%3CVecDeque%3CT,+A%3E%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"std/convert/trait.From.html\" title=\"trait std::convert::From\">From</a>&lt;<a class=\"struct\" href=\"std/collections/struct.VecDeque.html\" title=\"struct std::collections::VecDeque\">VecDeque</a>&lt;T, A&gt;&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/collections/vec_deque/mod.rs.html#2884\">source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(other: <a class=\"struct\" href=\"std/collections/struct.VecDeque.html\" title=\"struct std::collections::VecDeque\">VecDeque</a>&lt;T, A&gt;) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;</h4></section></summary><div class=\"docblock\"><p>Turn a <a href=\"std/collections/struct.VecDeque.html\" title=\"struct std::collections::VecDeque\"><code>VecDeque&lt;T&gt;</code></a> into a <a href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\"><code>Vec&lt;T&gt;</code></a>.</p>\n<p>This never needs to re-allocate, but does need to do <em>O</em>(<em>n</em>) data movement if\nthe circular buffer doesn’t happen to be at the beginning of the allocation.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>std::collections::VecDeque;\n\n<span class=\"comment\">// This one is *O*(1).\n</span><span class=\"kw\">let </span>deque: VecDeque&lt;<span class=\"kw\">_</span>&gt; = (<span class=\"number\">1</span>..<span class=\"number\">5</span>).collect();\n<span class=\"kw\">let </span>ptr = deque.as_slices().<span class=\"number\">0</span>.as_ptr();\n<span class=\"kw\">let </span>vec = Vec::from(deque);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);\n<span class=\"macro\">assert_eq!</span>(vec.as_ptr(), ptr);\n\n<span class=\"comment\">// This one needs data rearranging.\n</span><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>deque: VecDeque&lt;<span class=\"kw\">_</span>&gt; = (<span class=\"number\">1</span>..<span class=\"number\">5</span>).collect();\ndeque.push_front(<span class=\"number\">9</span>);\ndeque.push_front(<span class=\"number\">8</span>);\n<span class=\"kw\">let </span>ptr = deque.as_slices().<span class=\"number\">1</span>.as_ptr();\n<span class=\"kw\">let </span>vec = Vec::from(deque);\n<span class=\"macro\">assert_eq!</span>(vec, [<span class=\"number\">8</span>, <span class=\"number\">9</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);\n<span class=\"macro\">assert_eq!</span>(vec.as_ptr(), ptr);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Ause+std::collections::VecDeque;%0A%0A//+This+one+is+*O*(1).%0Alet+deque:+VecDeque%3C_%3E+=+(1..5).collect();%0Alet+ptr+=+deque.as_slices().0.as_ptr();%0Alet+vec+=+Vec::from(deque);%0Aassert_eq!(vec,+%5B1,+2,+3,+4%5D);%0Aassert_eq!(vec.as_ptr(),+ptr);%0A%0A//+This+one+needs+data+rearranging.%0Alet+mut+deque:+VecDeque%3C_%3E+=+(1..5).collect();%0Adeque.push_front(9);%0Adeque.push_front(8);%0Alet+ptr+=+deque.as_slices().1.as_ptr();%0Alet+vec+=+Vec::from(deque);%0Aassert_eq!(vec,+%5B8,+9,+1,+2,+3,+4%5D);%0Aassert_eq!(vec.as_ptr(),+ptr);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details></div></details>","From<VecDeque<T, A>>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3452\">source</a><a href=\"#impl-Debug-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/fmt/trait.Debug.html\" title=\"trait std::fmt::Debug\">Debug</a>,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3453\">source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"std/fmt/struct.Formatter.html\" title=\"struct std::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"enum\" href=\"std/result/enum.Result.html\" title=\"enum std::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"primitive.unit.html\">()</a>, <a class=\"struct\" href=\"std/fmt/struct.Error.html\" title=\"struct std::fmt::Error\">Error</a>&gt;</h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"std/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","std::vec::Vec"],["<section id=\"impl-Eq-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3417\">source</a><a href=\"#impl-Eq-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/cmp/trait.Eq.html\" title=\"trait std::cmp::Eq\">Eq</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/cmp/trait.Eq.html\" title=\"trait std::cmp::Eq\">Eq</a>,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section>","Eq","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-FromIterator%3CT%3E-for-Vec%3CT%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3047\">source</a><a href=\"#impl-FromIterator%3CT%3E-for-Vec%3CT%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T&gt; <a class=\"trait\" href=\"std/iter/trait.FromIterator.html\" title=\"trait std::iter::FromIterator\">FromIterator</a>&lt;T&gt; for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_iter\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3049\">source</a><a href=\"#method.from_iter\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.FromIterator.html#tymethod.from_iter\" class=\"fn\">from_iter</a>&lt;I&gt;(iter: I) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T&gt;<span class=\"where fmt-newline\">where\n    I: <a class=\"trait\" href=\"std/iter/trait.IntoIterator.html\" title=\"trait std::iter::IntoIterator\">IntoIterator</a>&lt;Item = T&gt;,</span></h4></section></summary><div class='docblock'>Creates a value from an iterator. <a href=\"std/iter/trait.FromIterator.html#tymethod.from_iter\">Read more</a></div></details></div></details>","FromIterator<T>","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-IntoIterator-for-Vec%3CT,+A,+FH%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3055\">source</a><a href=\"#impl-IntoIterator-for-Vec%3CT,+A,+FH%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, FH&gt; <a class=\"trait\" href=\"std/iter/trait.IntoIterator.html\" title=\"trait std::iter::IntoIterator\">IntoIterator</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt;<span class=\"where fmt-newline\">where\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a>,\n    FH: <a class=\"trait\" href=\"std/alloc/failure_handling/trait.FailureHandling.html\" title=\"trait std::alloc::failure_handling::FailureHandling\">FailureHandling</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_iter\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#3076\">source</a><a href=\"#method.into_iter\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/iter/trait.IntoIterator.html#tymethod.into_iter\" class=\"fn\">into_iter</a>(self) -&gt; &lt;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A, FH&gt; as <a class=\"trait\" href=\"std/iter/trait.IntoIterator.html\" title=\"trait std::iter::IntoIterator\">IntoIterator</a>&gt;::<a class=\"associatedtype\" href=\"std/iter/trait.IntoIterator.html#associatedtype.IntoIter\" title=\"type std::iter::IntoIterator::IntoIter\">IntoIter</a></h4></section></summary><div class=\"docblock\"><p>Creates a consuming iterator, that is, one that moves each value out of\nthe vector (from start to end). The vector cannot be used after calling\nthis.</p>\n<h5 id=\"examples\"><a href=\"#examples\">Examples</a></h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">vec!</span>[<span class=\"string\">&quot;a&quot;</span>.to_string(), <span class=\"string\">&quot;b&quot;</span>.to_string()];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v_iter = v.into_iter();\n\n<span class=\"kw\">let </span>first_element: <span class=\"prelude-ty\">Option</span>&lt;String&gt; = v_iter.next();\n\n<span class=\"macro\">assert_eq!</span>(first_element, <span class=\"prelude-val\">Some</span>(<span class=\"string\">&quot;a&quot;</span>.to_string()));\n<span class=\"macro\">assert_eq!</span>(v_iter.next(), <span class=\"prelude-val\">Some</span>(<span class=\"string\">&quot;b&quot;</span>.to_string()));\n<span class=\"macro\">assert_eq!</span>(v_iter.next(), <span class=\"prelude-val\">None</span>);</code></pre><a class=\"test-arrow\" target=\"_blank\" href=\"https://play.rust-lang.org/?code=%23!%5Ballow(unused)%5D%0Afn+main()+%7B%0Alet+v+=+vec!%5B%22a%22.to_string(),+%22b%22.to_string()%5D;%0Alet+mut+v_iter+=+v.into_iter();%0A%0Alet+first_element:+Option%3CString%3E+=+v_iter.next();%0A%0Aassert_eq!(first_element,+Some(%22a%22.to_string()));%0Aassert_eq!(v_iter.next(),+Some(%22b%22.to_string()));%0Aassert_eq!(v_iter.next(),+None);%0A%7D&amp;edition=2021\">Run</a></div>\n</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Item\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.Item\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/iter/trait.IntoIterator.html#associatedtype.Item\" class=\"associatedtype\">Item</a> = T</h4></section></summary><div class='docblock'>The type of the elements being iterated over.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.IntoIter\" class=\"associatedtype trait-impl\"><a href=\"#associatedtype.IntoIter\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"std/iter/trait.IntoIterator.html#associatedtype.IntoIter\" class=\"associatedtype\">IntoIter</a> = <a class=\"struct\" href=\"std/vec/struct.IntoIter.html\" title=\"struct std::vec::IntoIter\">IntoIter</a>&lt;T, A&gt;</h4></section></summary><div class='docblock'>Which kind of iterator are we turning this into?</div></details></div></details>","IntoIterator","std::vec::Vec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Clone-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2978\">source</a><a href=\"#impl-Clone-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a> for <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;<span class=\"where fmt-newline\">where\n    T: <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,\n    A: <a class=\"trait\" href=\"std/alloc/trait.Allocator.html\" title=\"trait std::alloc::Allocator\">Allocator</a> + <a class=\"trait\" href=\"std/clone/trait.Clone.html\" title=\"trait std::clone::Clone\">Clone</a>,</span></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2980\">source</a><a href=\"#method.clone\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/clone/trait.Clone.html#tymethod.clone\" class=\"fn\">clone</a>(&amp;self) -&gt; <a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;</h4></section></summary><div class='docblock'>Returns a copy of the value. <a href=\"std/clone/trait.Clone.html#tymethod.clone\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clone_from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/alloc/vec/mod.rs.html#2995\">source</a><a href=\"#method.clone_from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"std/clone/trait.Clone.html#method.clone_from\" class=\"fn\">clone_from</a>(&amp;mut self, other: &amp;<a class=\"struct\" href=\"alloc/vec/struct.Vec.html\" title=\"struct alloc::vec::Vec\">Vec</a>&lt;T, A&gt;)</h4></section></summary><div class='docblock'>Performs copy-assignment from <code>source</code>. <a href=\"std/clone/trait.Clone.html#method.clone_from\">Read more</a></div></details></div></details>","Clone","std::vec::Vec"]]
};if (window.register_type_impls) {window.register_type_impls(type_impls);} else {window.pending_type_impls = type_impls;}})()